/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ui;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.core.Conventions;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelMap
extends LinkedHashMap<String, Object> {
    public ModelMap() {
    }

    public ModelMap(String attributeName, Object attributeValue) {
        this.addAttribute(attributeName, attributeValue);
    }

    public ModelMap(Object attributeValue) {
        this.addAttribute(attributeValue);
    }

    public ModelMap addAttribute(String attributeName, Object attributeValue) {
        Assert.notNull(attributeName, "Model attribute name must not be null");
        this.put(attributeName, attributeValue);
        return this;
    }

    public ModelMap addAttribute(Object attributeValue) {
        Assert.notNull(attributeValue, "Model object must not be null");
        if (attributeValue instanceof Collection && ((Collection)attributeValue).isEmpty()) {
            return this;
        }
        return this.addAttribute(Conventions.getVariableName(attributeValue), attributeValue);
    }

    public ModelMap addAllAttributes(Collection<?> attributeValues) {
        if (attributeValues != null) {
            for (Object attributeValue : attributeValues) {
                this.addAttribute(attributeValue);
            }
        }
        return this;
    }

    public ModelMap addAllAttributes(Map<String, ?> attributes2) {
        if (attributes2 != null) {
            this.putAll(attributes2);
        }
        return this;
    }

    public ModelMap mergeAttributes(Map<String, ?> attributes2) {
        if (attributes2 != null) {
            for (String key : attributes2.keySet()) {
                if (this.containsKey(key)) continue;
                this.put(key, attributes2.get(key));
            }
        }
        return this;
    }

    public boolean containsAttribute(String attributeName) {
        return this.containsKey(attributeName);
    }

    @Deprecated
    public ModelMap addObject(String modelName, Object modelObject) {
        return this.addAttribute(modelName, modelObject);
    }

    @Deprecated
    public ModelMap addObject(Object modelObject) {
        return this.addAttribute(modelObject);
    }

    @Deprecated
    public ModelMap addAllObjects(Collection objects) {
        return this.addAllAttributes(objects);
    }

    @Deprecated
    public ModelMap addAllObjects(Map objects) {
        return this.addAllAttributes(objects);
    }
}

