/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AntPathStringMatcher {
    private static final Pattern GLOB_PATTERN = Pattern.compile("\\?|\\*|\\{((?:\\{[^/]+?\\}|[^/{}]|\\\\[{}])+?)\\}");
    private static final String DEFAULT_VARIABLE_PATTERN = "(.*)";
    private final Pattern pattern;
    private String str;
    private final List<String> variableNames = new LinkedList<String>();
    private final Map<String, String> uriTemplateVariables;

    AntPathStringMatcher(String pattern, String str, Map<String, String> uriTemplateVariables) {
        this.str = str;
        this.uriTemplateVariables = uriTemplateVariables;
        this.pattern = this.createPattern(pattern);
    }

    private Pattern createPattern(String pattern) {
        StringBuilder patternBuilder = new StringBuilder();
        Matcher m = GLOB_PATTERN.matcher(pattern);
        int end2 = 0;
        while (m.find()) {
            patternBuilder.append(this.quote(pattern, end2, m.start()));
            String match = m.group();
            if ("?".equals(match)) {
                patternBuilder.append('.');
            } else if ("*".equals(match)) {
                patternBuilder.append(".*");
            } else if (match.startsWith("{") && match.endsWith("}")) {
                int colonIdx = match.indexOf(58);
                if (colonIdx == -1) {
                    patternBuilder.append(DEFAULT_VARIABLE_PATTERN);
                    this.variableNames.add(m.group(1));
                } else {
                    String variablePattern = match.substring(colonIdx + 1, match.length() - 1);
                    patternBuilder.append('(');
                    patternBuilder.append(variablePattern);
                    patternBuilder.append(')');
                    String variableName = match.substring(1, colonIdx);
                    this.variableNames.add(variableName);
                }
            }
            end2 = m.end();
        }
        patternBuilder.append(this.quote(pattern, end2, pattern.length()));
        return Pattern.compile(patternBuilder.toString());
    }

    private String quote(String s2, int start2, int end2) {
        if (start2 == end2) {
            return "";
        }
        return Pattern.quote(s2.substring(start2, end2));
    }

    public boolean matchStrings() {
        Matcher matcher2 = this.pattern.matcher(this.str);
        if (matcher2.matches()) {
            if (this.uriTemplateVariables != null) {
                Assert.isTrue(this.variableNames.size() == matcher2.groupCount(), "The number of capturing groups in the pattern segment " + this.pattern + " does not match the number of URI template variables it defines, which can occur if " + " capturing groups are used in a URI template regex. Use non-capturing groups instead.");
                int i = 1;
                while (i <= matcher2.groupCount()) {
                    String name = this.variableNames.get(i - 1);
                    String value2 = matcher2.group(i);
                    this.uriTemplateVariables.put(name, value2);
                    ++i;
                }
            }
            return true;
        }
        return false;
    }
}

