/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoPopulatingList<E>
implements List<E>,
Serializable {
    private final List<E> backingList;
    private final ElementFactory<E> elementFactory;

    public AutoPopulatingList(Class<? extends E> elementClass) {
        this(new ArrayList(), elementClass);
    }

    public AutoPopulatingList(List<E> backingList, Class<? extends E> elementClass) {
        this(backingList, new ReflectiveElementFactory<E>(elementClass));
    }

    public AutoPopulatingList(ElementFactory<E> elementFactory) {
        this(new ArrayList(), elementFactory);
    }

    public AutoPopulatingList(List<E> backingList, ElementFactory<E> elementFactory) {
        Assert.notNull(backingList, "Backing List must not be null");
        Assert.notNull(elementFactory, "Element factory must not be null");
        this.backingList = backingList;
        this.elementFactory = elementFactory;
    }

    @Override
    public void add(int index2, E element2) {
        this.backingList.add(index2, element2);
    }

    @Override
    public boolean add(E o) {
        return this.backingList.add(o);
    }

    @Override
    public boolean addAll(Collection<? extends E> c2) {
        return this.backingList.addAll(c2);
    }

    @Override
    public boolean addAll(int index2, Collection<? extends E> c2) {
        return this.backingList.addAll(index2, c2);
    }

    @Override
    public void clear() {
        this.backingList.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.backingList.contains(o);
    }

    @Override
    public boolean containsAll(Collection c2) {
        return this.backingList.containsAll(c2);
    }

    @Override
    public E get(int index2) {
        int backingListSize = this.backingList.size();
        Object element2 = null;
        if (index2 < backingListSize) {
            element2 = this.backingList.get(index2);
            if (element2 == null) {
                element2 = this.elementFactory.createElement(index2);
                this.backingList.set(index2, element2);
            }
        } else {
            int x = backingListSize;
            while (x < index2) {
                this.backingList.add(null);
                ++x;
            }
            element2 = this.elementFactory.createElement(index2);
            this.backingList.add(element2);
        }
        return element2;
    }

    @Override
    public int indexOf(Object o) {
        return this.backingList.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.backingList.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.backingList.iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.backingList.lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.backingList.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index2) {
        return this.backingList.listIterator(index2);
    }

    @Override
    public E remove(int index2) {
        return this.backingList.remove(index2);
    }

    @Override
    public boolean remove(Object o) {
        return this.backingList.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c2) {
        return this.backingList.removeAll(c2);
    }

    @Override
    public boolean retainAll(Collection<?> c2) {
        return this.backingList.retainAll(c2);
    }

    @Override
    public E set(int index2, E element2) {
        return this.backingList.set(index2, element2);
    }

    @Override
    public int size() {
        return this.backingList.size();
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return this.backingList.subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.backingList.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a2) {
        return this.backingList.toArray(a2);
    }

    @Override
    public boolean equals(Object other) {
        return this.backingList.equals(other);
    }

    @Override
    public int hashCode() {
        return this.backingList.hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ElementFactory<E> {
        public E createElement(int var1) throws ElementInstantiationException;
    }

    public static class ElementInstantiationException
    extends RuntimeException {
        public ElementInstantiationException(String msg) {
            super(msg);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ReflectiveElementFactory<E>
    implements ElementFactory<E>,
    Serializable {
        private final Class<? extends E> elementClass;

        public ReflectiveElementFactory(Class<? extends E> elementClass) {
            Assert.notNull(elementClass, "Element clas must not be null");
            Assert.isTrue(!elementClass.isInterface(), "Element class must not be an interface type");
            Assert.isTrue(!Modifier.isAbstract(elementClass.getModifiers()), "Element class cannot be an abstract class");
            this.elementClass = elementClass;
        }

        @Override
        public E createElement(int index2) {
            try {
                return this.elementClass.newInstance();
            }
            catch (InstantiationException ex2) {
                throw new ElementInstantiationException("Unable to instantiate element class [" + this.elementClass.getName() + "]. Root cause is " + ex2);
            }
            catch (IllegalAccessException ex3) {
                throw new ElementInstantiationException("Cannot access element class [" + this.elementClass.getName() + "]. Root cause is " + ex3);
            }
        }
    }
}

