/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.beans.Introspector;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.security.AccessControlException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClassUtils {
    public static final String ARRAY_SUFFIX = "[]";
    private static final String INTERNAL_ARRAY_PREFIX = "[";
    private static final String NON_PRIMITIVE_ARRAY_PREFIX = "[L";
    private static final char PACKAGE_SEPARATOR = '.';
    private static final char INNER_CLASS_SEPARATOR = '$';
    public static final String CGLIB_CLASS_SEPARATOR = "$$";
    public static final String CLASS_FILE_SUFFIX = ".class";
    private static final Map<Class<?>, Class<?>> primitiveWrapperTypeMap = new HashMap(8);
    private static final Map<Class<?>, Class<?>> primitiveTypeToWrapperMap = new HashMap(8);
    private static final Map<String, Class<?>> primitiveTypeNameMap = new HashMap(32);
    private static final Map<String, Class<?>> commonClassCache = new HashMap(32);

    static {
        primitiveWrapperTypeMap.put(Boolean.class, Boolean.TYPE);
        primitiveWrapperTypeMap.put(Byte.class, Byte.TYPE);
        primitiveWrapperTypeMap.put(Character.class, Character.TYPE);
        primitiveWrapperTypeMap.put(Double.class, Double.TYPE);
        primitiveWrapperTypeMap.put(Float.class, Float.TYPE);
        primitiveWrapperTypeMap.put(Integer.class, Integer.TYPE);
        primitiveWrapperTypeMap.put(Long.class, Long.TYPE);
        primitiveWrapperTypeMap.put(Short.class, Short.TYPE);
        for (Map.Entry<Class<?>, Class<?>> entry2 : primitiveWrapperTypeMap.entrySet()) {
            primitiveTypeToWrapperMap.put(entry2.getValue(), entry2.getKey());
            ClassUtils.registerCommonClasses(entry2.getKey());
        }
        HashSet primitiveTypes = new HashSet(32);
        primitiveTypes.addAll(primitiveWrapperTypeMap.values());
        primitiveTypes.addAll((Collection)Arrays.asList(boolean[].class, byte[].class, char[].class, double[].class, float[].class, int[].class, long[].class, short[].class));
        primitiveTypes.add(Void.TYPE);
        for (Class clazz2 : primitiveTypes) {
            primitiveTypeNameMap.put(clazz2.getName(), clazz2);
        }
        ClassUtils.registerCommonClasses(Boolean[].class, Byte[].class, Character[].class, Double[].class, Float[].class, Integer[].class, Long[].class, Short[].class);
        ClassUtils.registerCommonClasses(Number.class, Number[].class, String.class, String[].class, Object.class, Object[].class, Class.class, Class[].class);
        ClassUtils.registerCommonClasses(Throwable.class, Exception.class, RuntimeException.class, Error.class, StackTraceElement.class, StackTraceElement[].class);
    }

    private static void registerCommonClasses(Class<?> ... commonClasses) {
        Class<?>[] classArray = commonClasses;
        int n = commonClasses.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> clazz2 = classArray[n2];
            commonClassCache.put(clazz2.getName(), clazz2);
            ++n2;
        }
    }

    public static ClassLoader getDefaultClassLoader() {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable2) {}
        if (cl == null) {
            cl = ClassUtils.class.getClassLoader();
        }
        return cl;
    }

    public static ClassLoader overrideThreadContextClassLoader(ClassLoader classLoaderToUse) {
        Thread currentThread = Thread.currentThread();
        ClassLoader threadContextClassLoader = currentThread.getContextClassLoader();
        if (classLoaderToUse != null && !classLoaderToUse.equals(threadContextClassLoader)) {
            currentThread.setContextClassLoader(classLoaderToUse);
            return threadContextClassLoader;
        }
        return null;
    }

    @Deprecated
    public static Class<?> forName(String name) throws ClassNotFoundException, LinkageError {
        return ClassUtils.forName(name, ClassUtils.getDefaultClassLoader());
    }

    public static Class<?> forName(String name, ClassLoader classLoader) throws ClassNotFoundException, LinkageError {
        Assert.notNull(name, "Name must not be null");
        Class<?> clazz2 = ClassUtils.resolvePrimitiveClassName(name);
        if (clazz2 == null) {
            clazz2 = commonClassCache.get(name);
        }
        if (clazz2 != null) {
            return clazz2;
        }
        if (name.endsWith(ARRAY_SUFFIX)) {
            String elementClassName = name.substring(0, name.length() - ARRAY_SUFFIX.length());
            Class<?> elementClass = ClassUtils.forName(elementClassName, classLoader);
            return Array.newInstance(elementClass, 0).getClass();
        }
        if (name.startsWith(NON_PRIMITIVE_ARRAY_PREFIX) && name.endsWith(";")) {
            String elementName = name.substring(NON_PRIMITIVE_ARRAY_PREFIX.length(), name.length() - 1);
            Class<?> elementClass = ClassUtils.forName(elementName, classLoader);
            return Array.newInstance(elementClass, 0).getClass();
        }
        if (name.startsWith(INTERNAL_ARRAY_PREFIX)) {
            String elementName = name.substring(INTERNAL_ARRAY_PREFIX.length());
            Class<?> elementClass = ClassUtils.forName(elementName, classLoader);
            return Array.newInstance(elementClass, 0).getClass();
        }
        ClassLoader classLoaderToUse = classLoader;
        if (classLoaderToUse == null) {
            classLoaderToUse = ClassUtils.getDefaultClassLoader();
        }
        try {
            return classLoaderToUse.loadClass(name);
        }
        catch (ClassNotFoundException ex2) {
            int lastDotIndex = name.lastIndexOf(46);
            if (lastDotIndex != -1) {
                String innerClassName = String.valueOf(name.substring(0, lastDotIndex)) + '$' + name.substring(lastDotIndex + 1);
                try {
                    return classLoaderToUse.loadClass(innerClassName);
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
            throw ex2;
        }
    }

    public static Class<?> resolveClassName(String className, ClassLoader classLoader) throws IllegalArgumentException {
        try {
            return ClassUtils.forName(className, classLoader);
        }
        catch (ClassNotFoundException ex2) {
            throw new IllegalArgumentException("Cannot find class [" + className + "]", ex2);
        }
        catch (LinkageError ex3) {
            throw new IllegalArgumentException("Error loading class [" + className + "]: problem with class file or dependent class.", ex3);
        }
    }

    public static Class<?> resolvePrimitiveClassName(String name) {
        Class<?> result2 = null;
        if (name != null && name.length() <= 8) {
            result2 = primitiveTypeNameMap.get(name);
        }
        return result2;
    }

    @Deprecated
    public static boolean isPresent(String className) {
        return ClassUtils.isPresent(className, ClassUtils.getDefaultClassLoader());
    }

    public static boolean isPresent(String className, ClassLoader classLoader) {
        try {
            ClassUtils.forName(className, classLoader);
            return true;
        }
        catch (Throwable throwable2) {
            return false;
        }
    }

    public static Class<?> getUserClass(Object instance) {
        Assert.notNull(instance, "Instance must not be null");
        return ClassUtils.getUserClass(instance.getClass());
    }

    public static Class<?> getUserClass(Class<?> clazz2) {
        Class<?> superClass;
        if (clazz2 != null && clazz2.getName().contains(CGLIB_CLASS_SEPARATOR) && (superClass = clazz2.getSuperclass()) != null && !Object.class.equals(superClass)) {
            return superClass;
        }
        return clazz2;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isCacheSafe(Class<?> clazz, ClassLoader classLoader) {
        Assert.notNull(clazz, "Class must not be null");
        target = clazz.getClassLoader();
        if (target == null) {
            return false;
        }
        cur = classLoader;
        if (cur != target) ** GOTO lbl10
        return true;
lbl-1000:
        // 1 sources

        {
            if ((cur = cur.getParent()) != target) continue;
            return true;
lbl10:
            // 2 sources

            ** while (cur != null)
        }
lbl11:
        // 1 sources

        return false;
    }

    public static String getShortName(String className) {
        Assert.hasLength(className, "Class name must not be empty");
        int lastDotIndex = className.lastIndexOf(46);
        int nameEndIndex = className.indexOf(CGLIB_CLASS_SEPARATOR);
        if (nameEndIndex == -1) {
            nameEndIndex = className.length();
        }
        String shortName = className.substring(lastDotIndex + 1, nameEndIndex);
        shortName = shortName.replace('$', '.');
        return shortName;
    }

    public static String getShortName(Class<?> clazz2) {
        return ClassUtils.getShortName(ClassUtils.getQualifiedName(clazz2));
    }

    public static String getShortNameAsProperty(Class<?> clazz2) {
        String shortName = ClassUtils.getShortName(clazz2);
        int dotIndex = shortName.lastIndexOf(46);
        shortName = dotIndex != -1 ? shortName.substring(dotIndex + 1) : shortName;
        return Introspector.decapitalize(shortName);
    }

    public static String getClassFileName(Class<?> clazz2) {
        Assert.notNull(clazz2, "Class must not be null");
        String className = clazz2.getName();
        int lastDotIndex = className.lastIndexOf(46);
        return String.valueOf(className.substring(lastDotIndex + 1)) + CLASS_FILE_SUFFIX;
    }

    public static String getPackageName(Class<?> clazz2) {
        Assert.notNull(clazz2, "Class must not be null");
        String className = clazz2.getName();
        int lastDotIndex = className.lastIndexOf(46);
        return lastDotIndex != -1 ? className.substring(0, lastDotIndex) : "";
    }

    public static String getQualifiedName(Class<?> clazz2) {
        Assert.notNull(clazz2, "Class must not be null");
        if (clazz2.isArray()) {
            return ClassUtils.getQualifiedNameForArray(clazz2);
        }
        return clazz2.getName();
    }

    private static String getQualifiedNameForArray(Class<?> clazz2) {
        StringBuilder result2 = new StringBuilder();
        while (clazz2.isArray()) {
            clazz2 = clazz2.getComponentType();
            result2.append(ARRAY_SUFFIX);
        }
        result2.insert(0, clazz2.getName());
        return result2.toString();
    }

    public static String getQualifiedMethodName(Method method) {
        Assert.notNull(method, "Method must not be null");
        return String.valueOf(method.getDeclaringClass().getName()) + "." + method.getName();
    }

    public static String getDescriptiveType(Object value2) {
        if (value2 == null) {
            return null;
        }
        Class<?> clazz2 = value2.getClass();
        if (Proxy.isProxyClass(clazz2)) {
            StringBuilder result2 = new StringBuilder(clazz2.getName());
            result2.append(" implementing ");
            Class<?>[] ifcs = clazz2.getInterfaces();
            int i = 0;
            while (i < ifcs.length) {
                result2.append(ifcs[i].getName());
                if (i < ifcs.length - 1) {
                    result2.append(',');
                }
                ++i;
            }
            return result2.toString();
        }
        if (clazz2.isArray()) {
            return ClassUtils.getQualifiedNameForArray(clazz2);
        }
        return clazz2.getName();
    }

    public static boolean matchesTypeName(Class<?> clazz2, String typeName) {
        return typeName != null && (typeName.equals(clazz2.getName()) || typeName.equals(clazz2.getSimpleName()) || clazz2.isArray() && typeName.equals(ClassUtils.getQualifiedNameForArray(clazz2)));
    }

    public static boolean hasConstructor(Class<?> clazz2, Class<?> ... paramTypes2) {
        return ClassUtils.getConstructorIfAvailable(clazz2, paramTypes2) != null;
    }

    public static <T> Constructor<T> getConstructorIfAvailable(Class<T> clazz2, Class<?> ... paramTypes2) {
        Assert.notNull(clazz2, "Class must not be null");
        try {
            return clazz2.getConstructor(paramTypes2);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static boolean hasMethod(Class<?> clazz2, String methodName, Class<?> ... paramTypes2) {
        return ClassUtils.getMethodIfAvailable(clazz2, methodName, paramTypes2) != null;
    }

    public static Method getMethod(Class<?> clazz2, String methodName, Class<?> ... paramTypes2) {
        Assert.notNull(clazz2, "Class must not be null");
        Assert.notNull(methodName, "Method name must not be null");
        try {
            return clazz2.getMethod(methodName, paramTypes2);
        }
        catch (NoSuchMethodException ex2) {
            throw new IllegalStateException("Expected method not found: " + ex2);
        }
    }

    public static Method getMethodIfAvailable(Class<?> clazz2, String methodName, Class<?> ... paramTypes2) {
        Assert.notNull(clazz2, "Class must not be null");
        Assert.notNull(methodName, "Method name must not be null");
        try {
            return clazz2.getMethod(methodName, paramTypes2);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static int getMethodCountForName(Class<?> clazz2, String methodName) {
        Class<?>[] ifcs;
        Method[] declaredMethods;
        Assert.notNull(clazz2, "Class must not be null");
        Assert.notNull(methodName, "Method name must not be null");
        int count2 = 0;
        Method[] methodArray = declaredMethods = clazz2.getDeclaredMethods();
        int n = declaredMethods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (methodName.equals(method.getName())) {
                ++count2;
            }
            ++n2;
        }
        Class<?>[] classArray = ifcs = clazz2.getInterfaces();
        int n3 = ifcs.length;
        n = 0;
        while (n < n3) {
            Class<?> ifc = classArray[n];
            count2 += ClassUtils.getMethodCountForName(ifc, methodName);
            ++n;
        }
        if (clazz2.getSuperclass() != null) {
            count2 += ClassUtils.getMethodCountForName(clazz2.getSuperclass(), methodName);
        }
        return count2;
    }

    public static boolean hasAtLeastOneMethodWithName(Class<?> clazz2, String methodName) {
        Class<?>[] ifcs;
        Method[] declaredMethods;
        Assert.notNull(clazz2, "Class must not be null");
        Assert.notNull(methodName, "Method name must not be null");
        Method[] methodArray = declaredMethods = clazz2.getDeclaredMethods();
        int n = declaredMethods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getName().equals(methodName)) {
                return true;
            }
            ++n2;
        }
        Class<?>[] classArray = ifcs = clazz2.getInterfaces();
        int n3 = ifcs.length;
        n = 0;
        while (n < n3) {
            Class<?> ifc = classArray[n];
            if (ClassUtils.hasAtLeastOneMethodWithName(ifc, methodName)) {
                return true;
            }
            ++n;
        }
        return clazz2.getSuperclass() != null && ClassUtils.hasAtLeastOneMethodWithName(clazz2.getSuperclass(), methodName);
    }

    public static Method getMostSpecificMethod(Method method, Class<?> targetClass) {
        Method specificMethod = null;
        if (method != null && ClassUtils.isOverridable(method, targetClass) && targetClass != null && !targetClass.equals(method.getDeclaringClass())) {
            try {
                specificMethod = ReflectionUtils.findMethod(targetClass, method.getName(), method.getParameterTypes());
            }
            catch (AccessControlException accessControlException) {}
        }
        return specificMethod != null ? specificMethod : method;
    }

    private static boolean isOverridable(Method method, Class targetClass) {
        if (Modifier.isPrivate(method.getModifiers())) {
            return false;
        }
        if (Modifier.isPublic(method.getModifiers()) || Modifier.isProtected(method.getModifiers())) {
            return true;
        }
        return ClassUtils.getPackageName(method.getDeclaringClass()).equals(ClassUtils.getPackageName(targetClass));
    }

    public static Method getStaticMethod(Class<?> clazz2, String methodName, Class<?> ... args2) {
        Assert.notNull(clazz2, "Class must not be null");
        Assert.notNull(methodName, "Method name must not be null");
        try {
            Method method = clazz2.getMethod(methodName, args2);
            return Modifier.isStatic(method.getModifiers()) ? method : null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static boolean isPrimitiveWrapper(Class<?> clazz2) {
        Assert.notNull(clazz2, "Class must not be null");
        return primitiveWrapperTypeMap.containsKey(clazz2);
    }

    public static boolean isPrimitiveOrWrapper(Class<?> clazz2) {
        Assert.notNull(clazz2, "Class must not be null");
        return clazz2.isPrimitive() || ClassUtils.isPrimitiveWrapper(clazz2);
    }

    public static boolean isPrimitiveArray(Class<?> clazz2) {
        Assert.notNull(clazz2, "Class must not be null");
        return clazz2.isArray() && clazz2.getComponentType().isPrimitive();
    }

    public static boolean isPrimitiveWrapperArray(Class<?> clazz2) {
        Assert.notNull(clazz2, "Class must not be null");
        return clazz2.isArray() && ClassUtils.isPrimitiveWrapper(clazz2.getComponentType());
    }

    public static Class<?> resolvePrimitiveIfNecessary(Class<?> clazz2) {
        Assert.notNull(clazz2, "Class must not be null");
        return clazz2.isPrimitive() && clazz2 != Void.TYPE ? primitiveTypeToWrapperMap.get(clazz2) : clazz2;
    }

    public static boolean isAssignable(Class<?> lhsType, Class<?> rhsType) {
        Class<?> resolvedWrapper;
        Class<?> resolvedPrimitive;
        Assert.notNull(lhsType, "Left-hand side type must not be null");
        Assert.notNull(rhsType, "Right-hand side type must not be null");
        if (lhsType.isAssignableFrom(rhsType)) {
            return true;
        }
        return lhsType.isPrimitive() ? (resolvedPrimitive = primitiveWrapperTypeMap.get(rhsType)) != null && lhsType.equals(resolvedPrimitive) : (resolvedWrapper = primitiveTypeToWrapperMap.get(rhsType)) != null && lhsType.isAssignableFrom(resolvedWrapper);
    }

    public static boolean isAssignableValue(Class<?> type, Object value2) {
        Assert.notNull(type, "Type must not be null");
        return value2 != null ? ClassUtils.isAssignable(type, value2.getClass()) : !type.isPrimitive();
    }

    public static String convertResourcePathToClassName(String resourcePath) {
        Assert.notNull(resourcePath, "Resource path must not be null");
        return resourcePath.replace('/', '.');
    }

    public static String convertClassNameToResourcePath(String className) {
        Assert.notNull(className, "Class name must not be null");
        return className.replace('.', '/');
    }

    public static String addResourcePathToPackagePath(Class<?> clazz2, String resourceName) {
        Assert.notNull(resourceName, "Resource name must not be null");
        if (!resourceName.startsWith("/")) {
            return String.valueOf(ClassUtils.classPackageAsResourcePath(clazz2)) + "/" + resourceName;
        }
        return String.valueOf(ClassUtils.classPackageAsResourcePath(clazz2)) + resourceName;
    }

    public static String classPackageAsResourcePath(Class<?> clazz2) {
        if (clazz2 == null) {
            return "";
        }
        String className = clazz2.getName();
        int packageEndIndex = className.lastIndexOf(46);
        if (packageEndIndex == -1) {
            return "";
        }
        String packageName = className.substring(0, packageEndIndex);
        return packageName.replace('.', '/');
    }

    public static String classNamesToString(Class ... classes2) {
        return ClassUtils.classNamesToString((Collection<Class>)Arrays.asList(classes2));
    }

    public static String classNamesToString(Collection<Class> classes2) {
        if (CollectionUtils.isEmpty(classes2)) {
            return ARRAY_SUFFIX;
        }
        StringBuilder sb = new StringBuilder(INTERNAL_ARRAY_PREFIX);
        Iterator<Class> it = classes2.iterator();
        while (it.hasNext()) {
            Class clazz2 = it.next();
            sb.append(clazz2.getName());
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    public static Class<?>[] toClassArray(Collection<Class<?>> collection) {
        if (collection == null) {
            return null;
        }
        return collection.toArray(new Class[collection.size()]);
    }

    public static Class[] getAllInterfaces(Object instance) {
        Assert.notNull(instance, "Instance must not be null");
        return ClassUtils.getAllInterfacesForClass(instance.getClass());
    }

    public static Class<?>[] getAllInterfacesForClass(Class<?> clazz2) {
        return ClassUtils.getAllInterfacesForClass(clazz2, null);
    }

    public static Class<?>[] getAllInterfacesForClass(Class<?> clazz2, ClassLoader classLoader) {
        Set<Class> ifcs = ClassUtils.getAllInterfacesForClassAsSet(clazz2, classLoader);
        return ifcs.toArray(new Class[ifcs.size()]);
    }

    public static Set<Class> getAllInterfacesAsSet(Object instance) {
        Assert.notNull(instance, "Instance must not be null");
        return ClassUtils.getAllInterfacesForClassAsSet(instance.getClass());
    }

    public static Set<Class> getAllInterfacesForClassAsSet(Class clazz2) {
        return ClassUtils.getAllInterfacesForClassAsSet(clazz2, null);
    }

    public static Set<Class> getAllInterfacesForClassAsSet(Class clazz2, ClassLoader classLoader) {
        Assert.notNull(clazz2, "Class must not be null");
        if (clazz2.isInterface() && ClassUtils.isVisible(clazz2, classLoader)) {
            return Collections.singleton(clazz2);
        }
        LinkedHashSet<Class> interfaces2 = new LinkedHashSet<Class>();
        while (clazz2 != null) {
            Class<?>[] ifcs;
            Class<?>[] classArray = ifcs = clazz2.getInterfaces();
            int n = ifcs.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> ifc = classArray[n2];
                interfaces2.addAll(ClassUtils.getAllInterfacesForClassAsSet(ifc, classLoader));
                ++n2;
            }
            clazz2 = clazz2.getSuperclass();
        }
        return interfaces2;
    }

    public static Class<?> createCompositeInterface(Class<?>[] interfaces2, ClassLoader classLoader) {
        Assert.notEmpty(interfaces2, "Interfaces must not be empty");
        Assert.notNull(classLoader, "ClassLoader must not be null");
        return Proxy.getProxyClass(classLoader, interfaces2);
    }

    public static boolean isVisible(Class<?> clazz2, ClassLoader classLoader) {
        if (classLoader == null) {
            return true;
        }
        try {
            Class<?> actualClass = classLoader.loadClass(clazz2.getName());
            return clazz2 == actualClass;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static boolean isCglibProxy(Object object) {
        return ClassUtils.isCglibProxyClass(object.getClass());
    }

    public static boolean isCglibProxyClass(Class<?> clazz2) {
        return clazz2 != null && ClassUtils.isCglibProxyClassName(clazz2.getName());
    }

    public static boolean isCglibProxyClassName(String className) {
        return className != null && className.contains(CGLIB_CLASS_SEPARATOR);
    }
}

