/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CollectionUtils {
    public static boolean isEmpty(Collection collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEmpty(Map map3) {
        return map3 == null || map3.isEmpty();
    }

    public static List arrayToList(Object source) {
        return Arrays.asList(ObjectUtils.toObjectArray(source));
    }

    public static void mergeArrayIntoCollection(Object array2, Collection collection) {
        Object[] arr;
        if (collection == null) {
            throw new IllegalArgumentException("Collection must not be null");
        }
        Object[] objectArray = arr = ObjectUtils.toObjectArray(array2);
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            Object elem2 = objectArray[n2];
            collection.add(elem2);
            ++n2;
        }
    }

    public static void mergePropertiesIntoMap(Properties props, Map map3) {
        if (map3 == null) {
            throw new IllegalArgumentException("Map must not be null");
        }
        if (props != null) {
            Enumeration<?> en = props.propertyNames();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                Object value2 = props.getProperty(key);
                if (value2 == null) {
                    value2 = props.get(key);
                }
                map3.put(key, value2);
            }
        }
    }

    public static boolean contains(Iterator iterator2, Object element2) {
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                Object candidate = iterator2.next();
                if (!ObjectUtils.nullSafeEquals(candidate, element2)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean contains(Enumeration enumeration, Object element2) {
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                Object candidate = enumeration.nextElement();
                if (!ObjectUtils.nullSafeEquals(candidate, element2)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsInstance(Collection collection, Object element2) {
        if (collection != null) {
            for (Object candidate : collection) {
                if (candidate != element2) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsAny(Collection source, Collection candidates) {
        if (CollectionUtils.isEmpty(source) || CollectionUtils.isEmpty(candidates)) {
            return false;
        }
        for (Object candidate : candidates) {
            if (!source.contains(candidate)) continue;
            return true;
        }
        return false;
    }

    public static Object findFirstMatch(Collection source, Collection candidates) {
        if (CollectionUtils.isEmpty(source) || CollectionUtils.isEmpty(candidates)) {
            return null;
        }
        for (Object candidate : candidates) {
            if (!source.contains(candidate)) continue;
            return candidate;
        }
        return null;
    }

    public static <T> T findValueOfType(Collection<?> collection, Class<T> type) {
        if (CollectionUtils.isEmpty(collection)) {
            return null;
        }
        T value2 = null;
        for (Object element2 : collection) {
            if (type != null && !type.isInstance(element2)) continue;
            if (value2 != null) {
                return null;
            }
            value2 = (T)element2;
        }
        return value2;
    }

    public static Object findValueOfType(Collection<?> collection, Class<?>[] types2) {
        if (CollectionUtils.isEmpty(collection) || ObjectUtils.isEmpty(types2)) {
            return null;
        }
        Class<?>[] classArray = types2;
        int n = types2.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> type = classArray[n2];
            Object value2 = CollectionUtils.findValueOfType(collection, type);
            if (value2 != null) {
                return value2;
            }
            ++n2;
        }
        return null;
    }

    public static boolean hasUniqueObject(Collection collection) {
        if (CollectionUtils.isEmpty(collection)) {
            return false;
        }
        boolean hasCandidate = false;
        Object candidate = null;
        for (Object elem2 : collection) {
            if (!hasCandidate) {
                hasCandidate = true;
                candidate = elem2;
                continue;
            }
            if (candidate == elem2) continue;
            return false;
        }
        return true;
    }

    public static Class<?> findCommonElementType(Collection collection) {
        if (CollectionUtils.isEmpty(collection)) {
            return null;
        }
        Class<?> candidate = null;
        for (Object val : collection) {
            if (val == null) continue;
            if (candidate == null) {
                candidate = val.getClass();
                continue;
            }
            if (candidate == val.getClass()) continue;
            return null;
        }
        return candidate;
    }

    public static <A, E extends A> A[] toArray(Enumeration<E> enumeration, A[] array2) {
        ArrayList<E> elements = new ArrayList<E>();
        while (enumeration.hasMoreElements()) {
            elements.add(enumeration.nextElement());
        }
        return elements.toArray(array2);
    }

    public static <E> Iterator<E> toIterator(Enumeration<E> enumeration) {
        return new EnumerationIterator<E>(enumeration);
    }

    public static <K, V> MultiValueMap<K, V> toMultiValueMap(Map<K, List<V>> map3) {
        return new MultiValueMapAdapter<K, V>(map3);
    }

    public static <K, V> MultiValueMap<K, V> unmodifiableMultiValueMap(MultiValueMap<? extends K, ? extends V> map3) {
        Assert.notNull(map3, "'map' must not be null");
        LinkedHashMap result2 = new LinkedHashMap(map3.size());
        for (Map.Entry entry2 : map3.entrySet()) {
            List values2 = Collections.unmodifiableList((List)entry2.getValue());
            result2.put(entry2.getKey(), values2);
        }
        Map unmodifiableMap = Collections.unmodifiableMap(result2);
        return CollectionUtils.toMultiValueMap(unmodifiableMap);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EnumerationIterator<E>
    implements Iterator<E> {
        private Enumeration<E> enumeration;

        public EnumerationIterator(Enumeration<E> enumeration) {
            this.enumeration = enumeration;
        }

        @Override
        public boolean hasNext() {
            return this.enumeration.hasMoreElements();
        }

        @Override
        public E next() {
            return this.enumeration.nextElement();
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Not supported");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MultiValueMapAdapter<K, V>
    implements MultiValueMap<K, V>,
    Serializable {
        private final Map<K, List<V>> map;

        public MultiValueMapAdapter(Map<K, List<V>> map3) {
            Assert.notNull(map3, "'map' must not be null");
            this.map = map3;
        }

        @Override
        public void add(K key, V value2) {
            List<V> values2 = this.map.get(key);
            if (values2 == null) {
                values2 = new LinkedList<V>();
                this.map.put(key, values2);
            }
            values2.add(value2);
        }

        @Override
        public V getFirst(K key) {
            List<V> values2 = this.map.get(key);
            return values2 != null ? (V)values2.get(0) : null;
        }

        @Override
        public void set(K key, V value2) {
            LinkedList<V> values2 = new LinkedList<V>();
            values2.add(value2);
            this.map.put(key, values2);
        }

        @Override
        public void setAll(Map<K, V> values2) {
            for (Map.Entry<K, V> entry2 : values2.entrySet()) {
                this.set(entry2.getKey(), entry2.getValue());
            }
        }

        @Override
        public Map<K, V> toSingleValueMap() {
            LinkedHashMap<K, V> singleValueMap = new LinkedHashMap<K, V>(this.map.size());
            for (Map.Entry<K, List<V>> entry2 : this.map.entrySet()) {
                singleValueMap.put(entry2.getKey(), entry2.getValue().get(0));
            }
            return singleValueMap;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.map.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value2) {
            return this.map.containsValue(value2);
        }

        @Override
        public List<V> get(Object key) {
            return this.map.get(key);
        }

        @Override
        public List<V> put(K key, List<V> value2) {
            return this.map.put(key, value2);
        }

        @Override
        public List<V> remove(Object key) {
            return this.map.remove(key);
        }

        @Override
        public void putAll(Map<? extends K, ? extends List<V>> m) {
            this.map.putAll(m);
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public Set<K> keySet() {
            return this.map.keySet();
        }

        @Override
        public Collection<List<V>> values() {
            return this.map.values();
        }

        @Override
        public Set<Map.Entry<K, List<V>>> entrySet() {
            return this.map.entrySet();
        }

        @Override
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return this.map.equals(other);
        }

        @Override
        public int hashCode() {
            return this.map.hashCode();
        }

        public String toString() {
            return this.map.toString();
        }
    }
}

