/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeIterator<E>
implements Iterator<E> {
    private List<Iterator<E>> iterators = new LinkedList<Iterator<E>>();
    private boolean inUse = false;

    public void add(Iterator<E> iterator2) {
        Assert.state(!this.inUse, "You can no longer add iterator to a composite iterator that's already in use");
        if (this.iterators.contains(iterator2)) {
            throw new IllegalArgumentException("You cannot add the same iterator twice");
        }
        this.iterators.add(iterator2);
    }

    @Override
    public boolean hasNext() {
        this.inUse = true;
        Iterator<Iterator<E>> it = this.iterators.iterator();
        while (it.hasNext()) {
            if (!it.next().hasNext()) continue;
            return true;
        }
        return false;
    }

    @Override
    public E next() {
        this.inUse = true;
        for (Iterator<E> iterator2 : this.iterators) {
            if (!iterator2.hasNext()) continue;
            return iterator2.next();
        }
        throw new NoSuchElementException("Exhaused all iterators");
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove is not supported");
    }
}

