/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import org.springframework.util.ClassUtils;
import org.springframework.util.PropertiesPersister;
import org.springframework.util.StringUtils;

public class DefaultPropertiesPersister
implements PropertiesPersister {
    private static final boolean loadFromReaderAvailable = ClassUtils.hasMethod(Properties.class, "load", Reader.class);
    private static final boolean storeToWriterAvailable = ClassUtils.hasMethod(Properties.class, "store", Writer.class, String.class);

    public void load(Properties props, InputStream is2) throws IOException {
        props.load(is2);
    }

    public void load(Properties props, Reader reader2) throws IOException {
        if (loadFromReaderAvailable) {
            props.load(reader2);
        } else {
            this.doLoad(props, reader2);
        }
    }

    protected void doLoad(Properties props, Reader reader2) throws IOException {
        BufferedReader in2 = new BufferedReader(reader2);
        String line;
        while ((line = in2.readLine()) != null) {
            char firstChar;
            if ((line = StringUtils.trimLeadingWhitespace(line)).length() <= 0 || (firstChar = line.charAt(0)) == '#' || firstChar == '!') continue;
            while (this.endsWithContinuationMarker(line)) {
                String nextLine = in2.readLine();
                line = line.substring(0, line.length() - 1);
                if (nextLine == null) continue;
                line = String.valueOf(line) + StringUtils.trimLeadingWhitespace(nextLine);
            }
            int separatorIndex = line.indexOf("=");
            if (separatorIndex == -1) {
                separatorIndex = line.indexOf(":");
            }
            String key = separatorIndex != -1 ? line.substring(0, separatorIndex) : line;
            String value2 = separatorIndex != -1 ? line.substring(separatorIndex + 1) : "";
            key = StringUtils.trimTrailingWhitespace(key);
            value2 = StringUtils.trimLeadingWhitespace(value2);
            props.put(this.unescape(key), this.unescape(value2));
        }
        return;
    }

    protected boolean endsWithContinuationMarker(String line) {
        boolean evenSlashCount = true;
        int index2 = line.length() - 1;
        while (index2 >= 0 && line.charAt(index2) == '\\') {
            evenSlashCount = !evenSlashCount;
            --index2;
        }
        return !evenSlashCount;
    }

    protected String unescape(String str) {
        StringBuilder result2 = new StringBuilder(str.length());
        int index2 = 0;
        while (index2 < str.length()) {
            int c2;
            if ((c2 = str.charAt(index2++)) == 92) {
                if ((c2 = str.charAt(index2++)) == 116) {
                    c2 = 9;
                } else if (c2 == 114) {
                    c2 = 13;
                } else if (c2 == 110) {
                    c2 = 10;
                } else if (c2 == 102) {
                    c2 = 12;
                }
            }
            result2.append((char)c2);
        }
        return result2.toString();
    }

    public void store(Properties props, OutputStream os2, String header) throws IOException {
        props.store(os2, header);
    }

    public void store(Properties props, Writer writer, String header) throws IOException {
        if (storeToWriterAvailable) {
            props.store(writer, header);
        } else {
            this.doStore(props, writer, header);
        }
    }

    protected void doStore(Properties props, Writer writer, String header) throws IOException {
        BufferedWriter out = new BufferedWriter(writer);
        if (header != null) {
            out.write("#" + header);
            out.newLine();
        }
        out.write("#" + new Date());
        out.newLine();
        Enumeration<Object> keys2 = props.keys();
        while (keys2.hasMoreElements()) {
            String key = (String)keys2.nextElement();
            String val = props.getProperty(key);
            out.write(String.valueOf(this.escape(key, true)) + "=" + this.escape(val, false));
            out.newLine();
        }
        out.flush();
    }

    protected String escape(String str, boolean isKey) {
        int len2 = str.length();
        StringBuilder result2 = new StringBuilder(len2 * 2);
        int index2 = 0;
        while (index2 < len2) {
            char c2 = str.charAt(index2);
            switch (c2) {
                case ' ': {
                    if (index2 == 0 || isKey) {
                        result2.append('\\');
                    }
                    result2.append(' ');
                    break;
                }
                case '\\': {
                    result2.append("\\\\");
                    break;
                }
                case '\t': {
                    result2.append("\\t");
                    break;
                }
                case '\n': {
                    result2.append("\\n");
                    break;
                }
                case '\r': {
                    result2.append("\\r");
                    break;
                }
                case '\f': {
                    result2.append("\\f");
                    break;
                }
                default: {
                    if ("=: \t\r\n\f#!".indexOf(c2) != -1) {
                        result2.append('\\');
                    }
                    result2.append(c2);
                }
            }
            ++index2;
        }
        return result2.toString();
    }

    public void loadFromXml(Properties props, InputStream is2) throws IOException {
        try {
            props.loadFromXML(is2);
        }
        catch (NoSuchMethodError err2) {
            throw new IOException("Cannot load properties XML file - not running on JDK 1.5+: " + err2.getMessage());
        }
    }

    public void storeToXml(Properties props, OutputStream os2, String header) throws IOException {
        try {
            props.storeToXML(os2, header);
        }
        catch (NoSuchMethodError err2) {
            throw new IOException("Cannot store properties XML file - not running on JDK 1.5+: " + err2.getMessage());
        }
    }

    public void storeToXml(Properties props, OutputStream os2, String header, String encoding) throws IOException {
        try {
            props.storeToXML(os2, header, encoding);
        }
        catch (NoSuchMethodError err2) {
            throw new IOException("Cannot store properties XML file - not running on JDK 1.5+: " + err2.getMessage());
        }
    }
}

