/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public abstract class DigestUtils {
    private static final String MD5_ALGORITHM_NAME = "MD5";
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static byte[] md5Digest(byte[] bytes2) {
        return DigestUtils.digest(MD5_ALGORITHM_NAME, bytes2);
    }

    public static String md5DigestAsHex(byte[] bytes2) {
        return DigestUtils.digestAsHexString(MD5_ALGORITHM_NAME, bytes2);
    }

    public static StringBuilder appendMd5DigestAsHex(byte[] bytes2, StringBuilder builder) {
        return DigestUtils.appendDigestAsHex(MD5_ALGORITHM_NAME, bytes2, builder);
    }

    private static MessageDigest getDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException ex2) {
            throw new IllegalStateException("Could not find MessageDigest with algorithm \"" + algorithm + "\"", ex2);
        }
    }

    private static byte[] digest(String algorithm, byte[] bytes2) {
        return DigestUtils.getDigest(algorithm).digest(bytes2);
    }

    private static String digestAsHexString(String algorithm, byte[] bytes2) {
        char[] hexDigest = DigestUtils.digestAsHexChars(algorithm, bytes2);
        return new String(hexDigest);
    }

    private static StringBuilder appendDigestAsHex(String algorithm, byte[] bytes2, StringBuilder builder) {
        char[] hexDigest = DigestUtils.digestAsHexChars(algorithm, bytes2);
        return builder.append(hexDigest);
    }

    private static char[] digestAsHexChars(String algorithm, byte[] bytes2) {
        byte[] digest = DigestUtils.digest(algorithm, bytes2);
        return DigestUtils.encodeHex(digest);
    }

    private static char[] encodeHex(byte[] bytes2) {
        char[] chars = new char[32];
        int i = 0;
        while (i < chars.length) {
            byte b = bytes2[i / 2];
            chars[i] = HEX_CHARS[b >>> 4 & 0xF];
            chars[i + 1] = HEX_CHARS[b & 0xF];
            i += 2;
        }
        return chars;
    }
}

