/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import org.springframework.util.Assert;

public abstract class FileCopyUtils {
    public static final int BUFFER_SIZE = 4096;

    public static int copy(File in2, File out) throws IOException {
        Assert.notNull(in2, "No input File specified");
        Assert.notNull(out, "No output File specified");
        return FileCopyUtils.copy(new BufferedInputStream(new FileInputStream(in2)), (OutputStream)new BufferedOutputStream(new FileOutputStream(out)));
    }

    public static void copy(byte[] in2, File out) throws IOException {
        Assert.notNull(in2, "No input byte array specified");
        Assert.notNull(out, "No output File specified");
        ByteArrayInputStream inStream = new ByteArrayInputStream(in2);
        BufferedOutputStream outStream = new BufferedOutputStream(new FileOutputStream(out));
        FileCopyUtils.copy(inStream, (OutputStream)outStream);
    }

    public static byte[] copyToByteArray(File in2) throws IOException {
        Assert.notNull(in2, "No input File specified");
        return FileCopyUtils.copyToByteArray(new BufferedInputStream(new FileInputStream(in2)));
    }

    public static int copy(InputStream in2, OutputStream out) throws IOException {
        int n;
        Assert.notNull(in2, "No InputStream specified");
        Assert.notNull(out, "No OutputStream specified");
        try {
            int byteCount = 0;
            byte[] buffer = new byte[4096];
            int bytesRead = -1;
            while ((bytesRead = in2.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
                byteCount += bytesRead;
            }
            out.flush();
            n = byteCount;
        }
        catch (Throwable throwable2) {
            try {
                in2.close();
            }
            catch (IOException iOException) {}
            try {
                out.close();
            }
            catch (IOException iOException) {}
            throw throwable2;
        }
        try {
            in2.close();
        }
        catch (IOException iOException) {}
        try {
            out.close();
        }
        catch (IOException iOException) {}
        return n;
    }

    public static void copy(byte[] in2, OutputStream out) throws IOException {
        Assert.notNull(in2, "No input byte array specified");
        Assert.notNull(out, "No OutputStream specified");
        try {
            out.write(in2);
        }
        catch (Throwable throwable2) {
            try {
                out.close();
            }
            catch (IOException iOException) {}
            throw throwable2;
        }
        try {
            out.close();
        }
        catch (IOException iOException) {}
    }

    public static byte[] copyToByteArray(InputStream in2) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        FileCopyUtils.copy(in2, (OutputStream)out);
        return out.toByteArray();
    }

    public static int copy(Reader in2, Writer out) throws IOException {
        int n;
        Assert.notNull(in2, "No Reader specified");
        Assert.notNull(out, "No Writer specified");
        try {
            int byteCount = 0;
            char[] buffer = new char[4096];
            int bytesRead = -1;
            while ((bytesRead = in2.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
                byteCount += bytesRead;
            }
            out.flush();
            n = byteCount;
        }
        catch (Throwable throwable2) {
            try {
                in2.close();
            }
            catch (IOException iOException) {}
            try {
                out.close();
            }
            catch (IOException iOException) {}
            throw throwable2;
        }
        try {
            in2.close();
        }
        catch (IOException iOException) {}
        try {
            out.close();
        }
        catch (IOException iOException) {}
        return n;
    }

    public static void copy(String in2, Writer out) throws IOException {
        Assert.notNull(in2, "No input String specified");
        Assert.notNull(out, "No Writer specified");
        try {
            out.write(in2);
        }
        catch (Throwable throwable2) {
            try {
                out.close();
            }
            catch (IOException iOException) {}
            throw throwable2;
        }
        try {
            out.close();
        }
        catch (IOException iOException) {}
    }

    public static String copyToString(Reader in2) throws IOException {
        StringWriter out = new StringWriter();
        FileCopyUtils.copy(in2, (Writer)out);
        return out.toString();
    }
}

