/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class MethodInvoker {
    private Class targetClass;
    private Object targetObject;
    private String targetMethod;
    private String staticMethod;
    private Object[] arguments = new Object[0];
    private Method methodObject;

    public void setTargetClass(Class targetClass) {
        this.targetClass = targetClass;
    }

    public Class getTargetClass() {
        return this.targetClass;
    }

    public void setTargetObject(Object targetObject) {
        this.targetObject = targetObject;
        if (targetObject != null) {
            this.targetClass = targetObject.getClass();
        }
    }

    public Object getTargetObject() {
        return this.targetObject;
    }

    public void setTargetMethod(String targetMethod) {
        this.targetMethod = targetMethod;
    }

    public String getTargetMethod() {
        return this.targetMethod;
    }

    public void setStaticMethod(String staticMethod) {
        this.staticMethod = staticMethod;
    }

    public void setArguments(Object[] arguments2) {
        this.arguments = arguments2 != null ? arguments2 : new Object[]{};
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public void prepare() throws ClassNotFoundException, NoSuchMethodException {
        block7: {
            if (this.staticMethod != null) {
                int lastDotIndex = this.staticMethod.lastIndexOf(46);
                if (lastDotIndex == -1 || lastDotIndex == this.staticMethod.length()) {
                    throw new IllegalArgumentException("staticMethod must be a fully qualified class plus method name: e.g. 'example.MyExampleClass.myExampleMethod'");
                }
                String className = this.staticMethod.substring(0, lastDotIndex);
                String methodName = this.staticMethod.substring(lastDotIndex + 1);
                this.targetClass = this.resolveClassName(className);
                this.targetMethod = methodName;
            }
            Class targetClass = this.getTargetClass();
            String targetMethod = this.getTargetMethod();
            if (targetClass == null) {
                throw new IllegalArgumentException("Either 'targetClass' or 'targetObject' is required");
            }
            if (targetMethod == null) {
                throw new IllegalArgumentException("Property 'targetMethod' is required");
            }
            Object[] arguments2 = this.getArguments();
            Class[] argTypes = new Class[arguments2.length];
            int i = 0;
            while (i < arguments2.length) {
                argTypes[i] = arguments2[i] != null ? arguments2[i].getClass() : Object.class;
                ++i;
            }
            try {
                this.methodObject = targetClass.getMethod(targetMethod, argTypes);
            }
            catch (NoSuchMethodException ex2) {
                this.methodObject = this.findMatchingMethod();
                if (this.methodObject != null) break block7;
                throw ex2;
            }
        }
    }

    protected Class resolveClassName(String className) throws ClassNotFoundException {
        return ClassUtils.forName(className, ClassUtils.getDefaultClassLoader());
    }

    protected Method findMatchingMethod() {
        String targetMethod = this.getTargetMethod();
        Object[] arguments2 = this.getArguments();
        int argCount = arguments2.length;
        Method[] candidates = ReflectionUtils.getAllDeclaredMethods(this.getTargetClass());
        int minTypeDiffWeight = Integer.MAX_VALUE;
        Method matchingMethod = null;
        Method[] methodArray = candidates;
        int n = candidates.length;
        int n2 = 0;
        while (n2 < n) {
            int typeDiffWeight;
            Class[] paramTypes2;
            Method candidate = methodArray[n2];
            if (candidate.getName().equals(targetMethod) && (paramTypes2 = candidate.getParameterTypes()).length == argCount && (typeDiffWeight = MethodInvoker.getTypeDifferenceWeight(paramTypes2, arguments2)) < minTypeDiffWeight) {
                minTypeDiffWeight = typeDiffWeight;
                matchingMethod = candidate;
            }
            ++n2;
        }
        return matchingMethod;
    }

    public Method getPreparedMethod() throws IllegalStateException {
        if (this.methodObject == null) {
            throw new IllegalStateException("prepare() must be called prior to invoke() on MethodInvoker");
        }
        return this.methodObject;
    }

    public boolean isPrepared() {
        return this.methodObject != null;
    }

    public Object invoke() throws InvocationTargetException, IllegalAccessException {
        Object targetObject = this.getTargetObject();
        Method preparedMethod = this.getPreparedMethod();
        if (targetObject == null && !Modifier.isStatic(preparedMethod.getModifiers())) {
            throw new IllegalArgumentException("Target method must not be non-static without a target");
        }
        ReflectionUtils.makeAccessible(preparedMethod);
        return preparedMethod.invoke(targetObject, this.getArguments());
    }

    public static int getTypeDifferenceWeight(Class[] paramTypes2, Object[] args2) {
        int result2 = 0;
        int i = 0;
        while (i < paramTypes2.length) {
            if (!ClassUtils.isAssignableValue(paramTypes2[i], args2[i])) {
                return Integer.MAX_VALUE;
            }
            if (args2[i] != null) {
                Class paramType = paramTypes2[i];
                Class<?> superClass = args2[i].getClass().getSuperclass();
                while (superClass != null) {
                    if (paramType.equals(superClass)) {
                        result2 += 2;
                        superClass = null;
                        continue;
                    }
                    if (ClassUtils.isAssignable(paramType, superClass)) {
                        result2 += 2;
                        superClass = superClass.getSuperclass();
                        continue;
                    }
                    superClass = null;
                }
                if (paramType.isInterface()) {
                    ++result2;
                }
            }
            ++i;
        }
        return result2;
    }
}

