/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NumberUtils {
    public static <T extends Number> T convertNumberToTargetClass(Number number2, Class<T> targetClass) throws IllegalArgumentException {
        Assert.notNull(number2, "Number must not be null");
        Assert.notNull(targetClass, "Target class must not be null");
        if (targetClass.isInstance(number2)) {
            return (T)number2;
        }
        if (targetClass.equals(Byte.class)) {
            long value2 = number2.longValue();
            if (value2 < -128L || value2 > 127L) {
                NumberUtils.raiseOverflowException(number2, targetClass);
            }
            return (T)new Byte(number2.byteValue());
        }
        if (targetClass.equals(Short.class)) {
            long value3 = number2.longValue();
            if (value3 < -32768L || value3 > 32767L) {
                NumberUtils.raiseOverflowException(number2, targetClass);
            }
            return (T)new Short(number2.shortValue());
        }
        if (targetClass.equals(Integer.class)) {
            long value4 = number2.longValue();
            if (value4 < Integer.MIN_VALUE || value4 > Integer.MAX_VALUE) {
                NumberUtils.raiseOverflowException(number2, targetClass);
            }
            return (T)new Integer(number2.intValue());
        }
        if (targetClass.equals(Long.class)) {
            return (T)new Long(number2.longValue());
        }
        if (targetClass.equals(BigInteger.class)) {
            if (number2 instanceof BigDecimal) {
                return (T)((BigDecimal)number2).toBigInteger();
            }
            return (T)BigInteger.valueOf(number2.longValue());
        }
        if (targetClass.equals(Float.class)) {
            return (T)new Float(number2.floatValue());
        }
        if (targetClass.equals(Double.class)) {
            return (T)new Double(number2.doubleValue());
        }
        if (targetClass.equals(BigDecimal.class)) {
            return (T)new BigDecimal(number2.toString());
        }
        throw new IllegalArgumentException("Could not convert number [" + number2 + "] of type [" + number2.getClass().getName() + "] to unknown target class [" + targetClass.getName() + "]");
    }

    private static void raiseOverflowException(Number number2, Class targetClass) {
        throw new IllegalArgumentException("Could not convert number [" + number2 + "] of type [" + number2.getClass().getName() + "] to target class [" + targetClass.getName() + "]: overflow");
    }

    public static <T extends Number> T parseNumber(String text2, Class<T> targetClass) {
        Assert.notNull(text2, "Text must not be null");
        Assert.notNull(targetClass, "Target class must not be null");
        String trimmed = StringUtils.trimAllWhitespace(text2);
        if (targetClass.equals(Byte.class)) {
            return (T)(NumberUtils.isHexNumber(trimmed) ? Byte.decode(trimmed) : Byte.valueOf(trimmed));
        }
        if (targetClass.equals(Short.class)) {
            return (T)(NumberUtils.isHexNumber(trimmed) ? Short.decode(trimmed) : Short.valueOf(trimmed));
        }
        if (targetClass.equals(Integer.class)) {
            return (T)(NumberUtils.isHexNumber(trimmed) ? Integer.decode(trimmed) : Integer.valueOf(trimmed));
        }
        if (targetClass.equals(Long.class)) {
            return (T)(NumberUtils.isHexNumber(trimmed) ? Long.decode(trimmed) : Long.valueOf(trimmed));
        }
        if (targetClass.equals(BigInteger.class)) {
            return (T)(NumberUtils.isHexNumber(trimmed) ? NumberUtils.decodeBigInteger(trimmed) : new BigInteger(trimmed));
        }
        if (targetClass.equals(Float.class)) {
            return (T)Float.valueOf(trimmed);
        }
        if (targetClass.equals(Double.class)) {
            return (T)Double.valueOf(trimmed);
        }
        if (targetClass.equals(BigDecimal.class) || targetClass.equals(Number.class)) {
            return (T)new BigDecimal(trimmed);
        }
        throw new IllegalArgumentException("Cannot convert String [" + text2 + "] to target class [" + targetClass.getName() + "]");
    }

    public static <T extends Number> T parseNumber(String text2, Class<T> targetClass, NumberFormat numberFormat) {
        if (numberFormat != null) {
            Assert.notNull(text2, "Text must not be null");
            Assert.notNull(targetClass, "Target class must not be null");
            DecimalFormat decimalFormat = null;
            boolean resetBigDecimal = false;
            if (numberFormat instanceof DecimalFormat) {
                decimalFormat = (DecimalFormat)numberFormat;
                if (BigDecimal.class.equals(targetClass) && !decimalFormat.isParseBigDecimal()) {
                    decimalFormat.setParseBigDecimal(true);
                    resetBigDecimal = true;
                }
            }
            try {
                Number number2 = numberFormat.parse(StringUtils.trimAllWhitespace(text2));
                T t2 = NumberUtils.convertNumberToTargetClass(number2, targetClass);
                return t2;
            }
            catch (ParseException ex2) {
                throw new IllegalArgumentException("Could not parse number: " + ex2.getMessage());
            }
            finally {
                if (resetBigDecimal) {
                    decimalFormat.setParseBigDecimal(false);
                }
            }
        }
        return NumberUtils.parseNumber(text2, targetClass);
    }

    private static boolean isHexNumber(String value2) {
        int index2;
        int n = index2 = value2.startsWith("-") ? 1 : 0;
        return value2.startsWith("0x", index2) || value2.startsWith("0X", index2) || value2.startsWith("#", index2);
    }

    private static BigInteger decodeBigInteger(String value2) {
        int radix = 10;
        int index2 = 0;
        boolean negative = false;
        if (value2.startsWith("-")) {
            negative = true;
            ++index2;
        }
        if (value2.startsWith("0x", index2) || value2.startsWith("0X", index2)) {
            index2 += 2;
            radix = 16;
        } else if (value2.startsWith("#", index2)) {
            ++index2;
            radix = 16;
        } else if (value2.startsWith("0", index2) && value2.length() > 1 + index2) {
            ++index2;
            radix = 8;
        }
        BigInteger result2 = new BigInteger(value2.substring(index2), radix);
        return negative ? result2.negate() : result2;
    }
}

