/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.lang.reflect.Array;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObjectUtils {
    private static final int INITIAL_HASH = 7;
    private static final int MULTIPLIER = 31;
    private static final String EMPTY_STRING = "";
    private static final String NULL_STRING = "null";
    private static final String ARRAY_START = "{";
    private static final String ARRAY_END = "}";
    private static final String EMPTY_ARRAY = "{}";
    private static final String ARRAY_ELEMENT_SEPARATOR = ", ";

    public static boolean isCheckedException(Throwable ex2) {
        return !(ex2 instanceof RuntimeException) && !(ex2 instanceof Error);
    }

    public static boolean isCompatibleWithThrowsClause(Throwable ex2, Class[] declaredExceptions) {
        if (!ObjectUtils.isCheckedException(ex2)) {
            return true;
        }
        if (declaredExceptions != null) {
            int i = 0;
            while (i < declaredExceptions.length) {
                if (declaredExceptions[i].isAssignableFrom(ex2.getClass())) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static boolean isArray(Object obj) {
        return obj != null && obj.getClass().isArray();
    }

    public static boolean isEmpty(Object[] array2) {
        return array2 == null || array2.length == 0;
    }

    public static boolean containsElement(Object[] array2, Object element2) {
        if (array2 == null) {
            return false;
        }
        Object[] objectArray = array2;
        int n = array2.length;
        int n2 = 0;
        while (n2 < n) {
            Object arrayEle = objectArray[n2];
            if (ObjectUtils.nullSafeEquals(arrayEle, element2)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean containsConstant(Enum<?>[] enumValues, String constant) {
        return ObjectUtils.containsConstant(enumValues, constant, false);
    }

    public static boolean containsConstant(Enum<?>[] enumValues, String constant, boolean caseSensitive) {
        Enum<?>[] enumArray = enumValues;
        int n = enumValues.length;
        int n2 = 0;
        while (n2 < n) {
            Enum<?> candidate = enumArray[n2];
            if (caseSensitive ? candidate.toString().equals(constant) : candidate.toString().equalsIgnoreCase(constant)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static <E extends Enum<?>> E caseInsensitiveValueOf(E[] enumValues, String constant) {
        E[] EArray = enumValues;
        int n = enumValues.length;
        int n2 = 0;
        while (n2 < n) {
            E candidate = EArray[n2];
            if (((Enum)candidate).toString().equalsIgnoreCase(constant)) {
                return candidate;
            }
            ++n2;
        }
        throw new IllegalArgumentException(String.format("constant [%s] does not exist in enum type %s", constant, enumValues.getClass().getComponentType().getName()));
    }

    public static <A, O extends A> A[] addObjectToArray(A[] array2, O obj) {
        Class compType = Object.class;
        if (array2 != null) {
            compType = array2.getClass().getComponentType();
        } else if (obj != null) {
            compType = obj.getClass();
        }
        int newArrLength = array2 != null ? array2.length + 1 : 1;
        Object[] newArr2 = (Object[])Array.newInstance(compType, newArrLength);
        if (array2 != null) {
            System.arraycopy(array2, 0, newArr2, 0, array2.length);
        }
        newArr2[newArr2.length - 1] = obj;
        return newArr2;
    }

    public static Object[] toObjectArray(Object source) {
        if (source instanceof Object[]) {
            return (Object[])source;
        }
        if (source == null) {
            return new Object[0];
        }
        if (!source.getClass().isArray()) {
            throw new IllegalArgumentException("Source is not an array: " + source);
        }
        int length2 = Array.getLength(source);
        if (length2 == 0) {
            return new Object[0];
        }
        Class<?> wrapperType = Array.get(source, 0).getClass();
        Object[] newArray = (Object[])Array.newInstance(wrapperType, length2);
        int i = 0;
        while (i < length2) {
            newArray[i] = Array.get(source, i);
            ++i;
        }
        return newArray;
    }

    public static boolean nullSafeEquals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        if (o1.equals(o2)) {
            return true;
        }
        if (o1.getClass().isArray() && o2.getClass().isArray()) {
            if (o1 instanceof Object[] && o2 instanceof Object[]) {
                return Arrays.equals((Object[])o1, (Object[])o2);
            }
            if (o1 instanceof boolean[] && o2 instanceof boolean[]) {
                return Arrays.equals((boolean[])o1, (boolean[])o2);
            }
            if (o1 instanceof byte[] && o2 instanceof byte[]) {
                return Arrays.equals((byte[])o1, (byte[])o2);
            }
            if (o1 instanceof char[] && o2 instanceof char[]) {
                return Arrays.equals((char[])o1, (char[])o2);
            }
            if (o1 instanceof double[] && o2 instanceof double[]) {
                return Arrays.equals((double[])o1, (double[])o2);
            }
            if (o1 instanceof float[] && o2 instanceof float[]) {
                return Arrays.equals((float[])o1, (float[])o2);
            }
            if (o1 instanceof int[] && o2 instanceof int[]) {
                return Arrays.equals((int[])o1, (int[])o2);
            }
            if (o1 instanceof long[] && o2 instanceof long[]) {
                return Arrays.equals((long[])o1, (long[])o2);
            }
            if (o1 instanceof short[] && o2 instanceof short[]) {
                return Arrays.equals((short[])o1, (short[])o2);
            }
        }
        return false;
    }

    public static int nullSafeHashCode(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj.getClass().isArray()) {
            if (obj instanceof Object[]) {
                return ObjectUtils.nullSafeHashCode((Object[])obj);
            }
            if (obj instanceof boolean[]) {
                return ObjectUtils.nullSafeHashCode((boolean[])obj);
            }
            if (obj instanceof byte[]) {
                return ObjectUtils.nullSafeHashCode((byte[])obj);
            }
            if (obj instanceof char[]) {
                return ObjectUtils.nullSafeHashCode((char[])obj);
            }
            if (obj instanceof double[]) {
                return ObjectUtils.nullSafeHashCode((double[])obj);
            }
            if (obj instanceof float[]) {
                return ObjectUtils.nullSafeHashCode((float[])obj);
            }
            if (obj instanceof int[]) {
                return ObjectUtils.nullSafeHashCode((int[])obj);
            }
            if (obj instanceof long[]) {
                return ObjectUtils.nullSafeHashCode((long[])obj);
            }
            if (obj instanceof short[]) {
                return ObjectUtils.nullSafeHashCode((short[])obj);
            }
        }
        return obj.hashCode();
    }

    public static int nullSafeHashCode(Object[] array2) {
        if (array2 == null) {
            return 0;
        }
        int hash2 = 7;
        int arraySize = array2.length;
        int i = 0;
        while (i < arraySize) {
            hash2 = 31 * hash2 + ObjectUtils.nullSafeHashCode(array2[i]);
            ++i;
        }
        return hash2;
    }

    public static int nullSafeHashCode(boolean[] array2) {
        if (array2 == null) {
            return 0;
        }
        int hash2 = 7;
        int arraySize = array2.length;
        int i = 0;
        while (i < arraySize) {
            hash2 = 31 * hash2 + ObjectUtils.hashCode(array2[i]);
            ++i;
        }
        return hash2;
    }

    public static int nullSafeHashCode(byte[] array2) {
        if (array2 == null) {
            return 0;
        }
        int hash2 = 7;
        int arraySize = array2.length;
        int i = 0;
        while (i < arraySize) {
            hash2 = 31 * hash2 + array2[i];
            ++i;
        }
        return hash2;
    }

    public static int nullSafeHashCode(char[] array2) {
        if (array2 == null) {
            return 0;
        }
        int hash2 = 7;
        int arraySize = array2.length;
        int i = 0;
        while (i < arraySize) {
            hash2 = 31 * hash2 + array2[i];
            ++i;
        }
        return hash2;
    }

    public static int nullSafeHashCode(double[] array2) {
        if (array2 == null) {
            return 0;
        }
        int hash2 = 7;
        int arraySize = array2.length;
        int i = 0;
        while (i < arraySize) {
            hash2 = 31 * hash2 + ObjectUtils.hashCode(array2[i]);
            ++i;
        }
        return hash2;
    }

    public static int nullSafeHashCode(float[] array2) {
        if (array2 == null) {
            return 0;
        }
        int hash2 = 7;
        int arraySize = array2.length;
        int i = 0;
        while (i < arraySize) {
            hash2 = 31 * hash2 + ObjectUtils.hashCode(array2[i]);
            ++i;
        }
        return hash2;
    }

    public static int nullSafeHashCode(int[] array2) {
        if (array2 == null) {
            return 0;
        }
        int hash2 = 7;
        int arraySize = array2.length;
        int i = 0;
        while (i < arraySize) {
            hash2 = 31 * hash2 + array2[i];
            ++i;
        }
        return hash2;
    }

    public static int nullSafeHashCode(long[] array2) {
        if (array2 == null) {
            return 0;
        }
        int hash2 = 7;
        int arraySize = array2.length;
        int i = 0;
        while (i < arraySize) {
            hash2 = 31 * hash2 + ObjectUtils.hashCode(array2[i]);
            ++i;
        }
        return hash2;
    }

    public static int nullSafeHashCode(short[] array2) {
        if (array2 == null) {
            return 0;
        }
        int hash2 = 7;
        int arraySize = array2.length;
        int i = 0;
        while (i < arraySize) {
            hash2 = 31 * hash2 + array2[i];
            ++i;
        }
        return hash2;
    }

    public static int hashCode(boolean bool2) {
        return bool2 ? 1231 : 1237;
    }

    public static int hashCode(double dbl) {
        long bits2 = Double.doubleToLongBits(dbl);
        return ObjectUtils.hashCode(bits2);
    }

    public static int hashCode(float flt) {
        return Float.floatToIntBits(flt);
    }

    public static int hashCode(long lng) {
        return (int)(lng ^ lng >>> 32);
    }

    public static String identityToString(Object obj) {
        if (obj == null) {
            return EMPTY_STRING;
        }
        return String.valueOf(obj.getClass().getName()) + "@" + ObjectUtils.getIdentityHexString(obj);
    }

    public static String getIdentityHexString(Object obj) {
        return Integer.toHexString(System.identityHashCode(obj));
    }

    public static String getDisplayString(Object obj) {
        if (obj == null) {
            return EMPTY_STRING;
        }
        return ObjectUtils.nullSafeToString(obj);
    }

    public static String nullSafeClassName(Object obj) {
        return obj != null ? obj.getClass().getName() : NULL_STRING;
    }

    public static String nullSafeToString(Object obj) {
        if (obj == null) {
            return NULL_STRING;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof Object[]) {
            return ObjectUtils.nullSafeToString((Object[])obj);
        }
        if (obj instanceof boolean[]) {
            return ObjectUtils.nullSafeToString((boolean[])obj);
        }
        if (obj instanceof byte[]) {
            return ObjectUtils.nullSafeToString((byte[])obj);
        }
        if (obj instanceof char[]) {
            return ObjectUtils.nullSafeToString((char[])obj);
        }
        if (obj instanceof double[]) {
            return ObjectUtils.nullSafeToString((double[])obj);
        }
        if (obj instanceof float[]) {
            return ObjectUtils.nullSafeToString((float[])obj);
        }
        if (obj instanceof int[]) {
            return ObjectUtils.nullSafeToString((int[])obj);
        }
        if (obj instanceof long[]) {
            return ObjectUtils.nullSafeToString((long[])obj);
        }
        if (obj instanceof short[]) {
            return ObjectUtils.nullSafeToString((short[])obj);
        }
        String str = obj.toString();
        return str != null ? str : EMPTY_STRING;
    }

    public static String nullSafeToString(Object[] array2) {
        if (array2 == null) {
            return NULL_STRING;
        }
        int length2 = array2.length;
        if (length2 == 0) {
            return EMPTY_ARRAY;
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < length2) {
            if (i == 0) {
                sb.append(ARRAY_START);
            } else {
                sb.append(ARRAY_ELEMENT_SEPARATOR);
            }
            sb.append(String.valueOf(array2[i]));
            ++i;
        }
        sb.append(ARRAY_END);
        return sb.toString();
    }

    public static String nullSafeToString(boolean[] array2) {
        if (array2 == null) {
            return NULL_STRING;
        }
        int length2 = array2.length;
        if (length2 == 0) {
            return EMPTY_ARRAY;
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < length2) {
            if (i == 0) {
                sb.append(ARRAY_START);
            } else {
                sb.append(ARRAY_ELEMENT_SEPARATOR);
            }
            sb.append(array2[i]);
            ++i;
        }
        sb.append(ARRAY_END);
        return sb.toString();
    }

    public static String nullSafeToString(byte[] array2) {
        if (array2 == null) {
            return NULL_STRING;
        }
        int length2 = array2.length;
        if (length2 == 0) {
            return EMPTY_ARRAY;
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < length2) {
            if (i == 0) {
                sb.append(ARRAY_START);
            } else {
                sb.append(ARRAY_ELEMENT_SEPARATOR);
            }
            sb.append(array2[i]);
            ++i;
        }
        sb.append(ARRAY_END);
        return sb.toString();
    }

    public static String nullSafeToString(char[] array2) {
        if (array2 == null) {
            return NULL_STRING;
        }
        int length2 = array2.length;
        if (length2 == 0) {
            return EMPTY_ARRAY;
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < length2) {
            if (i == 0) {
                sb.append(ARRAY_START);
            } else {
                sb.append(ARRAY_ELEMENT_SEPARATOR);
            }
            sb.append("'").append(array2[i]).append("'");
            ++i;
        }
        sb.append(ARRAY_END);
        return sb.toString();
    }

    public static String nullSafeToString(double[] array2) {
        if (array2 == null) {
            return NULL_STRING;
        }
        int length2 = array2.length;
        if (length2 == 0) {
            return EMPTY_ARRAY;
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < length2) {
            if (i == 0) {
                sb.append(ARRAY_START);
            } else {
                sb.append(ARRAY_ELEMENT_SEPARATOR);
            }
            sb.append(array2[i]);
            ++i;
        }
        sb.append(ARRAY_END);
        return sb.toString();
    }

    public static String nullSafeToString(float[] array2) {
        if (array2 == null) {
            return NULL_STRING;
        }
        int length2 = array2.length;
        if (length2 == 0) {
            return EMPTY_ARRAY;
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < length2) {
            if (i == 0) {
                sb.append(ARRAY_START);
            } else {
                sb.append(ARRAY_ELEMENT_SEPARATOR);
            }
            sb.append(array2[i]);
            ++i;
        }
        sb.append(ARRAY_END);
        return sb.toString();
    }

    public static String nullSafeToString(int[] array2) {
        if (array2 == null) {
            return NULL_STRING;
        }
        int length2 = array2.length;
        if (length2 == 0) {
            return EMPTY_ARRAY;
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < length2) {
            if (i == 0) {
                sb.append(ARRAY_START);
            } else {
                sb.append(ARRAY_ELEMENT_SEPARATOR);
            }
            sb.append(array2[i]);
            ++i;
        }
        sb.append(ARRAY_END);
        return sb.toString();
    }

    public static String nullSafeToString(long[] array2) {
        if (array2 == null) {
            return NULL_STRING;
        }
        int length2 = array2.length;
        if (length2 == 0) {
            return EMPTY_ARRAY;
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < length2) {
            if (i == 0) {
                sb.append(ARRAY_START);
            } else {
                sb.append(ARRAY_ELEMENT_SEPARATOR);
            }
            sb.append(array2[i]);
            ++i;
        }
        sb.append(ARRAY_END);
        return sb.toString();
    }

    public static String nullSafeToString(short[] array2) {
        if (array2 == null) {
            return NULL_STRING;
        }
        int length2 = array2.length;
        if (length2 == 0) {
            return EMPTY_ARRAY;
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < length2) {
            if (i == 0) {
                sb.append(ARRAY_START);
            } else {
                sb.append(ARRAY_ELEMENT_SEPARATOR);
            }
            sb.append(array2[i]);
            ++i;
        }
        sb.append(ARRAY_END);
        return sb.toString();
    }
}

