/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.UndeclaredThrowableException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReflectionUtils {
    private static final Pattern CGLIB_RENAMED_METHOD_PATTERN = Pattern.compile("CGLIB\\$(.+)\\$\\d+");
    public static FieldFilter COPYABLE_FIELDS = new FieldFilter(){

        public boolean matches(Field field2) {
            return !Modifier.isStatic(field2.getModifiers()) && !Modifier.isFinal(field2.getModifiers());
        }
    };
    public static MethodFilter NON_BRIDGED_METHODS = new MethodFilter(){

        public boolean matches(Method method) {
            return !method.isBridge();
        }
    };
    public static MethodFilter USER_DECLARED_METHODS = new MethodFilter(){

        public boolean matches(Method method) {
            return !method.isBridge() && method.getDeclaringClass() != Object.class;
        }
    };

    public static Field findField(Class<?> clazz2, String name) {
        return ReflectionUtils.findField(clazz2, name, null);
    }

    public static Field findField(Class<?> clazz2, String name, Class<?> type) {
        Assert.notNull(clazz2, "Class must not be null");
        Assert.isTrue(name != null || type != null, "Either name or type of the field must be specified");
        Class<?> searchType = clazz2;
        while (!Object.class.equals(searchType) && searchType != null) {
            Field[] fields;
            Field[] fieldArray = fields = searchType.getDeclaredFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field2 = fieldArray[n2];
                if ((name == null || name.equals(field2.getName())) && (type == null || type.equals(field2.getType()))) {
                    return field2;
                }
                ++n2;
            }
            searchType = searchType.getSuperclass();
        }
        return null;
    }

    public static void setField(Field field2, Object target2, Object value2) {
        try {
            field2.set(target2, value2);
        }
        catch (IllegalAccessException ex2) {
            ReflectionUtils.handleReflectionException(ex2);
            throw new IllegalStateException("Unexpected reflection exception - " + ex2.getClass().getName() + ": " + ex2.getMessage());
        }
    }

    public static Object getField(Field field2, Object target2) {
        try {
            return field2.get(target2);
        }
        catch (IllegalAccessException ex2) {
            ReflectionUtils.handleReflectionException(ex2);
            throw new IllegalStateException("Unexpected reflection exception - " + ex2.getClass().getName() + ": " + ex2.getMessage());
        }
    }

    public static Method findMethod(Class<?> clazz2, String name) {
        return ReflectionUtils.findMethod(clazz2, name, new Class[0]);
    }

    public static Method findMethod(Class<?> clazz2, String name, Class<?> ... paramTypes2) {
        Assert.notNull(clazz2, "Class must not be null");
        Assert.notNull(name, "Method name must not be null");
        Class<?> searchType = clazz2;
        while (searchType != null) {
            Method[] methods2;
            Method[] methodArray = methods2 = searchType.isInterface() ? searchType.getMethods() : searchType.getDeclaredMethods();
            int n = methods2.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (name.equals(method.getName()) && (paramTypes2 == null || Arrays.equals(paramTypes2, method.getParameterTypes()))) {
                    return method;
                }
                ++n2;
            }
            searchType = searchType.getSuperclass();
        }
        return null;
    }

    public static Object invokeMethod(Method method, Object target2) {
        return ReflectionUtils.invokeMethod(method, target2, new Object[0]);
    }

    public static Object invokeMethod(Method method, Object target2, Object ... args2) {
        try {
            return method.invoke(target2, args2);
        }
        catch (Exception ex2) {
            ReflectionUtils.handleReflectionException(ex2);
            throw new IllegalStateException("Should never get here");
        }
    }

    public static Object invokeJdbcMethod(Method method, Object target2) throws SQLException {
        return ReflectionUtils.invokeJdbcMethod(method, target2, new Object[0]);
    }

    public static Object invokeJdbcMethod(Method method, Object target2, Object ... args2) throws SQLException {
        try {
            return method.invoke(target2, args2);
        }
        catch (IllegalAccessException ex2) {
            ReflectionUtils.handleReflectionException(ex2);
        }
        catch (InvocationTargetException ex3) {
            if (ex3.getTargetException() instanceof SQLException) {
                throw (SQLException)ex3.getTargetException();
            }
            ReflectionUtils.handleInvocationTargetException(ex3);
        }
        throw new IllegalStateException("Should never get here");
    }

    public static void handleReflectionException(Exception ex2) {
        if (ex2 instanceof NoSuchMethodException) {
            throw new IllegalStateException("Method not found: " + ex2.getMessage());
        }
        if (ex2 instanceof IllegalAccessException) {
            throw new IllegalStateException("Could not access method: " + ex2.getMessage());
        }
        if (ex2 instanceof InvocationTargetException) {
            ReflectionUtils.handleInvocationTargetException((InvocationTargetException)ex2);
        }
        if (ex2 instanceof RuntimeException) {
            throw (RuntimeException)ex2;
        }
        throw new UndeclaredThrowableException(ex2);
    }

    public static void handleInvocationTargetException(InvocationTargetException ex2) {
        ReflectionUtils.rethrowRuntimeException(ex2.getTargetException());
    }

    public static void rethrowRuntimeException(Throwable ex2) {
        if (ex2 instanceof RuntimeException) {
            throw (RuntimeException)ex2;
        }
        if (ex2 instanceof Error) {
            throw (Error)ex2;
        }
        throw new UndeclaredThrowableException(ex2);
    }

    public static void rethrowException(Throwable ex2) throws Exception {
        if (ex2 instanceof Exception) {
            throw (Exception)ex2;
        }
        if (ex2 instanceof Error) {
            throw (Error)ex2;
        }
        throw new UndeclaredThrowableException(ex2);
    }

    public static boolean declaresException(Method method, Class<?> exceptionType) {
        Class<?>[] declaredExceptions;
        Assert.notNull(method, "Method must not be null");
        Class<?>[] classArray = declaredExceptions = method.getExceptionTypes();
        int n = declaredExceptions.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> declaredException = classArray[n2];
            if (declaredException.isAssignableFrom(exceptionType)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isPublicStaticFinal(Field field2) {
        int modifiers = field2.getModifiers();
        return Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers);
    }

    public static boolean isEqualsMethod(Method method) {
        if (method == null || !method.getName().equals("equals")) {
            return false;
        }
        Class<?>[] paramTypes2 = method.getParameterTypes();
        return paramTypes2.length == 1 && paramTypes2[0] == Object.class;
    }

    public static boolean isHashCodeMethod(Method method) {
        return method != null && method.getName().equals("hashCode") && method.getParameterTypes().length == 0;
    }

    public static boolean isToStringMethod(Method method) {
        return method != null && method.getName().equals("toString") && method.getParameterTypes().length == 0;
    }

    public static boolean isObjectMethod(Method method) {
        try {
            Object.class.getDeclaredMethod(method.getName(), method.getParameterTypes());
            return true;
        }
        catch (SecurityException securityException) {
            return false;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    public static boolean isCglibRenamedMethod(Method renamedMethod) {
        return CGLIB_RENAMED_METHOD_PATTERN.matcher(renamedMethod.getName()).matches();
    }

    public static void makeAccessible(Field field2) {
        if (!(Modifier.isPublic(field2.getModifiers()) && Modifier.isPublic(field2.getDeclaringClass().getModifiers()) && !Modifier.isFinal(field2.getModifiers()) || field2.isAccessible())) {
            field2.setAccessible(true);
        }
    }

    public static void makeAccessible(Method method) {
        if (!(Modifier.isPublic(method.getModifiers()) && Modifier.isPublic(method.getDeclaringClass().getModifiers()) || method.isAccessible())) {
            method.setAccessible(true);
        }
    }

    public static void makeAccessible(Constructor<?> ctor) {
        if (!(Modifier.isPublic(ctor.getModifiers()) && Modifier.isPublic(ctor.getDeclaringClass().getModifiers()) || ctor.isAccessible())) {
            ctor.setAccessible(true);
        }
    }

    public static void doWithMethods(Class<?> clazz2, MethodCallback mc) throws IllegalArgumentException {
        ReflectionUtils.doWithMethods(clazz2, mc, null);
    }

    public static void doWithMethods(Class<?> clazz2, MethodCallback mc, MethodFilter mf2) throws IllegalArgumentException {
        Method[] methods2 = clazz2.getDeclaredMethods();
        GenericDeclaration[] genericDeclarationArray = methods2;
        int n = methods2.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = genericDeclarationArray[n2];
            if (mf2 == null || mf2.matches(method)) {
                try {
                    mc.doWith(method);
                }
                catch (IllegalAccessException ex2) {
                    throw new IllegalStateException("Shouldn't be illegal to access method '" + method.getName() + "': " + ex2);
                }
            }
            ++n2;
        }
        if (clazz2.getSuperclass() != null) {
            ReflectionUtils.doWithMethods(clazz2.getSuperclass(), mc, mf2);
        } else if (clazz2.isInterface()) {
            genericDeclarationArray = clazz2.getInterfaces();
            n = genericDeclarationArray.length;
            n2 = 0;
            while (n2 < n) {
                GenericDeclaration superIfc = genericDeclarationArray[n2];
                ReflectionUtils.doWithMethods(superIfc, mc, mf2);
                ++n2;
            }
        }
    }

    public static Method[] getAllDeclaredMethods(Class<?> leafClass) throws IllegalArgumentException {
        final ArrayList methods2 = new ArrayList(32);
        ReflectionUtils.doWithMethods(leafClass, new MethodCallback(){

            public void doWith(Method method) {
                methods2.add(method);
            }
        });
        return methods2.toArray(new Method[methods2.size()]);
    }

    public static Method[] getUniqueDeclaredMethods(Class<?> leafClass) throws IllegalArgumentException {
        final ArrayList methods2 = new ArrayList(32);
        ReflectionUtils.doWithMethods(leafClass, new MethodCallback(){

            public void doWith(Method method) {
                boolean knownSignature = false;
                Method methodBeingOverriddenWithCovariantReturnType = null;
                for (Method existingMethod : methods2) {
                    if (!method.getName().equals(existingMethod.getName()) || !Arrays.equals(method.getParameterTypes(), existingMethod.getParameterTypes())) continue;
                    if (existingMethod.getReturnType() != method.getReturnType() && existingMethod.getReturnType().isAssignableFrom(method.getReturnType())) {
                        methodBeingOverriddenWithCovariantReturnType = existingMethod;
                        break;
                    }
                    knownSignature = true;
                    break;
                }
                if (methodBeingOverriddenWithCovariantReturnType != null) {
                    methods2.remove(methodBeingOverriddenWithCovariantReturnType);
                }
                if (!knownSignature && !ReflectionUtils.isCglibRenamedMethod(method)) {
                    methods2.add(method);
                }
            }
        });
        return methods2.toArray(new Method[methods2.size()]);
    }

    public static void doWithFields(Class<?> clazz2, FieldCallback fc) throws IllegalArgumentException {
        ReflectionUtils.doWithFields(clazz2, fc, null);
    }

    public static void doWithFields(Class<?> clazz2, FieldCallback fc, FieldFilter ff) throws IllegalArgumentException {
        Class<?> targetClass = clazz2;
        do {
            Field[] fields;
            Field[] fieldArray = fields = targetClass.getDeclaredFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field2 = fieldArray[n2];
                if (ff == null || ff.matches(field2)) {
                    try {
                        fc.doWith(field2);
                    }
                    catch (IllegalAccessException ex2) {
                        throw new IllegalStateException("Shouldn't be illegal to access field '" + field2.getName() + "': " + ex2);
                    }
                }
                ++n2;
            }
        } while ((targetClass = targetClass.getSuperclass()) != null && targetClass != Object.class);
    }

    public static void shallowCopyFieldState(final Object src, final Object dest) throws IllegalArgumentException {
        if (src == null) {
            throw new IllegalArgumentException("Source for field copy cannot be null");
        }
        if (dest == null) {
            throw new IllegalArgumentException("Destination for field copy cannot be null");
        }
        if (!src.getClass().isAssignableFrom(dest.getClass())) {
            throw new IllegalArgumentException("Destination class [" + dest.getClass().getName() + "] must be same or subclass as source class [" + src.getClass().getName() + "]");
        }
        ReflectionUtils.doWithFields(src.getClass(), new FieldCallback(){

            public void doWith(Field field2) throws IllegalArgumentException, IllegalAccessException {
                ReflectionUtils.makeAccessible(field2);
                Object srcValue = field2.get(src);
                field2.set(dest, srcValue);
            }
        }, COPYABLE_FIELDS);
    }

    public static interface FieldCallback {
        public void doWith(Field var1) throws IllegalArgumentException, IllegalAccessException;
    }

    public static interface FieldFilter {
        public boolean matches(Field var1);
    }

    public static interface MethodCallback {
        public void doWith(Method var1) throws IllegalArgumentException, IllegalAccessException;
    }

    public static interface MethodFilter {
        public boolean matches(Method var1);
    }
}

