/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public abstract class SerializationUtils {
    public static byte[] serialize(Object object) {
        if (object == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(object);
            oos.flush();
        }
        catch (IOException ex2) {
            throw new IllegalArgumentException("Failed to serialize object of type: " + object.getClass(), ex2);
        }
        return baos.toByteArray();
    }

    public static Object deserialize(byte[] bytes2) {
        if (bytes2 == null) {
            return null;
        }
        try {
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bytes2));
            return ois.readObject();
        }
        catch (IOException ex2) {
            throw new IllegalArgumentException("Failed to deserialize object", ex2);
        }
        catch (ClassNotFoundException ex3) {
            throw new IllegalStateException("Failed to deserialize object type", ex3);
        }
    }
}

