/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util.xml;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.springframework.util.xml.SimpleNamespaceContext;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

abstract class AbstractStaxContentHandler
implements ContentHandler {
    private SimpleNamespaceContext namespaceContext = new SimpleNamespaceContext();
    private boolean namespaceContextChanged = false;

    AbstractStaxContentHandler() {
    }

    public final void startDocument() throws SAXException {
        this.namespaceContext.clear();
        this.namespaceContextChanged = false;
        try {
            this.startDocumentInternal();
        }
        catch (XMLStreamException ex2) {
            throw new SAXException("Could not handle startDocument: " + ex2.getMessage(), ex2);
        }
    }

    protected abstract void startDocumentInternal() throws XMLStreamException;

    public final void endDocument() throws SAXException {
        this.namespaceContext.clear();
        this.namespaceContextChanged = false;
        try {
            this.endDocumentInternal();
        }
        catch (XMLStreamException ex2) {
            throw new SAXException("Could not handle startDocument: " + ex2.getMessage(), ex2);
        }
    }

    protected abstract void endDocumentInternal() throws XMLStreamException;

    public final void startPrefixMapping(String prefix2, String uri) {
        this.namespaceContext.bindNamespaceUri(prefix2, uri);
        this.namespaceContextChanged = true;
    }

    public final void endPrefixMapping(String prefix2) {
        this.namespaceContext.removeBinding(prefix2);
        this.namespaceContextChanged = true;
    }

    public final void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        try {
            this.startElementInternal(this.toQName(uri, qName), atts, this.namespaceContextChanged ? this.namespaceContext : null);
            this.namespaceContextChanged = false;
        }
        catch (XMLStreamException ex2) {
            throw new SAXException("Could not handle startElement: " + ex2.getMessage(), ex2);
        }
    }

    protected abstract void startElementInternal(QName var1, Attributes var2, SimpleNamespaceContext var3) throws XMLStreamException;

    public final void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            this.endElementInternal(this.toQName(uri, qName), this.namespaceContextChanged ? this.namespaceContext : null);
            this.namespaceContextChanged = false;
        }
        catch (XMLStreamException ex2) {
            throw new SAXException("Could not handle endElement: " + ex2.getMessage(), ex2);
        }
    }

    protected abstract void endElementInternal(QName var1, SimpleNamespaceContext var2) throws XMLStreamException;

    public final void characters(char[] ch, int start2, int length2) throws SAXException {
        try {
            this.charactersInternal(ch, start2, length2);
        }
        catch (XMLStreamException ex2) {
            throw new SAXException("Could not handle characters: " + ex2.getMessage(), ex2);
        }
    }

    protected abstract void charactersInternal(char[] var1, int var2, int var3) throws XMLStreamException;

    public final void ignorableWhitespace(char[] ch, int start2, int length2) throws SAXException {
        try {
            this.ignorableWhitespaceInternal(ch, start2, length2);
        }
        catch (XMLStreamException ex2) {
            throw new SAXException("Could not handle ignorableWhitespace:" + ex2.getMessage(), ex2);
        }
    }

    protected abstract void ignorableWhitespaceInternal(char[] var1, int var2, int var3) throws XMLStreamException;

    public final void processingInstruction(String target2, String data2) throws SAXException {
        try {
            this.processingInstructionInternal(target2, data2);
        }
        catch (XMLStreamException ex2) {
            throw new SAXException("Could not handle processingInstruction: " + ex2.getMessage(), ex2);
        }
    }

    protected abstract void processingInstructionInternal(String var1, String var2) throws XMLStreamException;

    public final void skippedEntity(String name) throws SAXException {
        try {
            this.skippedEntityInternal(name);
        }
        catch (XMLStreamException ex2) {
            throw new SAXException("Could not handle skippedEntity: " + ex2.getMessage(), ex2);
        }
    }

    protected QName toQName(String namespaceUri, String qualifiedName) {
        int idx = qualifiedName.indexOf(58);
        if (idx == -1) {
            return new QName(namespaceUri, qualifiedName);
        }
        String prefix2 = qualifiedName.substring(0, idx);
        String localPart = qualifiedName.substring(idx + 1);
        return new QName(namespaceUri, localPart, prefix2);
    }

    protected abstract void skippedEntityInternal(String var1) throws XMLStreamException;
}

