/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util.xml;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.springframework.util.Assert;

abstract class AbstractXMLStreamReader
implements XMLStreamReader {
    AbstractXMLStreamReader() {
    }

    public String getElementText() throws XMLStreamException {
        if (this.getEventType() != 1) {
            throw new XMLStreamException("parser must be on START_ELEMENT to read next text", this.getLocation());
        }
        int eventType = this.next();
        StringBuilder builder = new StringBuilder();
        while (eventType != 2) {
            if (eventType == 4 || eventType == 12 || eventType == 6 || eventType == 9) {
                builder.append(this.getText());
            } else if (eventType != 3 && eventType != 5) {
                if (eventType == 8) {
                    throw new XMLStreamException("unexpected end of document when reading element text content", this.getLocation());
                }
                if (eventType == 1) {
                    throw new XMLStreamException("element text content may not contain START_ELEMENT", this.getLocation());
                }
                throw new XMLStreamException("Unexpected event type " + eventType, this.getLocation());
            }
            eventType = this.next();
        }
        return builder.toString();
    }

    public String getAttributeLocalName(int index2) {
        return this.getAttributeName(index2).getLocalPart();
    }

    public String getAttributeNamespace(int index2) {
        return this.getAttributeName(index2).getNamespaceURI();
    }

    public String getAttributePrefix(int index2) {
        return this.getAttributeName(index2).getPrefix();
    }

    public String getNamespaceURI() {
        int eventType = this.getEventType();
        if (eventType == 1 || eventType == 2) {
            return this.getName().getNamespaceURI();
        }
        throw new IllegalStateException("parser must be on START_ELEMENT or END_ELEMENT state");
    }

    public String getNamespaceURI(String prefix2) {
        Assert.notNull(prefix2, "No prefix given");
        return this.getNamespaceContext().getNamespaceURI(prefix2);
    }

    public boolean hasText() {
        int eventType = this.getEventType();
        return eventType == 6 || eventType == 4 || eventType == 5 || eventType == 12 || eventType == 9;
    }

    public String getPrefix() {
        int eventType = this.getEventType();
        if (eventType == 1 || eventType == 2) {
            return this.getName().getPrefix();
        }
        throw new IllegalStateException("parser must be on START_ELEMENT or END_ELEMENT state");
    }

    public boolean hasName() {
        int eventType = this.getEventType();
        return eventType == 1 || eventType == 2;
    }

    public boolean isWhiteSpace() {
        return this.getEventType() == 6;
    }

    public boolean isStartElement() {
        return this.getEventType() == 1;
    }

    public boolean isEndElement() {
        return this.getEventType() == 2;
    }

    public boolean isCharacters() {
        return this.getEventType() == 4;
    }

    public int nextTag() throws XMLStreamException {
        int eventType = this.next();
        while (eventType == 4 && this.isWhiteSpace() || eventType == 12 && this.isWhiteSpace() || eventType == 6 || eventType == 3 || eventType == 5) {
            eventType = this.next();
        }
        if (eventType != 1 && eventType != 2) {
            throw new XMLStreamException("expected start or end tag", this.getLocation());
        }
        return eventType;
    }

    public void require(int expectedType, String namespaceURI, String localName) throws XMLStreamException {
        int eventType = this.getEventType();
        if (eventType != expectedType) {
            throw new XMLStreamException("Expected [" + expectedType + "] but read [" + eventType + "]");
        }
    }

    public String getAttributeValue(String namespaceURI, String localName) {
        int i = 0;
        while (i < this.getAttributeCount()) {
            QName name = this.getAttributeName(i);
            if (name.getLocalPart().equals(localName) && (namespaceURI == null || name.getNamespaceURI().equals(namespaceURI))) {
                return this.getAttributeValue(i);
            }
            ++i;
        }
        return null;
    }

    public boolean hasNext() throws XMLStreamException {
        return this.getEventType() != 8;
    }

    public String getLocalName() {
        return this.getName().getLocalPart();
    }

    public char[] getTextCharacters() {
        return this.getText().toCharArray();
    }

    public int getTextCharacters(int sourceStart, char[] target2, int targetStart, int length2) throws XMLStreamException {
        char[] source = this.getTextCharacters();
        length2 = Math.min(length2, source.length);
        System.arraycopy(source, sourceStart, target2, targetStart, length2);
        return length2;
    }

    public int getTextLength() {
        return this.getText().length();
    }
}

