/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util.xml;

import java.util.ArrayList;
import java.util.List;
import org.springframework.util.Assert;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

class DomContentHandler
implements ContentHandler {
    private final Document document;
    private final List<Element> elements = new ArrayList<Element>();
    private final Node node;

    DomContentHandler(Node node4) {
        Assert.notNull(node4, "node must not be null");
        this.node = node4;
        this.document = node4 instanceof Document ? (Document)node4 : node4.getOwnerDocument();
        Assert.notNull(this.document, "document must not be null");
    }

    private Node getParent() {
        if (!this.elements.isEmpty()) {
            return this.elements.get(this.elements.size() - 1);
        }
        return this.node;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes2) throws SAXException {
        Node parent2 = this.getParent();
        Element element2 = this.document.createElementNS(uri, qName);
        int i = 0;
        while (i < attributes2.getLength()) {
            String attrUri = attributes2.getURI(i);
            String attrQname = attributes2.getQName(i);
            String value2 = attributes2.getValue(i);
            if (!attrQname.startsWith("xmlns")) {
                element2.setAttributeNS(attrUri, attrQname, value2);
            }
            ++i;
        }
        element2 = (Element)parent2.appendChild(element2);
        this.elements.add(element2);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.elements.remove(this.elements.size() - 1);
    }

    public void characters(char[] ch, int start2, int length2) throws SAXException {
        String data2 = new String(ch, start2, length2);
        Node parent2 = this.getParent();
        Node lastChild = parent2.getLastChild();
        if (lastChild != null && lastChild.getNodeType() == 3) {
            ((Text)lastChild).appendData(data2);
        } else {
            Text text2 = this.document.createTextNode(data2);
            parent2.appendChild(text2);
        }
    }

    public void processingInstruction(String target2, String data2) throws SAXException {
        Node parent2 = this.getParent();
        ProcessingInstruction pi = this.document.createProcessingInstruction(target2, data2);
        parent2.appendChild(pi);
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void startPrefixMapping(String prefix2, String uri) throws SAXException {
    }

    public void endPrefixMapping(String prefix2) throws SAXException {
    }

    public void ignorableWhitespace(char[] ch, int start2, int length2) throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
    }
}

