/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util.xml;

import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.AbstractStaxContentHandler;
import org.springframework.util.xml.SimpleNamespaceContext;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;

class StaxStreamContentHandler
extends AbstractStaxContentHandler {
    private final XMLStreamWriter streamWriter;

    StaxStreamContentHandler(XMLStreamWriter streamWriter) {
        Assert.notNull(streamWriter, "'streamWriter' must not be null");
        this.streamWriter = streamWriter;
    }

    public void setDocumentLocator(Locator locator) {
    }

    protected void charactersInternal(char[] ch, int start2, int length2) throws XMLStreamException {
        this.streamWriter.writeCharacters(ch, start2, length2);
    }

    protected void endDocumentInternal() throws XMLStreamException {
        this.streamWriter.writeEndDocument();
    }

    protected void endElementInternal(QName name, SimpleNamespaceContext namespaceContext) throws XMLStreamException {
        this.streamWriter.writeEndElement();
    }

    protected void ignorableWhitespaceInternal(char[] ch, int start2, int length2) throws XMLStreamException {
        this.streamWriter.writeCharacters(ch, start2, length2);
    }

    protected void processingInstructionInternal(String target2, String data2) throws XMLStreamException {
        this.streamWriter.writeProcessingInstruction(target2, data2);
    }

    protected void skippedEntityInternal(String name) {
    }

    protected void startDocumentInternal() throws XMLStreamException {
        this.streamWriter.writeStartDocument();
    }

    protected void startElementInternal(QName name, Attributes attributes2, SimpleNamespaceContext namespaceContext) throws XMLStreamException {
        this.streamWriter.writeStartElement(name.getPrefix(), name.getLocalPart(), name.getNamespaceURI());
        if (namespaceContext != null) {
            String defaultNamespaceUri = namespaceContext.getNamespaceURI("");
            if (StringUtils.hasLength(defaultNamespaceUri)) {
                this.streamWriter.writeNamespace("", defaultNamespaceUri);
                this.streamWriter.setDefaultNamespace(defaultNamespaceUri);
            }
            Iterator<String> iterator2 = namespaceContext.getBoundPrefixes();
            while (iterator2.hasNext()) {
                String prefix2 = iterator2.next();
                this.streamWriter.writeNamespace(prefix2, namespaceContext.getNamespaceURI(prefix2));
                this.streamWriter.setPrefix(prefix2, namespaceContext.getNamespaceURI(prefix2));
            }
        }
        int i = 0;
        while (i < attributes2.getLength()) {
            QName attrName = this.toQName(attributes2.getURI(i), attributes2.getQName(i));
            if (!"xmlns".equals(attrName.getLocalPart()) && !"xmlns".equals(attrName.getPrefix())) {
                this.streamWriter.writeAttribute(attrName.getPrefix(), attrName.getNamespaceURI(), attrName.getLocalPart(), attributes2.getValue(i));
            }
            ++i;
        }
    }
}

