/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util.xml;

import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stax.StAXResult;
import javax.xml.transform.stax.StAXSource;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.xml.StaxEventContentHandler;
import org.springframework.util.xml.StaxEventXMLReader;
import org.springframework.util.xml.StaxResult;
import org.springframework.util.xml.StaxSource;
import org.springframework.util.xml.StaxStreamContentHandler;
import org.springframework.util.xml.StaxStreamXMLReader;
import org.springframework.util.xml.XMLEventStreamReader;
import org.springframework.util.xml.XMLEventStreamWriter;
import org.xml.sax.ContentHandler;
import org.xml.sax.XMLReader;

public abstract class StaxUtils {
    private static boolean jaxp14Available = ClassUtils.isPresent("javax.xml.transform.stax.StAXSource", StaxUtils.class.getClassLoader());

    public static Source createCustomStaxSource(XMLStreamReader streamReader) {
        return new StaxSource(streamReader);
    }

    public static Source createStaxSource(XMLStreamReader streamReader) {
        if (jaxp14Available) {
            return Jaxp14StaxHandler.createStaxSource(streamReader);
        }
        return StaxUtils.createCustomStaxSource(streamReader);
    }

    public static Source createCustomStaxSource(XMLEventReader eventReader) {
        return new StaxSource(eventReader);
    }

    public static Source createStaxSource(XMLEventReader eventReader) throws XMLStreamException {
        if (jaxp14Available) {
            return Jaxp14StaxHandler.createStaxSource(eventReader);
        }
        return StaxUtils.createCustomStaxSource(eventReader);
    }

    public static boolean isStaxSource(Source source) {
        return source instanceof StaxSource || jaxp14Available && Jaxp14StaxHandler.isStaxSource(source);
    }

    public static Result createCustomStaxResult(XMLStreamWriter streamWriter) {
        return new StaxResult(streamWriter);
    }

    public static Result createStaxResult(XMLStreamWriter streamWriter) {
        if (jaxp14Available) {
            return Jaxp14StaxHandler.createStaxResult(streamWriter);
        }
        return StaxUtils.createCustomStaxResult(streamWriter);
    }

    public static Result createCustomStaxResult(XMLEventWriter eventWriter) {
        return new StaxResult(eventWriter);
    }

    public static Result createStaxResult(XMLEventWriter eventWriter) throws XMLStreamException {
        if (jaxp14Available) {
            return Jaxp14StaxHandler.createStaxResult(eventWriter);
        }
        return StaxUtils.createCustomStaxResult(eventWriter);
    }

    public static boolean isStaxResult(Result result2) {
        return result2 instanceof StaxResult || jaxp14Available && Jaxp14StaxHandler.isStaxResult(result2);
    }

    public static XMLStreamReader getXMLStreamReader(Source source) {
        if (source instanceof StaxSource) {
            return ((StaxSource)source).getXMLStreamReader();
        }
        if (jaxp14Available) {
            return Jaxp14StaxHandler.getXMLStreamReader(source);
        }
        throw new IllegalArgumentException("Source '" + source + "' is neither StaxSource nor StAXSource");
    }

    public static XMLEventReader getXMLEventReader(Source source) {
        if (source instanceof StaxSource) {
            return ((StaxSource)source).getXMLEventReader();
        }
        if (jaxp14Available) {
            return Jaxp14StaxHandler.getXMLEventReader(source);
        }
        throw new IllegalArgumentException("Source '" + source + "' is neither StaxSource nor StAXSource");
    }

    public static XMLStreamWriter getXMLStreamWriter(Result result2) {
        if (result2 instanceof StaxResult) {
            return ((StaxResult)result2).getXMLStreamWriter();
        }
        if (jaxp14Available) {
            return Jaxp14StaxHandler.getXMLStreamWriter(result2);
        }
        throw new IllegalArgumentException("Result '" + result2 + "' is neither StaxResult nor StAXResult");
    }

    public static XMLEventWriter getXMLEventWriter(Result result2) {
        if (result2 instanceof StaxResult) {
            return ((StaxResult)result2).getXMLEventWriter();
        }
        if (jaxp14Available) {
            return Jaxp14StaxHandler.getXMLEventWriter(result2);
        }
        throw new IllegalArgumentException("Result '" + result2 + "' is neither StaxResult nor StAXResult");
    }

    public static ContentHandler createContentHandler(XMLStreamWriter streamWriter) {
        return new StaxStreamContentHandler(streamWriter);
    }

    public static ContentHandler createContentHandler(XMLEventWriter eventWriter) {
        return new StaxEventContentHandler(eventWriter);
    }

    public static XMLReader createXMLReader(XMLStreamReader streamReader) {
        return new StaxStreamXMLReader(streamReader);
    }

    public static XMLReader createXMLReader(XMLEventReader eventReader) {
        return new StaxEventXMLReader(eventReader);
    }

    public static XMLStreamReader createEventStreamReader(XMLEventReader eventReader) throws XMLStreamException {
        return new XMLEventStreamReader(eventReader);
    }

    public static XMLStreamWriter createEventStreamWriter(XMLEventWriter eventWriter, XMLEventFactory eventFactory) {
        return new XMLEventStreamWriter(eventWriter, eventFactory);
    }

    private static class Jaxp14StaxHandler {
        private Jaxp14StaxHandler() {
        }

        private static Source createStaxSource(XMLStreamReader streamReader) {
            return new StAXSource(streamReader);
        }

        private static Source createStaxSource(XMLEventReader eventReader) throws XMLStreamException {
            return new StAXSource(eventReader);
        }

        private static Result createStaxResult(XMLStreamWriter streamWriter) {
            return new StAXResult(streamWriter);
        }

        private static Result createStaxResult(XMLEventWriter eventWriter) {
            return new StAXResult(eventWriter);
        }

        private static boolean isStaxSource(Source source) {
            return source instanceof StAXSource;
        }

        private static boolean isStaxResult(Result result2) {
            return result2 instanceof StAXResult;
        }

        private static XMLStreamReader getXMLStreamReader(Source source) {
            Assert.isInstanceOf(StAXSource.class, source);
            return ((StAXSource)source).getXMLStreamReader();
        }

        private static XMLEventReader getXMLEventReader(Source source) {
            Assert.isInstanceOf(StAXSource.class, source);
            return ((StAXSource)source).getXMLEventReader();
        }

        private static XMLStreamWriter getXMLStreamWriter(Result result2) {
            Assert.isInstanceOf(StAXResult.class, result2);
            return ((StAXResult)result2).getXMLStreamWriter();
        }

        private static XMLEventWriter getXMLEventWriter(Result result2) {
            Assert.isInstanceOf(StAXResult.class, result2);
            return ((StAXResult)result2).getXMLEventWriter();
        }
    }
}

