/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util.xml;

import java.io.BufferedReader;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.springframework.util.StringUtils;

public class XmlValidationModeDetector {
    public static final int VALIDATION_NONE = 0;
    public static final int VALIDATION_AUTO = 1;
    public static final int VALIDATION_DTD = 2;
    public static final int VALIDATION_XSD = 3;
    private static final String DOCTYPE = "DOCTYPE";
    private static final String START_COMMENT = "<!--";
    private static final String END_COMMENT = "-->";
    private boolean inComment;

    public int detectValidationMode(InputStream inputStream) throws IOException {
        BufferedReader reader2 = new BufferedReader(new InputStreamReader(inputStream));
        try {
            String content2;
            boolean isDtdValidated = false;
            while ((content2 = reader2.readLine()) != null) {
                content2 = this.consumeCommentTokens(content2);
                if (this.inComment || !StringUtils.hasText(content2)) continue;
                if (this.hasDoctype(content2)) {
                    isDtdValidated = true;
                    break;
                }
                if (this.hasOpeningTag(content2)) break;
            }
            int n = isDtdValidated ? 2 : 3;
            return n;
        }
        catch (CharConversionException charConversionException) {
            return 1;
        }
        finally {
            reader2.close();
        }
    }

    private boolean hasDoctype(String content2) {
        return content2.indexOf(DOCTYPE) > -1;
    }

    private boolean hasOpeningTag(String content2) {
        if (this.inComment) {
            return false;
        }
        int openTagIndex = content2.indexOf(60);
        return openTagIndex > -1 && content2.length() > openTagIndex && Character.isLetter(content2.charAt(openTagIndex + 1));
    }

    /*
     * Unable to fully structure code
     */
    private String consumeCommentTokens(String line) {
        if (line.indexOf("<!--") != -1 || line.indexOf("-->") != -1) ** GOTO lbl5
        return line;
lbl-1000:
        // 1 sources

        {
            if (this.inComment || line.trim().startsWith("<!--")) continue;
            return line;
lbl5:
            // 2 sources

            ** while ((line = this.consume((String)line)) != null)
        }
lbl6:
        // 1 sources

        return line;
    }

    private String consume(String line) {
        int index2 = this.inComment ? this.endComment(line) : this.startComment(line);
        return index2 == -1 ? null : line.substring(index2);
    }

    private int startComment(String line) {
        return this.commentToken(line, START_COMMENT, true);
    }

    private int endComment(String line) {
        return this.commentToken(line, END_COMMENT, false);
    }

    private int commentToken(String line, String token2, boolean inCommentIfPresent) {
        int index2 = line.indexOf(token2);
        if (index2 > -1) {
            this.inComment = inCommentIfPresent;
        }
        return index2 == -1 ? index2 : index2 + token2.length();
    }
}

