/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation;

import org.springframework.beans.PropertyAccessException;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindingErrorProcessor;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;

public class DefaultBindingErrorProcessor
implements BindingErrorProcessor {
    public static final String MISSING_FIELD_ERROR_CODE = "required";

    public void processMissingFieldError(String missingField, BindingResult bindingResult) {
        String fixedField = String.valueOf(bindingResult.getNestedPath()) + missingField;
        String[] codes = bindingResult.resolveMessageCodes(MISSING_FIELD_ERROR_CODE, missingField);
        Object[] arguments2 = this.getArgumentsForBindError(bindingResult.getObjectName(), fixedField);
        bindingResult.addError(new FieldError(bindingResult.getObjectName(), fixedField, "", true, codes, arguments2, "Field '" + fixedField + "' is required"));
    }

    public void processPropertyAccessException(PropertyAccessException ex2, BindingResult bindingResult) {
        String field2 = ex2.getPropertyName();
        String[] codes = bindingResult.resolveMessageCodes(ex2.getErrorCode(), field2);
        Object[] arguments2 = this.getArgumentsForBindError(bindingResult.getObjectName(), field2);
        Object rejectedValue = ex2.getValue();
        if (rejectedValue != null && rejectedValue.getClass().isArray()) {
            rejectedValue = StringUtils.arrayToCommaDelimitedString(ObjectUtils.toObjectArray(rejectedValue));
        }
        bindingResult.addError(new FieldError(bindingResult.getObjectName(), field2, rejectedValue, true, codes, arguments2, ex2.getLocalizedMessage()));
    }

    protected Object[] getArgumentsForBindError(String objectName, String field2) {
        String[] codes = new String[]{String.valueOf(objectName) + "." + field2, field2};
        return new Object[]{new DefaultMessageSourceResolvable(codes, field2)};
    }
}

