/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation.beanvalidation;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.ConstraintDescriptor;
import org.springframework.beans.NotReadablePropertyException;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.util.Assert;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.validation.SmartValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringValidatorAdapter
implements SmartValidator,
Validator {
    private static final Set<String> internalAnnotationAttributes = new HashSet<String>(3);
    private Validator targetValidator;

    static {
        internalAnnotationAttributes.add("message");
        internalAnnotationAttributes.add("groups");
        internalAnnotationAttributes.add("payload");
    }

    public SpringValidatorAdapter(Validator targetValidator) {
        Assert.notNull(targetValidator, "Target Validator must not be null");
        this.targetValidator = targetValidator;
    }

    SpringValidatorAdapter() {
    }

    void setTargetValidator(Validator targetValidator) {
        this.targetValidator = targetValidator;
    }

    @Override
    public boolean supports(Class<?> clazz2) {
        return true;
    }

    @Override
    public void validate(Object target2, Errors errors) {
        this.processConstraintViolations(this.targetValidator.validate(target2, new Class[0]), errors);
    }

    @Override
    public void validate(Object target2, Errors errors, Object ... validationHints) {
        LinkedHashSet<Class> groups = new LinkedHashSet<Class>();
        if (validationHints != null) {
            Object[] objectArray = validationHints;
            int n = validationHints.length;
            int n2 = 0;
            while (n2 < n) {
                Object hint = objectArray[n2];
                if (hint instanceof Class) {
                    groups.add((Class)hint);
                }
                ++n2;
            }
        }
        this.processConstraintViolations(this.targetValidator.validate(target2, groups.toArray(new Class[groups.size()])), errors);
    }

    protected void processConstraintViolations(Set<ConstraintViolation<Object>> violations, Errors errors) {
        for (ConstraintViolation<Object> violation : violations) {
            String field2 = violation.getPropertyPath().toString();
            FieldError fieldError = errors.getFieldError(field2);
            if (fieldError != null && fieldError.isBindingFailure()) continue;
            try {
                String errorCode = ((Annotation)((Object)violation.getConstraintDescriptor().getAnnotation())).annotationType().getSimpleName();
                Object[] errorArgs = this.getArgumentsForConstraint(errors.getObjectName(), field2, violation.getConstraintDescriptor());
                if (errors instanceof BindingResult) {
                    BindingResult bindingResult = (BindingResult)errors;
                    String nestedField = String.valueOf(bindingResult.getNestedPath()) + field2;
                    if ("".equals(nestedField)) {
                        String[] errorCodes = bindingResult.resolveMessageCodes(errorCode);
                        bindingResult.addError(new ObjectError(errors.getObjectName(), errorCodes, errorArgs, violation.getMessage()));
                        continue;
                    }
                    Object invalidValue = violation.getInvalidValue();
                    if (!"".equals(field2) && invalidValue == violation.getLeafBean()) {
                        invalidValue = bindingResult.getRawFieldValue(field2);
                    }
                    String[] errorCodes = bindingResult.resolveMessageCodes(errorCode, field2);
                    bindingResult.addError(new FieldError(errors.getObjectName(), nestedField, invalidValue, false, errorCodes, errorArgs, violation.getMessage()));
                    continue;
                }
                errors.rejectValue(field2, errorCode, errorArgs, violation.getMessage());
            }
            catch (NotReadablePropertyException ex2) {
                throw new IllegalStateException("JSR-303 validated property '" + field2 + "' does not have a corresponding accessor for Spring data binding - " + "check your DataBinder's configuration (bean property versus direct field access)", ex2);
            }
        }
    }

    protected Object[] getArgumentsForConstraint(String objectName, String field2, ConstraintDescriptor<?> descriptor) {
        LinkedList<DefaultMessageSourceResolvable> arguments2 = new LinkedList<DefaultMessageSourceResolvable>();
        String[] codes = new String[]{String.valueOf(objectName) + "." + field2, field2};
        arguments2.add(new DefaultMessageSourceResolvable(codes, field2));
        TreeMap attributesToExpose = new TreeMap();
        for (Map.Entry entry2 : descriptor.getAttributes().entrySet()) {
            String attributeName = (String)entry2.getKey();
            Object attributeValue = entry2.getValue();
            if (internalAnnotationAttributes.contains(attributeName)) continue;
            attributesToExpose.put(attributeName, attributeValue);
        }
        arguments2.addAll(attributesToExpose.values());
        return arguments2.toArray(new Object[arguments2.size()]);
    }

    public <T> Set<ConstraintViolation<T>> validate(T object, Class<?> ... groups) {
        return this.targetValidator.validate(object, (Class[])groups);
    }

    public <T> Set<ConstraintViolation<T>> validateProperty(T object, String propertyName, Class<?> ... groups) {
        return this.targetValidator.validateProperty(object, propertyName, (Class[])groups);
    }

    public <T> Set<ConstraintViolation<T>> validateValue(Class<T> beanType, String propertyName, Object value2, Class<?> ... groups) {
        return this.targetValidator.validateValue(beanType, propertyName, value2, (Class[])groups);
    }

    public BeanDescriptor getConstraintsForClass(Class<?> clazz2) {
        return this.targetValidator.getConstraintsForClass(clazz2);
    }

    public <T> T unwrap(Class<T> type) {
        return (T)this.targetValidator.unwrap(type);
    }
}

