/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.bind;

import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.validation.DataBinder;
import org.springframework.web.multipart.MultipartFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebDataBinder
extends DataBinder {
    public static final String DEFAULT_FIELD_MARKER_PREFIX = "_";
    public static final String DEFAULT_FIELD_DEFAULT_PREFIX = "!";
    private String fieldMarkerPrefix = "_";
    private String fieldDefaultPrefix = "!";
    private boolean bindEmptyMultipartFiles = true;

    public WebDataBinder(Object target2) {
        super(target2);
    }

    public WebDataBinder(Object target2, String objectName) {
        super(target2, objectName);
    }

    public void setFieldMarkerPrefix(String fieldMarkerPrefix) {
        this.fieldMarkerPrefix = fieldMarkerPrefix;
    }

    public String getFieldMarkerPrefix() {
        return this.fieldMarkerPrefix;
    }

    public void setFieldDefaultPrefix(String fieldDefaultPrefix) {
        this.fieldDefaultPrefix = fieldDefaultPrefix;
    }

    public String getFieldDefaultPrefix() {
        return this.fieldDefaultPrefix;
    }

    public void setBindEmptyMultipartFiles(boolean bindEmptyMultipartFiles) {
        this.bindEmptyMultipartFiles = bindEmptyMultipartFiles;
    }

    public boolean isBindEmptyMultipartFiles() {
        return this.bindEmptyMultipartFiles;
    }

    @Override
    protected void doBind(MutablePropertyValues mpvs) {
        this.checkFieldDefaults(mpvs);
        this.checkFieldMarkers(mpvs);
        super.doBind(mpvs);
    }

    protected void checkFieldDefaults(MutablePropertyValues mpvs) {
        if (this.getFieldDefaultPrefix() != null) {
            PropertyValue[] pvArray;
            String fieldDefaultPrefix = this.getFieldDefaultPrefix();
            PropertyValue[] propertyValueArray = pvArray = mpvs.getPropertyValues();
            int n = pvArray.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyValue pv2 = propertyValueArray[n2];
                if (pv2.getName().startsWith(fieldDefaultPrefix)) {
                    String field2 = pv2.getName().substring(fieldDefaultPrefix.length());
                    if (this.getPropertyAccessor().isWritableProperty(field2) && !mpvs.contains(field2)) {
                        mpvs.add(field2, pv2.getValue());
                    }
                    mpvs.removePropertyValue(pv2);
                }
                ++n2;
            }
        }
    }

    protected void checkFieldMarkers(MutablePropertyValues mpvs) {
        if (this.getFieldMarkerPrefix() != null) {
            PropertyValue[] pvArray;
            String fieldMarkerPrefix = this.getFieldMarkerPrefix();
            PropertyValue[] propertyValueArray = pvArray = mpvs.getPropertyValues();
            int n = pvArray.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyValue pv2 = propertyValueArray[n2];
                if (pv2.getName().startsWith(fieldMarkerPrefix)) {
                    String field2 = pv2.getName().substring(fieldMarkerPrefix.length());
                    if (this.getPropertyAccessor().isWritableProperty(field2) && !mpvs.contains(field2)) {
                        Class fieldType = this.getPropertyAccessor().getPropertyType(field2);
                        mpvs.add(field2, this.getEmptyValue(field2, fieldType));
                    }
                    mpvs.removePropertyValue(pv2);
                }
                ++n2;
            }
        }
    }

    protected Object getEmptyValue(String field2, Class fieldType) {
        if (fieldType != null && Boolean.TYPE.equals(fieldType) || Boolean.class.equals((Object)fieldType)) {
            return Boolean.FALSE;
        }
        if (fieldType != null && fieldType.isArray()) {
            return Array.newInstance(fieldType.getComponentType(), 0);
        }
        return null;
    }

    @Deprecated
    protected void bindMultipartFiles(Map<String, MultipartFile> multipartFiles, MutablePropertyValues mpvs) {
        for (Map.Entry<String, MultipartFile> entry2 : multipartFiles.entrySet()) {
            String key = entry2.getKey();
            MultipartFile value2 = entry2.getValue();
            if (!this.isBindEmptyMultipartFiles() && value2.isEmpty()) continue;
            mpvs.add(key, value2);
        }
    }

    protected void bindMultipart(Map<String, List<MultipartFile>> multipartFiles, MutablePropertyValues mpvs) {
        for (Map.Entry<String, List<MultipartFile>> entry2 : multipartFiles.entrySet()) {
            String key = entry2.getKey();
            List<MultipartFile> values2 = entry2.getValue();
            if (values2.size() == 1) {
                MultipartFile value2 = values2.get(0);
                if (!this.isBindEmptyMultipartFiles() && value2.isEmpty()) continue;
                mpvs.add(key, value2);
                continue;
            }
            mpvs.add(key, values2);
        }
    }
}

