/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context;

import java.util.Enumeration;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;

public class ContextCleanupListener
implements ServletContextListener {
    private static final Log logger = LogFactory.getLog(ContextCleanupListener.class);

    public void contextInitialized(ServletContextEvent event) {
    }

    public void contextDestroyed(ServletContextEvent event) {
        ContextCleanupListener.cleanupAttributes(event.getServletContext());
    }

    static void cleanupAttributes(ServletContext sc) {
        Enumeration attrNames = sc.getAttributeNames();
        while (attrNames.hasMoreElements()) {
            Object attrValue;
            String attrName = (String)attrNames.nextElement();
            if (!attrName.startsWith("org.springframework.") || !((attrValue = sc.getAttribute(attrName)) instanceof DisposableBean)) continue;
            try {
                ((DisposableBean)attrValue).destroy();
            }
            catch (Throwable ex2) {
                logger.error("Couldn't invoke destroy method of attribute with name '" + attrName + "'", ex2);
            }
        }
    }
}

