/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.request;

import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

public abstract class AbstractRequestAttributesScope
implements Scope {
    public Object get(String name, ObjectFactory objectFactory) {
        RequestAttributes attributes2 = RequestContextHolder.currentRequestAttributes();
        Object scopedObject = attributes2.getAttribute(name, this.getScope());
        if (scopedObject == null) {
            scopedObject = objectFactory.getObject();
            attributes2.setAttribute(name, scopedObject, this.getScope());
        }
        return scopedObject;
    }

    public Object remove(String name) {
        RequestAttributes attributes2 = RequestContextHolder.currentRequestAttributes();
        Object scopedObject = attributes2.getAttribute(name, this.getScope());
        if (scopedObject != null) {
            attributes2.removeAttribute(name, this.getScope());
            return scopedObject;
        }
        return null;
    }

    public void registerDestructionCallback(String name, Runnable callback) {
        RequestAttributes attributes2 = RequestContextHolder.currentRequestAttributes();
        attributes2.registerDestructionCallback(name, callback, this.getScope());
    }

    public Object resolveContextualObject(String key) {
        RequestAttributes attributes2 = RequestContextHolder.currentRequestAttributes();
        return attributes2.resolveReference(key);
    }

    protected abstract int getScope();
}

