/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.request;

import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpServletRequest;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class RequestContextListener
implements ServletRequestListener {
    private static final String REQUEST_ATTRIBUTES_ATTRIBUTE = String.valueOf(RequestContextListener.class.getName()) + ".REQUEST_ATTRIBUTES";

    public void requestInitialized(ServletRequestEvent requestEvent) {
        if (!(requestEvent.getServletRequest() instanceof HttpServletRequest)) {
            throw new IllegalArgumentException("Request is not an HttpServletRequest: " + requestEvent.getServletRequest());
        }
        HttpServletRequest request = (HttpServletRequest)requestEvent.getServletRequest();
        ServletRequestAttributes attributes2 = new ServletRequestAttributes(request);
        request.setAttribute(REQUEST_ATTRIBUTES_ATTRIBUTE, (Object)attributes2);
        LocaleContextHolder.setLocale(request.getLocale());
        RequestContextHolder.setRequestAttributes(attributes2);
    }

    public void requestDestroyed(ServletRequestEvent requestEvent) {
        ServletRequestAttributes attributes2 = (ServletRequestAttributes)requestEvent.getServletRequest().getAttribute(REQUEST_ATTRIBUTES_ATTRIBUTE);
        ServletRequestAttributes threadAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (threadAttributes != null) {
            if (attributes2 == null) {
                attributes2 = threadAttributes;
            }
            LocaleContextHolder.resetLocaleContext();
            RequestContextHolder.resetRequestAttributes();
        }
        if (attributes2 != null) {
            attributes2.requestCompleted();
        }
    }
}

