/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.support;

import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.annotation.AnnotatedBeanDefinitionReader;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.context.annotation.ScopeMetadataResolver;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.support.AbstractRefreshableWebApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationConfigWebApplicationContext
extends AbstractRefreshableWebApplicationContext {
    private Class<?>[] annotatedClasses;
    private String[] basePackages;
    private BeanNameGenerator beanNameGenerator;
    private ScopeMetadataResolver scopeMetadataResolver;

    @Override
    public void setConfigLocation(String location2) {
        super.setConfigLocation(location2);
    }

    @Override
    public void setConfigLocations(String[] locations) {
        super.setConfigLocations(locations);
    }

    public void register(Class<?> ... annotatedClasses) {
        Assert.notEmpty(annotatedClasses, "At least one annotated class must be specified");
        this.annotatedClasses = annotatedClasses;
    }

    public void scan(String ... basePackages) {
        Assert.notEmpty(basePackages, "At least one base package must be specified");
        this.basePackages = basePackages;
    }

    @Override
    protected void loadBeanDefinitions(DefaultListableBeanFactory beanFactory) {
        String[] configLocations;
        AnnotatedBeanDefinitionReader reader2 = new AnnotatedBeanDefinitionReader(beanFactory);
        reader2.setEnvironment(this.getEnvironment());
        ClassPathBeanDefinitionScanner scanner = new ClassPathBeanDefinitionScanner(beanFactory);
        scanner.setEnvironment(this.getEnvironment());
        BeanNameGenerator beanNameGenerator = this.getBeanNameGenerator();
        ScopeMetadataResolver scopeMetadataResolver = this.getScopeMetadataResolver();
        if (beanNameGenerator != null) {
            reader2.setBeanNameGenerator(beanNameGenerator);
            scanner.setBeanNameGenerator(beanNameGenerator);
            beanFactory.registerSingleton("org.springframework.context.annotation.internalConfigurationBeanNameGenerator", beanNameGenerator);
        }
        if (scopeMetadataResolver != null) {
            reader2.setScopeMetadataResolver(scopeMetadataResolver);
            scanner.setScopeMetadataResolver(scopeMetadataResolver);
        }
        if (!ObjectUtils.isEmpty(this.annotatedClasses)) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Registering annotated classes: [" + StringUtils.arrayToCommaDelimitedString(this.annotatedClasses) + "]");
            }
            reader2.register(this.annotatedClasses);
        }
        if (!ObjectUtils.isEmpty(this.basePackages)) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Scanning base packages: [" + StringUtils.arrayToCommaDelimitedString(this.basePackages) + "]");
            }
            scanner.scan(this.basePackages);
        }
        if ((configLocations = this.getConfigLocations()) != null) {
            String[] stringArray = configLocations;
            int n = configLocations.length;
            int n2 = 0;
            while (n2 < n) {
                block13: {
                    String configLocation = stringArray[n2];
                    try {
                        Class<?> clazz2 = this.getClassLoader().loadClass(configLocation);
                        if (this.logger.isInfoEnabled()) {
                            this.logger.info("Successfully resolved class for [" + configLocation + "]");
                        }
                        reader2.register(clazz2);
                    }
                    catch (ClassNotFoundException ex2) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("Could not load class for config location [" + configLocation + "] - trying package scan. " + ex2);
                        }
                        int count2 = scanner.scan(configLocation);
                        if (!this.logger.isInfoEnabled()) break block13;
                        if (count2 == 0) {
                            this.logger.info("No annotated classes found for specified class/package [" + configLocation + "]");
                        }
                        this.logger.info("Found " + count2 + " annotated classes in package [" + configLocation + "]");
                    }
                }
                ++n2;
            }
        }
    }

    public void setBeanNameGenerator(BeanNameGenerator beanNameGenerator) {
        this.beanNameGenerator = beanNameGenerator;
    }

    protected BeanNameGenerator getBeanNameGenerator() {
        return this.beanNameGenerator;
    }

    public void setScopeMetadataResolver(ScopeMetadataResolver scopeMetadataResolver) {
        this.scopeMetadataResolver = scopeMetadataResolver;
    }

    protected ScopeMetadataResolver getScopeMetadataResolver() {
        return this.scopeMetadataResolver;
    }
}

