/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.jsf;

import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.VariableResolver;
import org.springframework.util.Assert;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.jsf.FacesContextUtils;

public class WebApplicationContextVariableResolver
extends VariableResolver {
    public static final String WEB_APPLICATION_CONTEXT_VARIABLE_NAME = "webApplicationContext";
    protected final VariableResolver originalVariableResolver;

    public WebApplicationContextVariableResolver(VariableResolver originalVariableResolver) {
        Assert.notNull(originalVariableResolver, "Original JSF VariableResolver must not be null");
        this.originalVariableResolver = originalVariableResolver;
    }

    protected final VariableResolver getOriginalVariableResolver() {
        return this.originalVariableResolver;
    }

    public Object resolveVariable(FacesContext context, String name) throws EvaluationException {
        Object value2 = null;
        if (WEB_APPLICATION_CONTEXT_VARIABLE_NAME.equals(name)) {
            value2 = this.getWebApplicationContext(context);
        }
        if (value2 == null) {
            value2 = this.getOriginalVariableResolver().resolveVariable(context, name);
        }
        return value2;
    }

    protected WebApplicationContext getWebApplicationContext(FacesContext facesContext) {
        return FacesContextUtils.getWebApplicationContext(facesContext);
    }
}

