/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.method.annotation;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpHeaders;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class RequestHeaderMapMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.hasParameterAnnotation(RequestHeader.class) && Map.class.isAssignableFrom(parameter.getParameterType());
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        Class<?> paramType = parameter.getParameterType();
        if (MultiValueMap.class.isAssignableFrom(paramType)) {
            MultiValueMap<String, String> result2 = HttpHeaders.class.isAssignableFrom(paramType) ? new HttpHeaders() : new LinkedMultiValueMap();
            Iterator<String> iterator2 = webRequest.getHeaderNames();
            while (iterator2.hasNext()) {
                String headerName = iterator2.next();
                String[] stringArray = webRequest.getHeaderValues(headerName);
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String headerValue = stringArray[n2];
                    result2.add(headerName, headerValue);
                    ++n2;
                }
            }
            return result2;
        }
        LinkedHashMap<String, String> result3 = new LinkedHashMap<String, String>();
        Iterator<String> iterator3 = webRequest.getHeaderNames();
        while (iterator3.hasNext()) {
            String headerName = iterator3.next();
            String headerValue = webRequest.getHeader(headerName);
            result3.put(headerName, headerValue);
        }
        return result3;
    }
}

