/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.method.annotation;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.bind.support.SessionAttributeStore;
import org.springframework.web.context.request.WebRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionAttributesHandler {
    private final Set<String> attributeNames = new HashSet<String>();
    private final Set<Class<?>> attributeTypes = new HashSet();
    private final Set<String> knownAttributeNames = Collections.synchronizedSet(new HashSet(4));
    private final SessionAttributeStore sessionAttributeStore;

    public SessionAttributesHandler(Class<?> handlerType, SessionAttributeStore sessionAttributeStore) {
        Assert.notNull(sessionAttributeStore, "SessionAttributeStore may not be null.");
        this.sessionAttributeStore = sessionAttributeStore;
        SessionAttributes annotation2 = AnnotationUtils.findAnnotation(handlerType, SessionAttributes.class);
        if (annotation2 != null) {
            this.attributeNames.addAll((Collection<String>)Arrays.asList(annotation2.value()));
            this.attributeTypes.addAll((Collection)Arrays.asList(annotation2.types()));
        }
        this.knownAttributeNames.addAll(this.attributeNames);
    }

    public boolean hasSessionAttributes() {
        return this.attributeNames.size() > 0 || this.attributeTypes.size() > 0;
    }

    public boolean isHandlerSessionAttribute(String attributeName, Class<?> attributeType) {
        Assert.notNull(attributeName, "Attribute name must not be null");
        if (this.attributeNames.contains(attributeName) || this.attributeTypes.contains(attributeType)) {
            this.knownAttributeNames.add(attributeName);
            return true;
        }
        return false;
    }

    public void storeAttributes(WebRequest request, Map<String, ?> attributes2) {
        for (String name : attributes2.keySet()) {
            Class<?> attrType;
            Object value2 = attributes2.get(name);
            Class<?> clazz2 = attrType = value2 != null ? value2.getClass() : null;
            if (!this.isHandlerSessionAttribute(name, attrType)) continue;
            this.sessionAttributeStore.storeAttribute(request, name, value2);
        }
    }

    public Map<String, Object> retrieveAttributes(WebRequest request) {
        HashMap<String, Object> attributes2 = new HashMap<String, Object>();
        for (String name : this.knownAttributeNames) {
            Object value2 = this.sessionAttributeStore.retrieveAttribute(request, name);
            if (value2 == null) continue;
            attributes2.put(name, value2);
        }
        return attributes2;
    }

    public void cleanupAttributes(WebRequest request) {
        for (String attributeName : this.knownAttributeNames) {
            this.sessionAttributeStore.cleanupAttribute(request, attributeName);
        }
    }

    Object retrieveAttribute(WebRequest request, String attributeName) {
        return this.sessionAttributeStore.retrieveAttribute(request, attributeName);
    }
}

