/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.method.support;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.method.support.HandlerMethodArgumentResolverComposite;
import org.springframework.web.method.support.ModelAndViewContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvocableHandlerMethod
extends HandlerMethod {
    private HandlerMethodArgumentResolverComposite argumentResolvers = new HandlerMethodArgumentResolverComposite();
    private WebDataBinderFactory dataBinderFactory;
    private ParameterNameDiscoverer parameterNameDiscoverer = new LocalVariableTableParameterNameDiscoverer();

    public InvocableHandlerMethod(Object bean, Method method) {
        super(bean, method);
    }

    public InvocableHandlerMethod(Object bean, String methodName, Class<?> ... parameterTypes) throws NoSuchMethodException {
        super(bean, methodName, parameterTypes);
    }

    public void setDataBinderFactory(WebDataBinderFactory dataBinderFactory) {
        this.dataBinderFactory = dataBinderFactory;
    }

    public void setHandlerMethodArgumentResolvers(HandlerMethodArgumentResolverComposite argumentResolvers) {
        this.argumentResolvers = argumentResolvers;
    }

    public void setParameterNameDiscoverer(ParameterNameDiscoverer parameterNameDiscoverer) {
        this.parameterNameDiscoverer = parameterNameDiscoverer;
    }

    public final Object invokeForRequest(NativeWebRequest request, ModelAndViewContainer mavContainer, Object ... providedArgs) throws Exception {
        Object[] args2 = this.getMethodArgumentValues(request, mavContainer, providedArgs);
        if (this.logger.isTraceEnabled()) {
            StringBuilder builder = new StringBuilder("Invoking [");
            builder.append(this.getMethod().getName()).append("] method with arguments ");
            builder.append(Arrays.asList(args2));
            this.logger.trace(builder.toString());
        }
        Object returnValue = this.invoke(args2);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Method [" + this.getMethod().getName() + "] returned [" + returnValue + "]");
        }
        return returnValue;
    }

    private Object[] getMethodArgumentValues(NativeWebRequest request, ModelAndViewContainer mavContainer, Object ... providedArgs) throws Exception {
        MethodParameter[] parameters2 = this.getMethodParameters();
        Object[] args2 = new Object[parameters2.length];
        int i = 0;
        while (i < parameters2.length) {
            MethodParameter parameter = parameters2[i];
            parameter.initParameterNameDiscovery(this.parameterNameDiscoverer);
            GenericTypeResolver.resolveParameterType(parameter, this.getBean().getClass());
            args2[i] = this.resolveProvidedArgument(parameter, providedArgs);
            if (args2[i] == null) {
                if (this.argumentResolvers.supportsParameter(parameter)) {
                    try {
                        args2[i] = this.argumentResolvers.resolveArgument(parameter, mavContainer, request, this.dataBinderFactory);
                    }
                    catch (Exception ex2) {
                        if (this.logger.isTraceEnabled()) {
                            this.logger.trace(this.getArgumentResolutionErrorMessage("Error resolving argument", i), ex2);
                        }
                        throw ex2;
                    }
                } else if (args2[i] == null) {
                    String msg = this.getArgumentResolutionErrorMessage("No suitable resolver for argument", i);
                    throw new IllegalStateException(msg);
                }
            }
            ++i;
        }
        return args2;
    }

    private String getArgumentResolutionErrorMessage(String message, int index2) {
        MethodParameter param2 = this.getMethodParameters()[index2];
        message = String.valueOf(message) + " [" + index2 + "] [type=" + param2.getParameterType().getName() + "]";
        return this.getDetailedErrorMessage(message);
    }

    protected String getDetailedErrorMessage(String message) {
        StringBuilder sb = new StringBuilder(message).append("\n");
        sb.append("HandlerMethod details: \n");
        sb.append("Controller [").append(this.getBeanType().getName()).append("]\n");
        sb.append("Method [").append(this.getBridgedMethod().toGenericString()).append("]\n");
        return sb.toString();
    }

    private Object resolveProvidedArgument(MethodParameter parameter, Object ... providedArgs) {
        if (providedArgs == null || parameter.hasParameterAnnotations()) {
            return null;
        }
        Object[] objectArray = providedArgs;
        int n = providedArgs.length;
        int n2 = 0;
        while (n2 < n) {
            Object providedArg = objectArray[n2];
            if (parameter.getParameterType().isInstance(providedArg)) {
                return providedArg;
            }
            ++n2;
        }
        return null;
    }

    private Object invoke(Object ... args2) throws Exception {
        ReflectionUtils.makeAccessible(this.getBridgedMethod());
        try {
            return this.getBridgedMethod().invoke(this.getBean(), args2);
        }
        catch (IllegalArgumentException e2) {
            String msg = this.getInvocationErrorMessage(e2.getMessage(), args2);
            throw new IllegalArgumentException(msg, e2);
        }
        catch (InvocationTargetException e3) {
            Throwable targetException = e3.getTargetException();
            if (targetException instanceof RuntimeException) {
                throw (RuntimeException)targetException;
            }
            if (targetException instanceof Error) {
                throw (Error)targetException;
            }
            if (targetException instanceof Exception) {
                throw (Exception)targetException;
            }
            String msg = this.getInvocationErrorMessage("Failed to invoke controller method", args2);
            throw new IllegalStateException(msg, targetException);
        }
    }

    private String getInvocationErrorMessage(String message, Object[] resolvedArgs) {
        StringBuilder sb = new StringBuilder(this.getDetailedErrorMessage(message));
        sb.append("Resolved arguments: \n");
        int i = 0;
        while (i < resolvedArgs.length) {
            sb.append("[").append(i).append("] ");
            if (resolvedArgs[i] == null) {
                sb.append("[null] \n");
            } else {
                sb.append("[type=").append(resolvedArgs[i].getClass().getName()).append("] ");
                sb.append("[value=").append(resolvedArgs[i]).append("]\n");
            }
            ++i;
        }
        return sb.toString();
    }
}

