/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util;

import java.io.FileNotFoundException;
import javax.servlet.ServletContext;
import org.springframework.util.Log4jConfigurer;
import org.springframework.util.ResourceUtils;
import org.springframework.util.SystemPropertyUtils;
import org.springframework.web.util.WebUtils;

public abstract class Log4jWebConfigurer {
    public static final String CONFIG_LOCATION_PARAM = "log4jConfigLocation";
    public static final String REFRESH_INTERVAL_PARAM = "log4jRefreshInterval";
    public static final String EXPOSE_WEB_APP_ROOT_PARAM = "log4jExposeWebAppRoot";

    public static void initLogging(ServletContext servletContext) {
        block8: {
            String location2;
            if (Log4jWebConfigurer.exposeWebAppRoot(servletContext)) {
                WebUtils.setWebAppRootSystemProperty(servletContext);
            }
            if ((location2 = servletContext.getInitParameter(CONFIG_LOCATION_PARAM)) != null) {
                try {
                    if (!ResourceUtils.isUrl(location2)) {
                        location2 = SystemPropertyUtils.resolvePlaceholders(location2);
                        location2 = WebUtils.getRealPath(servletContext, location2);
                    }
                    servletContext.log("Initializing log4j from [" + location2 + "]");
                    String intervalString = servletContext.getInitParameter(REFRESH_INTERVAL_PARAM);
                    if (intervalString != null) {
                        try {
                            long refreshInterval = Long.parseLong(intervalString);
                            Log4jConfigurer.initLogging(location2, refreshInterval);
                            break block8;
                        }
                        catch (NumberFormatException ex2) {
                            throw new IllegalArgumentException("Invalid 'log4jRefreshInterval' parameter: " + ex2.getMessage());
                        }
                    }
                    Log4jConfigurer.initLogging(location2);
                }
                catch (FileNotFoundException ex3) {
                    throw new IllegalArgumentException("Invalid 'log4jConfigLocation' parameter: " + ex3.getMessage());
                }
            }
        }
    }

    public static void shutdownLogging(ServletContext servletContext) {
        servletContext.log("Shutting down log4j");
        try {
            Log4jConfigurer.shutdownLogging();
        }
        finally {
            if (Log4jWebConfigurer.exposeWebAppRoot(servletContext)) {
                WebUtils.removeWebAppRootSystemProperty(servletContext);
            }
        }
    }

    private static boolean exposeWebAppRoot(ServletContext servletContext) {
        String exposeWebAppRootParam = servletContext.getInitParameter(EXPOSE_WEB_APP_ROOT_PARAM);
        return exposeWebAppRootParam == null || Boolean.valueOf(exposeWebAppRootParam) != false;
    }
}

