/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UriComponents {
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final char PATH_DELIMITER = '/';
    private static final Pattern NAMES_PATTERN = Pattern.compile("\\{([^/]+?)\\}");
    private final String scheme;
    private final String userInfo;
    private final String host;
    private final int port;
    private final PathComponent path;
    private final MultiValueMap<String, String> queryParams;
    private final String fragment;
    private final boolean encoded;
    static final PathComponent NULL_PATH_COMPONENT = new PathComponent(){

        @Override
        public String getPath() {
            return null;
        }

        @Override
        public List<String> getPathSegments() {
            return Collections.emptyList();
        }

        @Override
        public PathComponent encode(String encoding) throws UnsupportedEncodingException {
            return this;
        }

        @Override
        public void verify() {
        }

        @Override
        public PathComponent expand(UriTemplateVariables uriVariables) {
            return this;
        }

        public boolean equals(Object o) {
            return this == o;
        }

        public int hashCode() {
            return 42;
        }
    };

    UriComponents(String scheme, String userInfo, String host, int port, PathComponent path2, MultiValueMap<String, String> queryParams, String fragment, boolean encoded, boolean verify2) {
        this.scheme = scheme;
        this.userInfo = userInfo;
        this.host = host;
        this.port = port;
        this.path = path2 != null ? path2 : NULL_PATH_COMPONENT;
        this.queryParams = CollectionUtils.unmodifiableMultiValueMap(queryParams != null ? queryParams : new LinkedMultiValueMap(0));
        this.fragment = fragment;
        this.encoded = encoded;
        if (verify2) {
            this.verify();
        }
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getUserInfo() {
        return this.userInfo;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getPath() {
        return this.path.getPath();
    }

    public List<String> getPathSegments() {
        return this.path.getPathSegments();
    }

    public String getQuery() {
        if (!this.queryParams.isEmpty()) {
            StringBuilder queryBuilder = new StringBuilder();
            for (Map.Entry entry2 : this.queryParams.entrySet()) {
                String name = (String)entry2.getKey();
                List values2 = (List)entry2.getValue();
                if (CollectionUtils.isEmpty(values2)) {
                    if (queryBuilder.length() != 0) {
                        queryBuilder.append('&');
                    }
                    queryBuilder.append(name);
                    continue;
                }
                for (Object value2 : values2) {
                    if (queryBuilder.length() != 0) {
                        queryBuilder.append('&');
                    }
                    queryBuilder.append(name);
                    if (value2 == null) continue;
                    queryBuilder.append('=');
                    queryBuilder.append(value2.toString());
                }
            }
            return queryBuilder.toString();
        }
        return null;
    }

    public MultiValueMap<String, String> getQueryParams() {
        return this.queryParams;
    }

    public String getFragment() {
        return this.fragment;
    }

    public UriComponents encode() {
        try {
            return this.encode(DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InternalError("\"UTF-8\" not supported");
        }
    }

    public UriComponents encode(String encoding) throws UnsupportedEncodingException {
        Assert.hasLength(encoding, "'encoding' must not be empty");
        if (this.encoded) {
            return this;
        }
        String encodedScheme = UriComponents.encodeUriComponent(this.scheme, encoding, Type.SCHEME);
        String encodedUserInfo = UriComponents.encodeUriComponent(this.userInfo, encoding, Type.USER_INFO);
        String encodedHost = UriComponents.encodeUriComponent(this.host, encoding, Type.HOST);
        PathComponent encodedPath = this.path.encode(encoding);
        LinkedMultiValueMap<String, String> encodedQueryParams = new LinkedMultiValueMap<String, String>(this.queryParams.size());
        for (Map.Entry entry2 : this.queryParams.entrySet()) {
            String encodedName = UriComponents.encodeUriComponent((String)entry2.getKey(), encoding, Type.QUERY_PARAM);
            ArrayList<String> encodedValues = new ArrayList<String>(((List)entry2.getValue()).size());
            for (String value2 : (List)entry2.getValue()) {
                String encodedValue = UriComponents.encodeUriComponent(value2, encoding, Type.QUERY_PARAM);
                encodedValues.add(encodedValue);
            }
            encodedQueryParams.put(encodedName, (String)((Object)encodedValues));
        }
        String encodedFragment = UriComponents.encodeUriComponent(this.fragment, encoding, Type.FRAGMENT);
        return new UriComponents(encodedScheme, encodedUserInfo, encodedHost, this.port, encodedPath, encodedQueryParams, encodedFragment, true, false);
    }

    static String encodeUriComponent(String source, String encoding, Type type) throws UnsupportedEncodingException {
        if (source == null) {
            return null;
        }
        Assert.hasLength(encoding, "'encoding' must not be empty");
        byte[] bytes2 = UriComponents.encodeBytes(source.getBytes(encoding), type);
        return new String(bytes2, "US-ASCII");
    }

    private static byte[] encodeBytes(byte[] source, Type type) {
        Assert.notNull(source, "'source' must not be null");
        Assert.notNull((Object)type, "'type' must not be null");
        ByteArrayOutputStream bos = new ByteArrayOutputStream(source.length);
        int i = 0;
        while (i < source.length) {
            int b = source[i];
            if (b < 0) {
                b += 256;
            }
            if (type.isAllowed(b)) {
                bos.write(b);
            } else {
                bos.write(37);
                char hex1 = Character.toUpperCase(Character.forDigit(b >> 4 & 0xF, 16));
                char hex2 = Character.toUpperCase(Character.forDigit(b & 0xF, 16));
                bos.write(hex1);
                bos.write(hex2);
            }
            ++i;
        }
        return bos.toByteArray();
    }

    private void verify() {
        if (!this.encoded) {
            return;
        }
        UriComponents.verifyUriComponent(this.scheme, Type.SCHEME);
        UriComponents.verifyUriComponent(this.userInfo, Type.USER_INFO);
        UriComponents.verifyUriComponent(this.host, Type.HOST);
        this.path.verify();
        for (Map.Entry entry2 : this.queryParams.entrySet()) {
            UriComponents.verifyUriComponent((String)entry2.getKey(), Type.QUERY_PARAM);
            for (String value2 : (List)entry2.getValue()) {
                UriComponents.verifyUriComponent(value2, Type.QUERY_PARAM);
            }
        }
        UriComponents.verifyUriComponent(this.fragment, Type.FRAGMENT);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void verifyUriComponent(String source, Type type) {
        if (source == null) {
            return;
        }
        int length2 = source.length();
        int i = 0;
        while (i < length2) {
            char ch = source.charAt(i);
            if (ch == '%') {
                if (i + 2 >= length2) throw new IllegalArgumentException("Invalid encoded sequence \"" + source.substring(i) + "\"");
                char hex1 = source.charAt(i + 1);
                char hex2 = source.charAt(i + 2);
                int u = Character.digit(hex1, 16);
                int l = Character.digit(hex2, 16);
                if (u == -1 || l == -1) {
                    throw new IllegalArgumentException("Invalid encoded sequence \"" + source.substring(i) + "\"");
                }
                i += 2;
            } else if (!type.isAllowed(ch)) {
                throw new IllegalArgumentException("Invalid character '" + ch + "' for " + type.name() + " in \"" + source + "\"");
            }
            ++i;
        }
    }

    public UriComponents expand(Map<String, ?> uriVariables) {
        Assert.notNull(uriVariables, "'uriVariables' must not be null");
        return this.expandInternal(new MapTemplateVariables(uriVariables));
    }

    public UriComponents expand(Object ... uriVariableValues) {
        Assert.notNull(uriVariableValues, "'uriVariableValues' must not be null");
        return this.expandInternal(new VarArgsTemplateVariables(uriVariableValues));
    }

    private UriComponents expandInternal(UriTemplateVariables uriVariables) {
        Assert.state(!this.encoded, "Cannot expand an already encoded UriComponents object");
        String expandedScheme = UriComponents.expandUriComponent(this.scheme, uriVariables);
        String expandedUserInfo = UriComponents.expandUriComponent(this.userInfo, uriVariables);
        String expandedHost = UriComponents.expandUriComponent(this.host, uriVariables);
        PathComponent expandedPath = this.path.expand(uriVariables);
        LinkedMultiValueMap<String, String> expandedQueryParams = new LinkedMultiValueMap<String, String>(this.queryParams.size());
        for (Map.Entry entry2 : this.queryParams.entrySet()) {
            String expandedName = UriComponents.expandUriComponent((String)entry2.getKey(), uriVariables);
            ArrayList<String> expandedValues = new ArrayList<String>(((List)entry2.getValue()).size());
            for (String value2 : (List)entry2.getValue()) {
                String expandedValue = UriComponents.expandUriComponent(value2, uriVariables);
                expandedValues.add(expandedValue);
            }
            expandedQueryParams.put(expandedName, (String)((Object)expandedValues));
        }
        String expandedFragment = UriComponents.expandUriComponent(this.fragment, uriVariables);
        return new UriComponents(expandedScheme, expandedUserInfo, expandedHost, this.port, expandedPath, expandedQueryParams, expandedFragment, false, false);
    }

    private static String expandUriComponent(String source, UriTemplateVariables uriVariables) {
        if (source == null) {
            return null;
        }
        if (source.indexOf(123) == -1) {
            return source;
        }
        Matcher matcher2 = NAMES_PATTERN.matcher(source);
        StringBuffer sb = new StringBuffer();
        while (matcher2.find()) {
            String match = matcher2.group(1);
            String variableName = UriComponents.getVariableName(match);
            Object variableValue = uriVariables.getValue(variableName);
            String variableValueString = UriComponents.getVariableValueAsString(variableValue);
            String replacement = Matcher.quoteReplacement(variableValueString);
            matcher2.appendReplacement(sb, replacement);
        }
        matcher2.appendTail(sb);
        return sb.toString();
    }

    private static String getVariableName(String match) {
        int colonIdx = match.indexOf(58);
        return colonIdx == -1 ? match : match.substring(0, colonIdx);
    }

    private static String getVariableValueAsString(Object variableValue) {
        return variableValue != null ? variableValue.toString() : "";
    }

    public UriComponents normalize() {
        String normalizedPath = StringUtils.cleanPath(this.getPath());
        return new UriComponents(this.scheme, this.userInfo, this.host, this.port, new FullPathComponent(normalizedPath), this.queryParams, this.fragment, this.encoded, false);
    }

    public String toUriString() {
        String query2;
        String path2;
        StringBuilder uriBuilder = new StringBuilder();
        if (this.scheme != null) {
            uriBuilder.append(this.scheme);
            uriBuilder.append(':');
        }
        if (this.userInfo != null || this.host != null) {
            uriBuilder.append("//");
            if (this.userInfo != null) {
                uriBuilder.append(this.userInfo);
                uriBuilder.append('@');
            }
            if (this.host != null) {
                uriBuilder.append(this.host);
            }
            if (this.port != -1) {
                uriBuilder.append(':');
                uriBuilder.append(this.port);
            }
        }
        if (StringUtils.hasLength(path2 = this.getPath())) {
            if (uriBuilder.length() != 0 && path2.charAt(0) != '/') {
                uriBuilder.append('/');
            }
            uriBuilder.append(path2);
        }
        if ((query2 = this.getQuery()) != null) {
            uriBuilder.append('?');
            uriBuilder.append(query2);
        }
        if (this.fragment != null) {
            uriBuilder.append('#');
            uriBuilder.append(this.fragment);
        }
        return uriBuilder.toString();
    }

    public URI toUri() {
        try {
            if (this.encoded) {
                return new URI(this.toUriString());
            }
            String path2 = this.getPath();
            if (StringUtils.hasLength(path2) && path2.charAt(0) != '/') {
                path2 = String.valueOf('/') + path2;
            }
            return new URI(this.getScheme(), this.getUserInfo(), this.getHost(), this.getPort(), path2, this.getQuery(), this.getFragment());
        }
        catch (URISyntaxException ex2) {
            throw new IllegalStateException("Could not create URI object: " + ex2.getMessage(), ex2);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof UriComponents) {
            UriComponents other = (UriComponents)o;
            if (this.scheme != null ? !this.scheme.equals(other.scheme) : other.scheme != null) {
                return false;
            }
            if (this.userInfo != null ? !this.userInfo.equals(other.userInfo) : other.userInfo != null) {
                return false;
            }
            if (this.host != null ? !this.host.equals(other.host) : other.host != null) {
                return false;
            }
            if (this.port != other.port) {
                return false;
            }
            if (!this.path.equals(other.path)) {
                return false;
            }
            if (!this.queryParams.equals(other.queryParams)) {
                return false;
            }
            return !(this.fragment != null ? !this.fragment.equals(other.fragment) : other.fragment != null);
        }
        return false;
    }

    public int hashCode() {
        int result2 = this.scheme != null ? this.scheme.hashCode() : 0;
        result2 = 31 * result2 + (this.userInfo != null ? this.userInfo.hashCode() : 0);
        result2 = 31 * result2 + (this.host != null ? this.host.hashCode() : 0);
        result2 = 31 * result2 + this.port;
        result2 = 31 * result2 + this.path.hashCode();
        result2 = 31 * result2 + this.queryParams.hashCode();
        result2 = 31 * result2 + (this.fragment != null ? this.fragment.hashCode() : 0);
        return result2;
    }

    public String toString() {
        return this.toUriString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class FullPathComponent
    implements PathComponent {
        private final String path;

        FullPathComponent(String path2) {
            this.path = path2;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public List<String> getPathSegments() {
            String delimiter = new String(new char[]{'/'});
            String[] pathSegments = StringUtils.tokenizeToStringArray(this.path, delimiter);
            return Collections.unmodifiableList(Arrays.asList(pathSegments));
        }

        @Override
        public PathComponent encode(String encoding) throws UnsupportedEncodingException {
            String encodedPath = UriComponents.encodeUriComponent(this.getPath(), encoding, Type.PATH);
            return new FullPathComponent(encodedPath);
        }

        @Override
        public void verify() {
            UriComponents.verifyUriComponent(this.path, Type.PATH);
        }

        @Override
        public PathComponent expand(UriTemplateVariables uriVariables) {
            String expandedPath = UriComponents.expandUriComponent(this.getPath(), uriVariables);
            return new FullPathComponent(expandedPath);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof FullPathComponent) {
                FullPathComponent other = (FullPathComponent)o;
                return this.getPath().equals(other.getPath());
            }
            return false;
        }

        public int hashCode() {
            return this.getPath().hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MapTemplateVariables
    implements UriTemplateVariables {
        private final Map<String, ?> uriVariables;

        public MapTemplateVariables(Map<String, ?> uriVariables) {
            this.uriVariables = uriVariables;
        }

        @Override
        public Object getValue(String name) {
            if (!this.uriVariables.containsKey(name)) {
                throw new IllegalArgumentException("Map has no value for '" + name + "'");
            }
            return this.uriVariables.get(name);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface PathComponent {
        public String getPath();

        public List<String> getPathSegments();

        public PathComponent encode(String var1) throws UnsupportedEncodingException;

        public void verify();

        public PathComponent expand(UriTemplateVariables var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class PathComponentComposite
    implements PathComponent {
        private final List<PathComponent> pathComponents;

        PathComponentComposite(List<PathComponent> pathComponents) {
            this.pathComponents = pathComponents;
        }

        @Override
        public String getPath() {
            StringBuilder pathBuilder = new StringBuilder();
            for (PathComponent pathComponent : this.pathComponents) {
                pathBuilder.append(pathComponent.getPath());
            }
            return pathBuilder.toString();
        }

        @Override
        public List<String> getPathSegments() {
            ArrayList<String> result2 = new ArrayList<String>();
            for (PathComponent pathComponent : this.pathComponents) {
                result2.addAll(pathComponent.getPathSegments());
            }
            return result2;
        }

        @Override
        public PathComponent encode(String encoding) throws UnsupportedEncodingException {
            ArrayList<PathComponent> encodedComponents = new ArrayList<PathComponent>(this.pathComponents.size());
            for (PathComponent pathComponent : this.pathComponents) {
                encodedComponents.add(pathComponent.encode(encoding));
            }
            return new PathComponentComposite(encodedComponents);
        }

        @Override
        public void verify() {
            for (PathComponent pathComponent : this.pathComponents) {
                pathComponent.verify();
            }
        }

        @Override
        public PathComponent expand(UriTemplateVariables uriVariables) {
            ArrayList<PathComponent> expandedComponents = new ArrayList<PathComponent>(this.pathComponents.size());
            for (PathComponent pathComponent : this.pathComponents) {
                expandedComponents.add(pathComponent.expand(uriVariables));
            }
            return new PathComponentComposite(expandedComponents);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class PathSegmentComponent
    implements PathComponent {
        private final List<String> pathSegments;

        PathSegmentComponent(List<String> pathSegments) {
            this.pathSegments = Collections.unmodifiableList(pathSegments);
        }

        @Override
        public String getPath() {
            StringBuilder pathBuilder = new StringBuilder();
            pathBuilder.append('/');
            Iterator<String> iterator2 = this.pathSegments.iterator();
            while (iterator2.hasNext()) {
                String pathSegment = iterator2.next();
                pathBuilder.append(pathSegment);
                if (!iterator2.hasNext()) continue;
                pathBuilder.append('/');
            }
            return pathBuilder.toString();
        }

        @Override
        public List<String> getPathSegments() {
            return this.pathSegments;
        }

        @Override
        public PathComponent encode(String encoding) throws UnsupportedEncodingException {
            List<String> pathSegments = this.getPathSegments();
            ArrayList<String> encodedPathSegments = new ArrayList<String>(pathSegments.size());
            for (String pathSegment : pathSegments) {
                String encodedPathSegment = UriComponents.encodeUriComponent(pathSegment, encoding, Type.PATH_SEGMENT);
                encodedPathSegments.add(encodedPathSegment);
            }
            return new PathSegmentComponent(encodedPathSegments);
        }

        @Override
        public void verify() {
            for (String pathSegment : this.getPathSegments()) {
                UriComponents.verifyUriComponent(pathSegment, Type.PATH_SEGMENT);
            }
        }

        @Override
        public PathComponent expand(UriTemplateVariables uriVariables) {
            List<String> pathSegments = this.getPathSegments();
            ArrayList<String> expandedPathSegments = new ArrayList<String>(pathSegments.size());
            for (String pathSegment : pathSegments) {
                String expandedPathSegment = UriComponents.expandUriComponent(pathSegment, uriVariables);
                expandedPathSegments.add(expandedPathSegment);
            }
            return new PathSegmentComponent(expandedPathSegments);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof PathSegmentComponent) {
                PathSegmentComponent other = (PathSegmentComponent)o;
                return this.getPathSegments().equals(other.getPathSegments());
            }
            return false;
        }

        public int hashCode() {
            return this.getPathSegments().hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Type {
        SCHEME{

            public boolean isAllowed(int c2) {
                return this.isAlpha(c2) || this.isDigit(c2) || 43 == c2 || 45 == c2 || 46 == c2;
            }
        }
        ,
        AUTHORITY{

            public boolean isAllowed(int c2) {
                return this.isUnreserved(c2) || this.isSubDelimiter(c2) || 58 == c2 || 64 == c2;
            }
        }
        ,
        USER_INFO{

            public boolean isAllowed(int c2) {
                return this.isUnreserved(c2) || this.isSubDelimiter(c2) || 58 == c2;
            }
        }
        ,
        HOST{

            public boolean isAllowed(int c2) {
                return this.isUnreserved(c2) || this.isSubDelimiter(c2);
            }
        }
        ,
        PORT{

            public boolean isAllowed(int c2) {
                return this.isDigit(c2);
            }
        }
        ,
        PATH{

            public boolean isAllowed(int c2) {
                return this.isPchar(c2) || 47 == c2;
            }
        }
        ,
        PATH_SEGMENT{

            public boolean isAllowed(int c2) {
                return this.isPchar(c2);
            }
        }
        ,
        QUERY{

            public boolean isAllowed(int c2) {
                return this.isPchar(c2) || 47 == c2 || 63 == c2;
            }
        }
        ,
        QUERY_PARAM{

            public boolean isAllowed(int c2) {
                if (61 == c2 || 43 == c2 || 38 == c2) {
                    return false;
                }
                return this.isPchar(c2) || 47 == c2 || 63 == c2;
            }
        }
        ,
        FRAGMENT{

            public boolean isAllowed(int c2) {
                return this.isPchar(c2) || 47 == c2 || 63 == c2;
            }
        };


        public abstract boolean isAllowed(int var1);

        protected boolean isAlpha(int c2) {
            return c2 >= 97 && c2 <= 122 || c2 >= 65 && c2 <= 90;
        }

        protected boolean isDigit(int c2) {
            return c2 >= 48 && c2 <= 57;
        }

        protected boolean isGenericDelimiter(int c2) {
            return 58 == c2 || 47 == c2 || 63 == c2 || 35 == c2 || 91 == c2 || 93 == c2 || 64 == c2;
        }

        protected boolean isSubDelimiter(int c2) {
            return 33 == c2 || 36 == c2 || 38 == c2 || 39 == c2 || 40 == c2 || 41 == c2 || 42 == c2 || 43 == c2 || 44 == c2 || 59 == c2 || 61 == c2;
        }

        protected boolean isReserved(char c2) {
            return this.isGenericDelimiter(c2) || this.isReserved(c2);
        }

        protected boolean isUnreserved(int c2) {
            return this.isAlpha(c2) || this.isDigit(c2) || 45 == c2 || 46 == c2 || 95 == c2 || 126 == c2;
        }

        protected boolean isPchar(int c2) {
            return this.isUnreserved(c2) || this.isSubDelimiter(c2) || 58 == c2 || 64 == c2;
        }
    }

    private static interface UriTemplateVariables {
        public Object getValue(String var1);
    }

    private static class VarArgsTemplateVariables
    implements UriTemplateVariables {
        private final Iterator<Object> valueIterator;

        public VarArgsTemplateVariables(Object ... uriVariableValues) {
            this.valueIterator = Arrays.asList(uriVariableValues).iterator();
        }

        public Object getValue(String name) {
            if (!this.valueIterator.hasNext()) {
                throw new IllegalArgumentException("Not enough variable values available to expand '" + name + "'");
            }
            return this.valueIterator.next();
        }
    }
}

