/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.Assert;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UriTemplate
implements Serializable {
    private static final Pattern NAMES_PATTERN = Pattern.compile("\\{([^/]+?)\\}");
    private static final String DEFAULT_VARIABLE_PATTERN = "(.*)";
    private final UriComponents uriComponents;
    private final List<String> variableNames;
    private final Pattern matchPattern;
    private final String uriTemplate;

    public UriTemplate(String uriTemplate) {
        Parser parser = new Parser(uriTemplate);
        this.uriTemplate = uriTemplate;
        this.variableNames = parser.getVariableNames();
        this.matchPattern = parser.getMatchPattern();
        this.uriComponents = UriComponentsBuilder.fromUriString(uriTemplate).build();
    }

    public List<String> getVariableNames() {
        return this.variableNames;
    }

    public URI expand(Map<String, ?> uriVariables) {
        UriComponents expandedComponents = this.uriComponents.expand(uriVariables);
        UriComponents encodedComponents = expandedComponents.encode();
        return encodedComponents.toUri();
    }

    public URI expand(Object ... uriVariableValues) {
        UriComponents expandedComponents = this.uriComponents.expand(uriVariableValues);
        UriComponents encodedComponents = expandedComponents.encode();
        return encodedComponents.toUri();
    }

    public boolean matches(String uri) {
        if (uri == null) {
            return false;
        }
        Matcher matcher2 = this.matchPattern.matcher(uri);
        return matcher2.matches();
    }

    public Map<String, String> match(String uri) {
        Assert.notNull(uri, "'uri' must not be null");
        LinkedHashMap<String, String> result2 = new LinkedHashMap<String, String>(this.variableNames.size());
        Matcher matcher2 = this.matchPattern.matcher(uri);
        if (matcher2.find()) {
            int i = 1;
            while (i <= matcher2.groupCount()) {
                String name = this.variableNames.get(i - 1);
                String value2 = matcher2.group(i);
                result2.put(name, value2);
                ++i;
            }
        }
        return result2;
    }

    @Deprecated
    protected URI encodeUri(String uri) {
        try {
            String encoded = UriUtils.encodeUri(uri, "UTF-8");
            return new URI(encoded);
        }
        catch (UnsupportedEncodingException ex2) {
            throw new IllegalStateException(ex2);
        }
        catch (URISyntaxException ex3) {
            throw new IllegalArgumentException("Could not create URI from [" + uri + "]: " + ex3, ex3);
        }
    }

    public String toString() {
        return this.uriTemplate;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Parser {
        private final List<String> variableNames = new LinkedList<String>();
        private final StringBuilder patternBuilder = new StringBuilder();

        private Parser(String uriTemplate) {
            Assert.hasText(uriTemplate, "'uriTemplate' must not be null");
            Matcher m = NAMES_PATTERN.matcher(uriTemplate);
            int end2 = 0;
            while (m.find()) {
                this.patternBuilder.append(this.quote(uriTemplate, end2, m.start()));
                String match = m.group(1);
                int colonIdx = match.indexOf(58);
                if (colonIdx == -1) {
                    this.patternBuilder.append(UriTemplate.DEFAULT_VARIABLE_PATTERN);
                    this.variableNames.add(match);
                } else {
                    if (colonIdx + 1 == match.length()) {
                        throw new IllegalArgumentException("No custom regular expression specified after ':' in \"" + match + "\"");
                    }
                    String variablePattern = match.substring(colonIdx + 1, match.length());
                    this.patternBuilder.append('(');
                    this.patternBuilder.append(variablePattern);
                    this.patternBuilder.append(')');
                    String variableName = match.substring(0, colonIdx);
                    this.variableNames.add(variableName);
                }
                end2 = m.end();
            }
            this.patternBuilder.append(this.quote(uriTemplate, end2, uriTemplate.length()));
            int lastIdx = this.patternBuilder.length() - 1;
            if (lastIdx >= 0 && this.patternBuilder.charAt(lastIdx) == '/') {
                this.patternBuilder.deleteCharAt(lastIdx);
            }
        }

        private String quote(String fullPath, int start2, int end2) {
            if (start2 == end2) {
                return "";
            }
            return Pattern.quote(fullPath.substring(start2, end2));
        }

        private List<String> getVariableNames() {
            return Collections.unmodifiableList(this.variableNames);
        }

        private Pattern getMatchPattern() {
            return Pattern.compile(this.patternBuilder.toString());
        }
    }
}

