/*
 * Decompiled with CFR 0.152.
 */
package org.squeryl.logging;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import org.squeryl.InternalFieldMapper$;
import org.squeryl.logging.BarChartRenderer;
import org.squeryl.logging.Measure$;
import org.squeryl.logging.StatLine;
import org.squeryl.logging.StatsSchema$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.Unparsed$;
import scala.xml.UnprefixedAttribute;

public final class BarChartRenderer$ {
    public static final BarChartRenderer$ MODULE$;
    private final String drawFunc;

    static {
        new BarChartRenderer$();
    }

    public void generateStatSummary(File staticHtmlFile, int n) {
        Elem page = this.page(Predef$.MODULE$.wrapRefArray((Object[])new BarChartRenderer.Stat[]{new BarChartRenderer.Stat(new StringBuilder().append((Object)"Top ").append(BoxesRunTime.boxToInteger(n)).append((Object)" statements with longest avg").toString(), "avg time", InternalFieldMapper$.MODULE$.queryToIterable(StatsSchema$.MODULE$.topRankingStatements(n, Measure$.MODULE$.AvgExecTime())), (Function1<StatLine, String>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(StatLine sl) {
                return ((Object)BoxesRunTime.boxToDouble(sl.avgExecTime())).toString();
            }
        })), new BarChartRenderer.Stat(new StringBuilder().append((Object)"Top ").append(BoxesRunTime.boxToInteger(n)).append((Object)" most called statements").toString(), "invocation count", InternalFieldMapper$.MODULE$.queryToIterable(StatsSchema$.MODULE$.topRankingStatements(n, Measure$.MODULE$.InvocationCount())), (Function1<StatLine, String>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(StatLine sl) {
                return ((Object)BoxesRunTime.boxToLong(sl.invocationCount())).toString();
            }
        })), new BarChartRenderer.Stat(new StringBuilder().append((Object)"Top ").append(BoxesRunTime.boxToInteger(n)).append((Object)" statements incurring most cummulative execution time").toString(), "cummulative execution time", InternalFieldMapper$.MODULE$.queryToIterable(StatsSchema$.MODULE$.topRankingStatements(n, Measure$.MODULE$.CumulativeExecutionTime())), (Function1<StatLine, String>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(StatLine sl) {
                return ((Object)BoxesRunTime.boxToLong(sl.cumulativeExecutionTime())).toString();
            }
        })), new BarChartRenderer.Stat(new StringBuilder().append((Object)"Top ").append(BoxesRunTime.boxToInteger(n)).append((Object)" statements with highest avg row count").toString(), "avg row count", InternalFieldMapper$.MODULE$.queryToIterable(StatsSchema$.MODULE$.topRankingStatements(n, Measure$.MODULE$.AvgResultSetSize())), (Function1<StatLine, String>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(StatLine sl) {
                return ((Object)BoxesRunTime.boxToFloat(sl.avgRowCount())).toString();
            }
        }))}));
        PrintStream ps = new PrintStream(new FileOutputStream(staticHtmlFile));
        ps.print(page);
        ps.close();
    }

    public String drawFunc() {
        return this.drawFunc;
    }

    public String funcCalls(Seq<BarChartRenderer.Stat> stats2) {
        StringBuffer sb = new StringBuffer();
        IntRef i = new IntRef(0);
        stats2.foreach(new Serializable(sb, i){
            public static final long serialVersionUID = 0L;
            private final StringBuffer sb$1;
            private final IntRef i$1;

            public final StringBuffer apply(BarChartRenderer.Stat s2) {
                ++this.i$1.elem;
                this.sb$1.append("drawBarGraph('chart");
                this.sb$1.append(this.i$1.elem);
                this.sb$1.append("','");
                this.sb$1.append(s2.title());
                this.sb$1.append("','");
                this.sb$1.append(s2.xAxisLabel());
                this.sb$1.append("',");
                this.sb$1.append(s2.queryLabelsJSArray());
                this.sb$1.append(",");
                this.sb$1.append(s2.measuresJSArray());
                return this.sb$1.append(");\n");
            }
            {
                this.sb$1 = sb$1;
                this.i$1 = i$1;
            }
        });
        return sb.toString();
    }

    public Elem page(Seq<BarChartRenderer.Stat> stats2) {
        NamespaceBinding $tmpscope = Predef$.MODULE$.$scope();
        NamespaceBinding $scope = $tmpscope = new NamespaceBinding(null, "http://www.w3.org/1999/xhtml", $tmpscope);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus(new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus(new Text("\n        "));
        MetaData $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("content", new Text("text/html; charset=utf-8"), $md);
        $md = new UnprefixedAttribute("http-equiv", new Text("content-type"), $md);
        $buf2.$amp$plus(new Elem(null, "meta", $md, $scope, true, Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf2.$amp$plus(new Text("\n        "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus(new Text("Performance profile of Squeryl queries"));
        $buf2.$amp$plus(new Elem(null, "title", Null$.MODULE$, $scope, false, $buf3));
        $buf2.$amp$plus(new Text("\n        "));
        MetaData $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("src", new Text("http://www.google.com/jsapi"), $md2);
        $md2 = new UnprefixedAttribute("type", new Text("text/javascript"), $md2);
        $buf2.$amp$plus(new Elem(null, "script", $md2, $scope, false, Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf2.$amp$plus(new Text("\n        "));
        MetaData $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("type", new Text("text/javascript"), $md3);
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus(new Text("\n          google.load('visualization', '1', {packages: ['corechart']});\n        "));
        $buf2.$amp$plus(new Elem(null, "script", $md3, $scope, false, $buf4));
        $buf2.$amp$plus(new Text("\n        "));
        MetaData $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("type", new Text("text/javascript"), $md4);
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus(new Text("\n\n          "));
        $buf5.$amp$plus(Unparsed$.MODULE$.apply(this.drawFunc()));
        $buf5.$amp$plus(new Text("\n\n          function drawVisualization() {\n            "));
        $buf5.$amp$plus(Unparsed$.MODULE$.apply(this.funcCalls(stats2)));
        $buf5.$amp$plus(new Text("\n          }\n\n          google.setOnLoadCallback(drawVisualization);\n        "));
        $buf2.$amp$plus(new Elem(null, "script", $md4, $scope, false, $buf5));
        $buf2.$amp$plus(new Text("\n      "));
        $buf.$amp$plus(new Elem(null, "head", Null$.MODULE$, $scope, false, $buf2));
        $buf.$amp$plus(new Text("\n      "));
        MetaData $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("style", new Text("font-family: Arial;border: 0 none;"), $md5);
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus(new Text("\n        "));
        MetaData $md6 = Null$.MODULE$;
        $md6 = new UnprefixedAttribute("style", new Text("width: 1000px; height: 400px;"), $md6);
        $md6 = new UnprefixedAttribute("id", new Text("chart1"), $md6);
        $buf6.$amp$plus(new Elem(null, "div", $md6, $scope, false, Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf6.$amp$plus(new Text("\n        "));
        MetaData $md7 = Null$.MODULE$;
        $md7 = new UnprefixedAttribute("style", new Text("width: 1000px; height: 400px;"), $md7);
        $md7 = new UnprefixedAttribute("id", new Text("chart2"), $md7);
        $buf6.$amp$plus(new Elem(null, "div", $md7, $scope, false, Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf6.$amp$plus(new Text("\n        "));
        MetaData $md8 = Null$.MODULE$;
        $md8 = new UnprefixedAttribute("style", new Text("width: 1000px; height: 400px;"), $md8);
        $md8 = new UnprefixedAttribute("id", new Text("chart3"), $md8);
        $buf6.$amp$plus(new Elem(null, "div", $md8, $scope, false, Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf6.$amp$plus(new Text("\n        "));
        MetaData $md9 = Null$.MODULE$;
        $md9 = new UnprefixedAttribute("style", new Text("width: 1000px; height: 400px;"), $md9);
        $md9 = new UnprefixedAttribute("id", new Text("chart4"), $md9);
        $buf6.$amp$plus(new Elem(null, "div", $md9, $scope, false, Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf6.$amp$plus(new Text("\n      "));
        $buf.$amp$plus(new Elem(null, "body", $md5, $scope, false, $buf6));
        $buf.$amp$plus(new Text("\n    "));
        return new Elem(null, "html", Null$.MODULE$, $scope, false, $buf);
    }

    private BarChartRenderer$() {
        MODULE$ = this;
        this.drawFunc = "\r\n    function drawBarGraph(divId, chartTitle, statType, queryClasses, measure) {\r\n              var data = new google.visualization.DataTable();\r\n\r\n              data.addColumn('string', 'Z');\r\n              data.addColumn('number', statType);\r\n\r\n              data.addRows(queryClasses.length);\r\n\r\n              for (var j = 0; j < queryClasses.length; ++j) {\r\n                data.setValue(j, 0, queryClasses[j].toString());\r\n                data.setValue(j, 1, measure[j]);\r\n              }\r\n\r\n              var v = new google.visualization.BarChart(document.getElementById(divId))\r\n\r\n              v.draw(data,\r\n                       {title: chartTitle,\r\n                        width:600, height:400,\r\n                        vAxis: {title: \"Queries\"},\r\n                        hAxis: {title: statType}\r\n                       }\r\n                  );\r\n    }\r\n  ";
    }
}

