/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.asm;

import scala.tools.asm.AnnotationVisitor;
import scala.tools.asm.AnnotationWriter;
import scala.tools.asm.Attribute;
import scala.tools.asm.ByteVector;
import scala.tools.asm.ClassWriter;
import scala.tools.asm.FieldVisitor;

final class FieldWriter
extends FieldVisitor {
    private final ClassWriter cw;
    private final int access;
    private final int name;
    private final int desc;
    private int signature;
    private int value;
    private AnnotationWriter anns;
    private AnnotationWriter ianns;
    private Attribute attrs;

    FieldWriter(ClassWriter classWriter, int n, String string2, String string3, String string4, Object object) {
        super(262144);
        if (classWriter.firstField == null) {
            classWriter.firstField = this;
        } else {
            classWriter.lastField.fv = this;
        }
        classWriter.lastField = this;
        this.cw = classWriter;
        this.access = n;
        this.name = classWriter.newUTF8(string2);
        this.desc = classWriter.newUTF8(string3);
        if (string4 != null) {
            this.signature = classWriter.newUTF8(string4);
        }
        if (object != null) {
            this.value = classWriter.newConstItem((Object)object).index;
        }
    }

    @Override
    public AnnotationVisitor visitAnnotation(String string2, boolean bl) {
        ByteVector byteVector = new ByteVector();
        byteVector.putShort(this.cw.newUTF8(string2)).putShort(0);
        AnnotationWriter annotationWriter = new AnnotationWriter(this.cw, true, byteVector, byteVector, 2);
        if (bl) {
            annotationWriter.next = this.anns;
            this.anns = annotationWriter;
        } else {
            annotationWriter.next = this.ianns;
            this.ianns = annotationWriter;
        }
        return annotationWriter;
    }

    @Override
    public void visitAttribute(Attribute attribute2) {
        attribute2.next = this.attrs;
        this.attrs = attribute2;
    }

    @Override
    public void visitEnd() {
    }

    int getSize() {
        int n = 8;
        if (this.value != 0) {
            this.cw.newUTF8("ConstantValue");
            n += 8;
        }
        if ((this.access & 0x1000) != 0 && ((this.cw.version & 0xFFFF) < 49 || (this.access & 0x40000) != 0)) {
            this.cw.newUTF8("Synthetic");
            n += 6;
        }
        if ((this.access & 0x20000) != 0) {
            this.cw.newUTF8("Deprecated");
            n += 6;
        }
        if (this.signature != 0) {
            this.cw.newUTF8("Signature");
            n += 8;
        }
        if (this.anns != null) {
            this.cw.newUTF8("RuntimeVisibleAnnotations");
            n += 8 + this.anns.getSize();
        }
        if (this.ianns != null) {
            this.cw.newUTF8("RuntimeInvisibleAnnotations");
            n += 8 + this.ianns.getSize();
        }
        if (this.attrs != null) {
            n += this.attrs.getSize(this.cw, null, 0, -1, -1);
        }
        return n;
    }

    void put(ByteVector byteVector) {
        int n = 0x60000 | (this.access & 0x40000) / 64;
        byteVector.putShort(this.access & ~n).putShort(this.name).putShort(this.desc);
        int n2 = 0;
        if (this.value != 0) {
            ++n2;
        }
        if ((this.access & 0x1000) != 0 && ((this.cw.version & 0xFFFF) < 49 || (this.access & 0x40000) != 0)) {
            ++n2;
        }
        if ((this.access & 0x20000) != 0) {
            ++n2;
        }
        if (this.signature != 0) {
            ++n2;
        }
        if (this.anns != null) {
            ++n2;
        }
        if (this.ianns != null) {
            ++n2;
        }
        if (this.attrs != null) {
            n2 += this.attrs.getCount();
        }
        byteVector.putShort(n2);
        if (this.value != 0) {
            byteVector.putShort(this.cw.newUTF8("ConstantValue"));
            byteVector.putInt(2).putShort(this.value);
        }
        if ((this.access & 0x1000) != 0 && ((this.cw.version & 0xFFFF) < 49 || (this.access & 0x40000) != 0)) {
            byteVector.putShort(this.cw.newUTF8("Synthetic")).putInt(0);
        }
        if ((this.access & 0x20000) != 0) {
            byteVector.putShort(this.cw.newUTF8("Deprecated")).putInt(0);
        }
        if (this.signature != 0) {
            byteVector.putShort(this.cw.newUTF8("Signature"));
            byteVector.putInt(2).putShort(this.signature);
        }
        if (this.anns != null) {
            byteVector.putShort(this.cw.newUTF8("RuntimeVisibleAnnotations"));
            this.anns.put(byteVector);
        }
        if (this.ianns != null) {
            byteVector.putShort(this.cw.newUTF8("RuntimeInvisibleAnnotations"));
            this.ianns.put(byteVector);
        }
        if (this.attrs != null) {
            this.attrs.put(this.cw, null, 0, -1, -1, byteVector);
        }
    }
}

