/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.asm.signature;

import scala.tools.asm.signature.SignatureVisitor;

public class SignatureWriter
extends SignatureVisitor {
    private final StringBuffer buf = new StringBuffer();
    private boolean hasFormals;
    private boolean hasParameters;
    private int argumentStack;

    public SignatureWriter() {
        super(262144);
    }

    @Override
    public void visitFormalTypeParameter(String string2) {
        if (!this.hasFormals) {
            this.hasFormals = true;
            this.buf.append('<');
        }
        this.buf.append(string2);
        this.buf.append(':');
    }

    @Override
    public SignatureVisitor visitClassBound() {
        return this;
    }

    @Override
    public SignatureVisitor visitInterfaceBound() {
        this.buf.append(':');
        return this;
    }

    @Override
    public SignatureVisitor visitSuperclass() {
        this.endFormals();
        return this;
    }

    @Override
    public SignatureVisitor visitInterface() {
        return this;
    }

    @Override
    public SignatureVisitor visitParameterType() {
        this.endFormals();
        if (!this.hasParameters) {
            this.hasParameters = true;
            this.buf.append('(');
        }
        return this;
    }

    @Override
    public SignatureVisitor visitReturnType() {
        this.endFormals();
        if (!this.hasParameters) {
            this.buf.append('(');
        }
        this.buf.append(')');
        return this;
    }

    @Override
    public SignatureVisitor visitExceptionType() {
        this.buf.append('^');
        return this;
    }

    @Override
    public void visitBaseType(char c2) {
        this.buf.append(c2);
    }

    @Override
    public void visitTypeVariable(String string2) {
        this.buf.append('T');
        this.buf.append(string2);
        this.buf.append(';');
    }

    @Override
    public SignatureVisitor visitArrayType() {
        this.buf.append('[');
        return this;
    }

    @Override
    public void visitClassType(String string2) {
        this.buf.append('L');
        this.buf.append(string2);
        this.argumentStack *= 2;
    }

    @Override
    public void visitInnerClassType(String string2) {
        this.endArguments();
        this.buf.append('.');
        this.buf.append(string2);
        this.argumentStack *= 2;
    }

    @Override
    public void visitTypeArgument() {
        if (this.argumentStack % 2 == 0) {
            ++this.argumentStack;
            this.buf.append('<');
        }
        this.buf.append('*');
    }

    @Override
    public SignatureVisitor visitTypeArgument(char c2) {
        if (this.argumentStack % 2 == 0) {
            ++this.argumentStack;
            this.buf.append('<');
        }
        if (c2 != '=') {
            this.buf.append(c2);
        }
        return this;
    }

    @Override
    public void visitEnd() {
        this.endArguments();
        this.buf.append(';');
    }

    public String toString() {
        return this.buf.toString();
    }

    private void endFormals() {
        if (this.hasFormals) {
            this.hasFormals = false;
            this.buf.append('>');
        }
    }

    private void endArguments() {
        if (this.argumentStack % 2 != 0) {
            this.buf.append('>');
        }
        this.argumentStack /= 2;
    }
}

