/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.asm.util;

import java.io.FileInputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import scala.tools.asm.AnnotationVisitor;
import scala.tools.asm.Attribute;
import scala.tools.asm.ClassReader;
import scala.tools.asm.ClassVisitor;
import scala.tools.asm.FieldVisitor;
import scala.tools.asm.Label;
import scala.tools.asm.MethodVisitor;
import scala.tools.asm.Type;
import scala.tools.asm.tree.ClassNode;
import scala.tools.asm.tree.MethodNode;
import scala.tools.asm.tree.analysis.Analyzer;
import scala.tools.asm.tree.analysis.BasicValue;
import scala.tools.asm.tree.analysis.Frame;
import scala.tools.asm.tree.analysis.SimpleVerifier;
import scala.tools.asm.util.CheckAnnotationAdapter;
import scala.tools.asm.util.CheckFieldAdapter;
import scala.tools.asm.util.CheckMethodAdapter;
import scala.tools.asm.util.Textifier;
import scala.tools.asm.util.TraceMethodVisitor;

public class CheckClassAdapter
extends ClassVisitor {
    private int version;
    private boolean start;
    private boolean source;
    private boolean outer;
    private boolean end;
    private Map<Label, Integer> labels = new HashMap<Label, Integer>();
    private boolean checkDataFlow;

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 1) {
            System.err.println("Verifies the given class.");
            System.err.println("Usage: CheckClassAdapter <fully qualified class name or class file name>");
            return;
        }
        ClassReader classReader = stringArray[0].endsWith(".class") ? new ClassReader(new FileInputStream(stringArray[0])) : new ClassReader(stringArray[0]);
        CheckClassAdapter.verify(classReader, false, new PrintWriter(System.err));
    }

    public static void verify(ClassReader classReader, ClassLoader classLoader, boolean bl, PrintWriter printWriter) {
        ClassNode classNode = new ClassNode();
        classReader.accept(new CheckClassAdapter(classNode, false), 2);
        Type type = classNode.superName == null ? null : Type.getObjectType(classNode.superName);
        List<MethodNode> list2 = classNode.methods;
        ArrayList<Type> arrayList = new ArrayList<Type>();
        Iterator<String> iterator2 = classNode.interfaces.iterator();
        while (iterator2.hasNext()) {
            arrayList.add(Type.getObjectType(iterator2.next().toString()));
        }
        for (int i = 0; i < list2.size(); ++i) {
            MethodNode methodNode = list2.get(i);
            SimpleVerifier simpleVerifier = new SimpleVerifier(Type.getObjectType(classNode.name), type, arrayList, (classNode.access & 0x200) != 0);
            Analyzer<BasicValue> analyzer = new Analyzer<BasicValue>(simpleVerifier);
            if (classLoader != null) {
                simpleVerifier.setClassLoader(classLoader);
            }
            try {
                analyzer.analyze(classNode.name, methodNode);
                if (!bl) {
                    continue;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(printWriter);
            }
            CheckClassAdapter.printAnalyzerResult(methodNode, analyzer, printWriter);
        }
        printWriter.flush();
    }

    public static void verify(ClassReader classReader, boolean bl, PrintWriter printWriter) {
        CheckClassAdapter.verify(classReader, null, bl, printWriter);
    }

    static void printAnalyzerResult(MethodNode methodNode, Analyzer<BasicValue> analyzer, PrintWriter printWriter) {
        int n;
        Frame<BasicValue>[] frameArray = analyzer.getFrames();
        Textifier textifier = new Textifier();
        TraceMethodVisitor traceMethodVisitor = new TraceMethodVisitor(textifier);
        printWriter.println(methodNode.name + methodNode.desc);
        for (n = 0; n < methodNode.instructions.size(); ++n) {
            methodNode.instructions.get(n).accept(traceMethodVisitor);
            StringBuffer stringBuffer = new StringBuffer();
            Frame<BasicValue> frame = frameArray[n];
            if (frame == null) {
                stringBuffer.append('?');
            } else {
                int n2;
                for (n2 = 0; n2 < frame.getLocals(); ++n2) {
                    stringBuffer.append(CheckClassAdapter.getShortName(frame.getLocal(n2).toString())).append(' ');
                }
                stringBuffer.append(" : ");
                for (n2 = 0; n2 < frame.getStackSize(); ++n2) {
                    stringBuffer.append(CheckClassAdapter.getShortName(frame.getStack(n2).toString())).append(' ');
                }
            }
            while (stringBuffer.length() < methodNode.maxStack + methodNode.maxLocals + 1) {
                stringBuffer.append(' ');
            }
            printWriter.print(Integer.toString(n + 100000).substring(1));
            printWriter.print(" " + stringBuffer + " : " + textifier.text.get(textifier.text.size() - 1));
        }
        for (n = 0; n < methodNode.tryCatchBlocks.size(); ++n) {
            methodNode.tryCatchBlocks.get(n).accept(traceMethodVisitor);
            printWriter.print(" " + textifier.text.get(textifier.text.size() - 1));
        }
        printWriter.println();
    }

    private static String getShortName(String string2) {
        int n = string2.lastIndexOf(47);
        int n2 = string2.length();
        if (string2.charAt(n2 - 1) == ';') {
            --n2;
        }
        return n == -1 ? string2 : string2.substring(n + 1, n2);
    }

    public CheckClassAdapter(ClassVisitor classVisitor) {
        this(classVisitor, true);
    }

    public CheckClassAdapter(ClassVisitor classVisitor, boolean bl) {
        this(262144, classVisitor, bl);
    }

    protected CheckClassAdapter(int n, ClassVisitor classVisitor, boolean bl) {
        super(n, classVisitor);
        this.checkDataFlow = bl;
    }

    @Override
    public void visit(int n, int n2, String string2, String string3, String string4, String[] stringArray) {
        if (this.start) {
            throw new IllegalStateException("visit must be called only once");
        }
        this.start = true;
        this.checkState();
        CheckClassAdapter.checkAccess(n2, 423473);
        if (string2 == null || !string2.endsWith("package-info")) {
            CheckMethodAdapter.checkInternalName(string2, "class name");
        }
        if ("java/lang/Object".equals(string2)) {
            if (string4 != null) {
                throw new IllegalArgumentException("The super class name of the Object class must be 'null'");
            }
        } else {
            CheckMethodAdapter.checkInternalName(string4, "super class name");
        }
        if (string3 != null) {
            CheckMethodAdapter.checkClassSignature(string3);
        }
        if ((n2 & 0x200) != 0 && !"java/lang/Object".equals(string4)) {
            throw new IllegalArgumentException("The super class name of interfaces must be 'java/lang/Object'");
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                CheckMethodAdapter.checkInternalName(stringArray[i], "interface name at index " + i);
            }
        }
        this.version = n;
        super.visit(n, n2, string2, string3, string4, stringArray);
    }

    @Override
    public void visitSource(String string2, String string3) {
        this.checkState();
        if (this.source) {
            throw new IllegalStateException("visitSource can be called only once.");
        }
        this.source = true;
        super.visitSource(string2, string3);
    }

    @Override
    public void visitOuterClass(String string2, String string3, String string4) {
        this.checkState();
        if (this.outer) {
            throw new IllegalStateException("visitOuterClass can be called only once.");
        }
        this.outer = true;
        if (string2 == null) {
            throw new IllegalArgumentException("Illegal outer class owner");
        }
        if (string4 != null) {
            CheckMethodAdapter.checkMethodDesc(string4);
        }
        super.visitOuterClass(string2, string3, string4);
    }

    @Override
    public void visitInnerClass(String string2, String string3, String string4, int n) {
        this.checkState();
        CheckMethodAdapter.checkInternalName(string2, "class name");
        if (string3 != null) {
            CheckMethodAdapter.checkInternalName(string3, "outer class name");
        }
        if (string4 != null) {
            CheckMethodAdapter.checkIdentifier(string4, "inner class name");
        }
        CheckClassAdapter.checkAccess(n, 30239);
        super.visitInnerClass(string2, string3, string4, n);
    }

    @Override
    public FieldVisitor visitField(int n, String string2, String string3, String string4, Object object) {
        this.checkState();
        CheckClassAdapter.checkAccess(n, 413919);
        CheckMethodAdapter.checkUnqualifiedName(this.version, string2, "field name");
        CheckMethodAdapter.checkDesc(string3, false);
        if (string4 != null) {
            CheckMethodAdapter.checkFieldSignature(string4);
        }
        if (object != null) {
            CheckMethodAdapter.checkConstant(object);
        }
        FieldVisitor fieldVisitor = super.visitField(n, string2, string3, string4, object);
        return new CheckFieldAdapter(fieldVisitor);
    }

    @Override
    public MethodVisitor visitMethod(int n, String string2, String string3, String string4, String[] stringArray) {
        this.checkState();
        CheckClassAdapter.checkAccess(n, 400895);
        CheckMethodAdapter.checkMethodIdentifier(this.version, string2, "method name");
        CheckMethodAdapter.checkMethodDesc(string3);
        if (string4 != null) {
            CheckMethodAdapter.checkMethodSignature(string4);
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                CheckMethodAdapter.checkInternalName(stringArray[i], "exception name at index " + i);
            }
        }
        CheckMethodAdapter checkMethodAdapter = this.checkDataFlow ? new CheckMethodAdapter(n, string2, string3, super.visitMethod(n, string2, string3, string4, stringArray), this.labels) : new CheckMethodAdapter(super.visitMethod(n, string2, string3, string4, stringArray), this.labels);
        checkMethodAdapter.version = this.version;
        return checkMethodAdapter;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String string2, boolean bl) {
        this.checkState();
        CheckMethodAdapter.checkDesc(string2, false);
        return new CheckAnnotationAdapter(super.visitAnnotation(string2, bl));
    }

    @Override
    public void visitAttribute(Attribute attribute2) {
        this.checkState();
        if (attribute2 == null) {
            throw new IllegalArgumentException("Invalid attribute (must not be null)");
        }
        super.visitAttribute(attribute2);
    }

    @Override
    public void visitEnd() {
        this.checkState();
        this.end = true;
        super.visitEnd();
    }

    private void checkState() {
        if (!this.start) {
            throw new IllegalStateException("Cannot visit member before visit has been called.");
        }
        if (this.end) {
            throw new IllegalStateException("Cannot visit member after visitEnd has been called.");
        }
    }

    static void checkAccess(int n, int n2) {
        int n3;
        int n4;
        if ((n & ~n2) != 0) {
            throw new IllegalArgumentException("Invalid access flags: " + n);
        }
        int n5 = (n & 1) == 0 ? 0 : 1;
        int n6 = (n & 2) == 0 ? 0 : 1;
        int n7 = n4 = (n & 4) == 0 ? 0 : 1;
        if (n5 + n6 + n4 > 1) {
            throw new IllegalArgumentException("public private and protected are mutually exclusive: " + n);
        }
        int n8 = (n & 0x10) == 0 ? 0 : 1;
        int n9 = n3 = (n & 0x400) == 0 ? 0 : 1;
        if (n8 + n3 > 1) {
            throw new IllegalArgumentException("final and abstract are mutually exclusive: " + n);
        }
    }
}

