/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.asm.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import scala.tools.asm.AnnotationVisitor;
import scala.tools.asm.Attribute;
import scala.tools.asm.Handle;
import scala.tools.asm.Label;
import scala.tools.asm.MethodVisitor;
import scala.tools.asm.Opcodes;
import scala.tools.asm.Type;
import scala.tools.asm.tree.MethodNode;
import scala.tools.asm.tree.analysis.Analyzer;
import scala.tools.asm.tree.analysis.BasicValue;
import scala.tools.asm.tree.analysis.BasicVerifier;
import scala.tools.asm.util.CheckAnnotationAdapter;
import scala.tools.asm.util.CheckClassAdapter;

public class CheckMethodAdapter
extends MethodVisitor {
    public int version;
    private boolean startCode;
    private boolean endCode;
    private boolean endMethod;
    private int insnCount;
    private final Map<Label, Integer> labels;
    private Set<Label> usedLabels;
    private List<Label> handlers;
    private static final int[] TYPE;
    private static Field labelStatusField;

    public CheckMethodAdapter(MethodVisitor methodVisitor) {
        this(methodVisitor, new HashMap<Label, Integer>());
    }

    public CheckMethodAdapter(MethodVisitor methodVisitor, Map<Label, Integer> map3) {
        this(262144, methodVisitor, map3);
    }

    protected CheckMethodAdapter(int n, MethodVisitor methodVisitor, Map<Label, Integer> map3) {
        super(n, methodVisitor);
        this.labels = map3;
        this.usedLabels = new HashSet<Label>();
        this.handlers = new ArrayList<Label>();
    }

    public CheckMethodAdapter(int n, String string2, String string3, final MethodVisitor methodVisitor, Map<Label, Integer> map3) {
        this(new MethodNode(n, string2, string3, null, null){

            @Override
            public void visitEnd() {
                Analyzer<BasicValue> analyzer = new Analyzer<BasicValue>(new BasicVerifier());
                try {
                    analyzer.analyze("dummy", this);
                }
                catch (Exception exception) {
                    if (exception instanceof IndexOutOfBoundsException && this.maxLocals == 0 && this.maxStack == 0) {
                        throw new RuntimeException("Data flow checking option requires valid, non zero maxLocals and maxStack values.");
                    }
                    exception.printStackTrace();
                    StringWriter stringWriter = new StringWriter();
                    PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
                    CheckClassAdapter.printAnalyzerResult(this, analyzer, printWriter);
                    printWriter.close();
                    throw new RuntimeException(exception.getMessage() + ' ' + stringWriter.toString());
                }
                this.accept(methodVisitor);
            }
        }, map3);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String string2, boolean bl) {
        this.checkEndMethod();
        CheckMethodAdapter.checkDesc(string2, false);
        return new CheckAnnotationAdapter(super.visitAnnotation(string2, bl));
    }

    @Override
    public AnnotationVisitor visitAnnotationDefault() {
        this.checkEndMethod();
        return new CheckAnnotationAdapter(super.visitAnnotationDefault(), false);
    }

    @Override
    public AnnotationVisitor visitParameterAnnotation(int n, String string2, boolean bl) {
        this.checkEndMethod();
        CheckMethodAdapter.checkDesc(string2, false);
        return new CheckAnnotationAdapter(super.visitParameterAnnotation(n, string2, bl));
    }

    @Override
    public void visitAttribute(Attribute attribute2) {
        this.checkEndMethod();
        if (attribute2 == null) {
            throw new IllegalArgumentException("Invalid attribute (must not be null)");
        }
        super.visitAttribute(attribute2);
    }

    @Override
    public void visitCode() {
        this.startCode = true;
        super.visitCode();
    }

    @Override
    public void visitFrame(int n, int n2, Object[] objectArray, int n3, Object[] objectArray2) {
        int n4;
        int n5;
        int n6;
        switch (n) {
            case -1: 
            case 0: {
                n6 = Integer.MAX_VALUE;
                n5 = Integer.MAX_VALUE;
                break;
            }
            case 3: {
                n6 = 0;
                n5 = 0;
                break;
            }
            case 4: {
                n6 = 0;
                n5 = 1;
                break;
            }
            case 1: 
            case 2: {
                n6 = 3;
                n5 = 0;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid frame type " + n);
            }
        }
        if (n2 > n6) {
            throw new IllegalArgumentException("Invalid nLocal=" + n2 + " for frame type " + n);
        }
        if (n3 > n5) {
            throw new IllegalArgumentException("Invalid nStack=" + n3 + " for frame type " + n);
        }
        if (n != 2) {
            if (n2 > 0 && (objectArray == null || objectArray.length < n2)) {
                throw new IllegalArgumentException("Array local[] is shorter than nLocal");
            }
            for (n4 = 0; n4 < n2; ++n4) {
                this.checkFrameValue(objectArray[n4]);
            }
        }
        if (n3 > 0 && (objectArray2 == null || objectArray2.length < n3)) {
            throw new IllegalArgumentException("Array stack[] is shorter than nStack");
        }
        for (n4 = 0; n4 < n3; ++n4) {
            this.checkFrameValue(objectArray2[n4]);
        }
        super.visitFrame(n, n2, objectArray, n3, objectArray2);
    }

    @Override
    public void visitInsn(int n) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkOpcode(n, 0);
        super.visitInsn(n);
        ++this.insnCount;
    }

    @Override
    public void visitIntInsn(int n, int n2) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkOpcode(n, 1);
        switch (n) {
            case 16: {
                CheckMethodAdapter.checkSignedByte(n2, "Invalid operand");
                break;
            }
            case 17: {
                CheckMethodAdapter.checkSignedShort(n2, "Invalid operand");
                break;
            }
            default: {
                if (n2 >= 4 && n2 <= 11) break;
                throw new IllegalArgumentException("Invalid operand (must be an array type code T_...): " + n2);
            }
        }
        super.visitIntInsn(n, n2);
        ++this.insnCount;
    }

    @Override
    public void visitVarInsn(int n, int n2) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkOpcode(n, 2);
        CheckMethodAdapter.checkUnsignedShort(n2, "Invalid variable index");
        super.visitVarInsn(n, n2);
        ++this.insnCount;
    }

    @Override
    public void visitTypeInsn(int n, String string2) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkOpcode(n, 3);
        CheckMethodAdapter.checkInternalName(string2, "type");
        if (n == 187 && string2.charAt(0) == '[') {
            throw new IllegalArgumentException("NEW cannot be used to create arrays: " + string2);
        }
        super.visitTypeInsn(n, string2);
        ++this.insnCount;
    }

    @Override
    public void visitFieldInsn(int n, String string2, String string3, String string4) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkOpcode(n, 4);
        CheckMethodAdapter.checkInternalName(string2, "owner");
        CheckMethodAdapter.checkUnqualifiedName(this.version, string3, "name");
        CheckMethodAdapter.checkDesc(string4, false);
        super.visitFieldInsn(n, string2, string3, string4);
        ++this.insnCount;
    }

    @Override
    public void visitMethodInsn(int n, String string2, String string3, String string4) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkOpcode(n, 5);
        CheckMethodAdapter.checkMethodIdentifier(this.version, string3, "name");
        CheckMethodAdapter.checkInternalName(string2, "owner");
        CheckMethodAdapter.checkMethodDesc(string4);
        super.visitMethodInsn(n, string2, string3, string4);
        ++this.insnCount;
    }

    @Override
    public void visitInvokeDynamicInsn(String string2, String string3, Handle handle, Object ... objectArray) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkMethodIdentifier(this.version, string2, "name");
        CheckMethodAdapter.checkMethodDesc(string3);
        if (handle.getTag() != 6 && handle.getTag() != 8) {
            throw new IllegalArgumentException("invalid handle tag " + handle.getTag());
        }
        for (int i = 0; i < objectArray.length; ++i) {
            this.checkLDCConstant(objectArray[i]);
        }
        super.visitInvokeDynamicInsn(string2, string3, handle, objectArray);
        ++this.insnCount;
    }

    @Override
    public void visitJumpInsn(int n, Label label) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkOpcode(n, 6);
        this.checkLabel(label, false, "label");
        CheckMethodAdapter.checkNonDebugLabel(label);
        super.visitJumpInsn(n, label);
        this.usedLabels.add(label);
        ++this.insnCount;
    }

    @Override
    public void visitLabel(Label label) {
        this.checkStartCode();
        this.checkEndCode();
        this.checkLabel(label, false, "label");
        if (this.labels.get(label) != null) {
            throw new IllegalArgumentException("Already visited label");
        }
        this.labels.put(label, new Integer(this.insnCount));
        super.visitLabel(label);
    }

    @Override
    public void visitLdcInsn(Object object) {
        this.checkStartCode();
        this.checkEndCode();
        this.checkLDCConstant(object);
        super.visitLdcInsn(object);
        ++this.insnCount;
    }

    @Override
    public void visitIincInsn(int n, int n2) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkUnsignedShort(n, "Invalid variable index");
        CheckMethodAdapter.checkSignedShort(n2, "Invalid increment");
        super.visitIincInsn(n, n2);
        ++this.insnCount;
    }

    @Override
    public void visitTableSwitchInsn(int n, int n2, Label label, Label ... labelArray) {
        int n3;
        this.checkStartCode();
        this.checkEndCode();
        if (n2 < n) {
            throw new IllegalArgumentException("Max = " + n2 + " must be greater than or equal to min = " + n);
        }
        this.checkLabel(label, false, "default label");
        CheckMethodAdapter.checkNonDebugLabel(label);
        if (labelArray == null || labelArray.length != n2 - n + 1) {
            throw new IllegalArgumentException("There must be max - min + 1 labels");
        }
        for (n3 = 0; n3 < labelArray.length; ++n3) {
            this.checkLabel(labelArray[n3], false, "label at index " + n3);
            CheckMethodAdapter.checkNonDebugLabel(labelArray[n3]);
        }
        super.visitTableSwitchInsn(n, n2, label, labelArray);
        for (n3 = 0; n3 < labelArray.length; ++n3) {
            this.usedLabels.add(labelArray[n3]);
        }
        ++this.insnCount;
    }

    @Override
    public void visitLookupSwitchInsn(Label label, int[] nArray, Label[] labelArray) {
        int n;
        this.checkEndCode();
        this.checkStartCode();
        this.checkLabel(label, false, "default label");
        CheckMethodAdapter.checkNonDebugLabel(label);
        if (nArray == null || labelArray == null || nArray.length != labelArray.length) {
            throw new IllegalArgumentException("There must be the same number of keys and labels");
        }
        for (n = 0; n < labelArray.length; ++n) {
            this.checkLabel(labelArray[n], false, "label at index " + n);
            CheckMethodAdapter.checkNonDebugLabel(labelArray[n]);
        }
        super.visitLookupSwitchInsn(label, nArray, labelArray);
        this.usedLabels.add(label);
        for (n = 0; n < labelArray.length; ++n) {
            this.usedLabels.add(labelArray[n]);
        }
        ++this.insnCount;
    }

    @Override
    public void visitMultiANewArrayInsn(String string2, int n) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkDesc(string2, false);
        if (string2.charAt(0) != '[') {
            throw new IllegalArgumentException("Invalid descriptor (must be an array type descriptor): " + string2);
        }
        if (n < 1) {
            throw new IllegalArgumentException("Invalid dimensions (must be greater than 0): " + n);
        }
        if (n > string2.lastIndexOf(91) + 1) {
            throw new IllegalArgumentException("Invalid dimensions (must not be greater than dims(desc)): " + n);
        }
        super.visitMultiANewArrayInsn(string2, n);
        ++this.insnCount;
    }

    @Override
    public void visitTryCatchBlock(Label label, Label label2, Label label3, String string2) {
        this.checkStartCode();
        this.checkEndCode();
        this.checkLabel(label, false, "start label");
        this.checkLabel(label2, false, "end label");
        this.checkLabel(label3, false, "handler label");
        CheckMethodAdapter.checkNonDebugLabel(label);
        CheckMethodAdapter.checkNonDebugLabel(label2);
        CheckMethodAdapter.checkNonDebugLabel(label3);
        if (this.labels.get(label) != null || this.labels.get(label2) != null || this.labels.get(label3) != null) {
            throw new IllegalStateException("Try catch blocks must be visited before their labels");
        }
        if (string2 != null) {
            CheckMethodAdapter.checkInternalName(string2, "type");
        }
        super.visitTryCatchBlock(label, label2, label3, string2);
        this.handlers.add(label);
        this.handlers.add(label2);
    }

    @Override
    public void visitLocalVariable(String string2, String string3, String string4, Label label, Label label2, int n) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkUnqualifiedName(this.version, string2, "name");
        CheckMethodAdapter.checkDesc(string3, false);
        this.checkLabel(label, true, "start label");
        this.checkLabel(label2, true, "end label");
        CheckMethodAdapter.checkUnsignedShort(n, "Invalid variable index");
        int n2 = this.labels.get(label);
        int n3 = this.labels.get(label2);
        if (n3 < n2) {
            throw new IllegalArgumentException("Invalid start and end labels (end must be greater than start)");
        }
        super.visitLocalVariable(string2, string3, string4, label, label2, n);
    }

    @Override
    public void visitLineNumber(int n, Label label) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkUnsignedShort(n, "Invalid line number");
        this.checkLabel(label, true, "start label");
        super.visitLineNumber(n, label);
    }

    @Override
    public void visitMaxs(int n, int n2) {
        this.checkStartCode();
        this.checkEndCode();
        this.endCode = true;
        for (Label object : this.usedLabels) {
            if (this.labels.get(object) != null) continue;
            throw new IllegalStateException("Undefined label used");
        }
        int n3 = 0;
        while (n3 < this.handlers.size()) {
            Integer n4 = this.labels.get(this.handlers.get(n3++));
            Integer n5 = this.labels.get(this.handlers.get(n3++));
            if (n4 == null || n5 == null) {
                throw new IllegalStateException("Undefined try catch block labels");
            }
            if (n5 > n4) continue;
            throw new IllegalStateException("Emty try catch block handler range");
        }
        CheckMethodAdapter.checkUnsignedShort(n, "Invalid max stack");
        CheckMethodAdapter.checkUnsignedShort(n2, "Invalid max locals");
        super.visitMaxs(n, n2);
    }

    @Override
    public void visitEnd() {
        this.checkEndMethod();
        this.endMethod = true;
        super.visitEnd();
    }

    void checkStartCode() {
        if (!this.startCode) {
            throw new IllegalStateException("Cannot visit instructions before visitCode has been called.");
        }
    }

    void checkEndCode() {
        if (this.endCode) {
            throw new IllegalStateException("Cannot visit instructions after visitMaxs has been called.");
        }
    }

    void checkEndMethod() {
        if (this.endMethod) {
            throw new IllegalStateException("Cannot visit elements after visitEnd has been called.");
        }
    }

    void checkFrameValue(Object object) {
        if (object == Opcodes.TOP || object == Opcodes.INTEGER || object == Opcodes.FLOAT || object == Opcodes.LONG || object == Opcodes.DOUBLE || object == Opcodes.NULL || object == Opcodes.UNINITIALIZED_THIS) {
            return;
        }
        if (object instanceof String) {
            CheckMethodAdapter.checkInternalName((String)object, "Invalid stack frame value");
            return;
        }
        if (!(object instanceof Label)) {
            throw new IllegalArgumentException("Invalid stack frame value: " + object);
        }
        this.usedLabels.add((Label)object);
    }

    static void checkOpcode(int n, int n2) {
        if (n < 0 || n > 199 || TYPE[n] != n2) {
            throw new IllegalArgumentException("Invalid opcode: " + n);
        }
    }

    static void checkSignedByte(int n, String string2) {
        if (n < -128 || n > 127) {
            throw new IllegalArgumentException(string2 + " (must be a signed byte): " + n);
        }
    }

    static void checkSignedShort(int n, String string2) {
        if (n < Short.MIN_VALUE || n > Short.MAX_VALUE) {
            throw new IllegalArgumentException(string2 + " (must be a signed short): " + n);
        }
    }

    static void checkUnsignedShort(int n, String string2) {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException(string2 + " (must be an unsigned short): " + n);
        }
    }

    static void checkConstant(Object object) {
        if (!(object instanceof Integer || object instanceof Float || object instanceof Long || object instanceof Double || object instanceof String)) {
            throw new IllegalArgumentException("Invalid constant: " + object);
        }
    }

    void checkLDCConstant(Object object) {
        if (object instanceof Type) {
            int n = ((Type)object).getSort();
            if (n != 10 && n != 9 && n != 11) {
                throw new IllegalArgumentException("Illegal LDC constant value");
            }
            if (n != 11 && (this.version & 0xFFFF) < 49) {
                throw new IllegalArgumentException("ldc of a constant class requires at least version 1.5");
            }
            if (n == 11 && (this.version & 0xFFFF) < 51) {
                throw new IllegalArgumentException("ldc of a method type requires at least version 1.7");
            }
        } else if (object instanceof Handle) {
            if ((this.version & 0xFFFF) < 51) {
                throw new IllegalArgumentException("ldc of a handle requires at least version 1.7");
            }
            int n = ((Handle)object).getTag();
            if (n < 1 || n > 9) {
                throw new IllegalArgumentException("invalid handle tag " + n);
            }
        } else {
            CheckMethodAdapter.checkConstant(object);
        }
    }

    static void checkUnqualifiedName(int n, String string2, String string3) {
        if ((n & 0xFFFF) < 49) {
            CheckMethodAdapter.checkIdentifier(string2, string3);
        } else {
            for (int i = 0; i < string2.length(); ++i) {
                if (".;[/".indexOf(string2.charAt(i)) == -1) continue;
                throw new IllegalArgumentException("Invalid " + string3 + " (must be a valid unqualified name): " + string2);
            }
        }
    }

    static void checkIdentifier(String string2, String string3) {
        CheckMethodAdapter.checkIdentifier(string2, 0, -1, string3);
    }

    static void checkIdentifier(String string2, int n, int n2, String string3) {
        if (string2 == null || (n2 == -1 ? string2.length() <= n : n2 <= n)) {
            throw new IllegalArgumentException("Invalid " + string3 + " (must not be null or empty)");
        }
        if (!Character.isJavaIdentifierStart(string2.charAt(n))) {
            throw new IllegalArgumentException("Invalid " + string3 + " (must be a valid Java identifier): " + string2);
        }
        int n3 = n2 == -1 ? string2.length() : n2;
        for (int i = n + 1; i < n3; ++i) {
            if (Character.isJavaIdentifierPart(string2.charAt(i))) continue;
            throw new IllegalArgumentException("Invalid " + string3 + " (must be a valid Java identifier): " + string2);
        }
    }

    static void checkMethodIdentifier(int n, String string2, String string3) {
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("Invalid " + string3 + " (must not be null or empty)");
        }
        if ("<init>".equals(string2) || "<clinit>".equals(string2)) {
            return;
        }
        if ((n & 0xFFFF) >= 49) {
            for (int i = 0; i < string2.length(); ++i) {
                if (".;[/<>".indexOf(string2.charAt(i)) == -1) continue;
                throw new IllegalArgumentException("Invalid " + string3 + " (must be a valid unqualified name): " + string2);
            }
            return;
        }
        if (!Character.isJavaIdentifierStart(string2.charAt(0))) {
            throw new IllegalArgumentException("Invalid " + string3 + " (must be a '<init>', '<clinit>' or a valid Java identifier): " + string2);
        }
        for (int i = 1; i < string2.length(); ++i) {
            if (Character.isJavaIdentifierPart(string2.charAt(i))) continue;
            throw new IllegalArgumentException("Invalid " + string3 + " (must be '<init>' or '<clinit>' or a valid Java identifier): " + string2);
        }
    }

    static void checkInternalName(String string2, String string3) {
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("Invalid " + string3 + " (must not be null or empty)");
        }
        if (string2.charAt(0) == '[') {
            CheckMethodAdapter.checkDesc(string2, false);
        } else {
            CheckMethodAdapter.checkInternalName(string2, 0, -1, string3);
        }
    }

    static void checkInternalName(String string2, int n, int n2, String string3) {
        int n3 = n2 == -1 ? string2.length() : n2;
        try {
            int n4;
            int n5 = n;
            do {
                if ((n4 = string2.indexOf(47, n5 + 1)) == -1 || n4 > n3) {
                    n4 = n3;
                }
                CheckMethodAdapter.checkIdentifier(string2, n5, n4, null);
                n5 = n4 + 1;
            } while (n4 != n3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Invalid " + string3 + " (must be a fully qualified class name in internal form): " + string2);
        }
    }

    static void checkDesc(String string2, boolean bl) {
        int n = CheckMethodAdapter.checkDesc(string2, 0, bl);
        if (n != string2.length()) {
            throw new IllegalArgumentException("Invalid descriptor: " + string2);
        }
    }

    static int checkDesc(String string2, int n, boolean bl) {
        if (string2 == null || n >= string2.length()) {
            throw new IllegalArgumentException("Invalid type descriptor (must not be null or empty)");
        }
        switch (string2.charAt(n)) {
            case 'V': {
                if (bl) {
                    return n + 1;
                }
                throw new IllegalArgumentException("Invalid descriptor: " + string2);
            }
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                return n + 1;
            }
            case '[': {
                int n2;
                for (n2 = n + 1; n2 < string2.length() && string2.charAt(n2) == '['; ++n2) {
                }
                if (n2 < string2.length()) {
                    return CheckMethodAdapter.checkDesc(string2, n2, false);
                }
                throw new IllegalArgumentException("Invalid descriptor: " + string2);
            }
            case 'L': {
                int n3 = string2.indexOf(59, n);
                if (n3 == -1 || n3 - n < 2) {
                    throw new IllegalArgumentException("Invalid descriptor: " + string2);
                }
                try {
                    CheckMethodAdapter.checkInternalName(string2, n + 1, n3, null);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new IllegalArgumentException("Invalid descriptor: " + string2);
                }
                return n3 + 1;
            }
        }
        throw new IllegalArgumentException("Invalid descriptor: " + string2);
    }

    static void checkMethodDesc(String string2) {
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("Invalid method descriptor (must not be null or empty)");
        }
        if (string2.charAt(0) != '(' || string2.length() < 3) {
            throw new IllegalArgumentException("Invalid descriptor: " + string2);
        }
        int n = 1;
        if (string2.charAt(n) != ')') {
            do {
                if (string2.charAt(n) != 'V') continue;
                throw new IllegalArgumentException("Invalid descriptor: " + string2);
            } while ((n = CheckMethodAdapter.checkDesc(string2, n, false)) < string2.length() && string2.charAt(n) != ')');
        }
        if ((n = CheckMethodAdapter.checkDesc(string2, n + 1, true)) != string2.length()) {
            throw new IllegalArgumentException("Invalid descriptor: " + string2);
        }
    }

    static void checkClassSignature(String string2) {
        int n = 0;
        if (CheckMethodAdapter.getChar(string2, 0) == '<') {
            n = CheckMethodAdapter.checkFormalTypeParameters(string2, n);
        }
        n = CheckMethodAdapter.checkClassTypeSignature(string2, n);
        while (CheckMethodAdapter.getChar(string2, n) == 'L') {
            n = CheckMethodAdapter.checkClassTypeSignature(string2, n);
        }
        if (n != string2.length()) {
            throw new IllegalArgumentException(string2 + ": error at index " + n);
        }
    }

    static void checkMethodSignature(String string2) {
        int n = 0;
        if (CheckMethodAdapter.getChar(string2, 0) == '<') {
            n = CheckMethodAdapter.checkFormalTypeParameters(string2, n);
        }
        n = CheckMethodAdapter.checkChar('(', string2, n);
        while ("ZCBSIFJDL[T".indexOf(CheckMethodAdapter.getChar(string2, n)) != -1) {
            n = CheckMethodAdapter.checkTypeSignature(string2, n);
        }
        n = CheckMethodAdapter.getChar(string2, n = CheckMethodAdapter.checkChar(')', string2, n)) == 'V' ? ++n : CheckMethodAdapter.checkTypeSignature(string2, n);
        while (CheckMethodAdapter.getChar(string2, n) == '^') {
            if (CheckMethodAdapter.getChar(string2, ++n) == 'L') {
                n = CheckMethodAdapter.checkClassTypeSignature(string2, n);
                continue;
            }
            n = CheckMethodAdapter.checkTypeVariableSignature(string2, n);
        }
        if (n != string2.length()) {
            throw new IllegalArgumentException(string2 + ": error at index " + n);
        }
    }

    static void checkFieldSignature(String string2) {
        int n = CheckMethodAdapter.checkFieldTypeSignature(string2, 0);
        if (n != string2.length()) {
            throw new IllegalArgumentException(string2 + ": error at index " + n);
        }
    }

    private static int checkFormalTypeParameters(String string2, int n) {
        n = CheckMethodAdapter.checkChar('<', string2, n);
        n = CheckMethodAdapter.checkFormalTypeParameter(string2, n);
        while (CheckMethodAdapter.getChar(string2, n) != '>') {
            n = CheckMethodAdapter.checkFormalTypeParameter(string2, n);
        }
        return n + 1;
    }

    private static int checkFormalTypeParameter(String string2, int n) {
        n = CheckMethodAdapter.checkIdentifier(string2, n);
        if ("L[T".indexOf(CheckMethodAdapter.getChar(string2, n = CheckMethodAdapter.checkChar(':', string2, n))) != -1) {
            n = CheckMethodAdapter.checkFieldTypeSignature(string2, n);
        }
        while (CheckMethodAdapter.getChar(string2, n) == ':') {
            n = CheckMethodAdapter.checkFieldTypeSignature(string2, n + 1);
        }
        return n;
    }

    private static int checkFieldTypeSignature(String string2, int n) {
        switch (CheckMethodAdapter.getChar(string2, n)) {
            case 'L': {
                return CheckMethodAdapter.checkClassTypeSignature(string2, n);
            }
            case '[': {
                return CheckMethodAdapter.checkTypeSignature(string2, n + 1);
            }
        }
        return CheckMethodAdapter.checkTypeVariableSignature(string2, n);
    }

    private static int checkClassTypeSignature(String string2, int n) {
        n = CheckMethodAdapter.checkChar('L', string2, n);
        n = CheckMethodAdapter.checkIdentifier(string2, n);
        while (CheckMethodAdapter.getChar(string2, n) == '/') {
            n = CheckMethodAdapter.checkIdentifier(string2, n + 1);
        }
        if (CheckMethodAdapter.getChar(string2, n) == '<') {
            n = CheckMethodAdapter.checkTypeArguments(string2, n);
        }
        while (CheckMethodAdapter.getChar(string2, n) == '.') {
            if (CheckMethodAdapter.getChar(string2, n = CheckMethodAdapter.checkIdentifier(string2, n + 1)) != '<') continue;
            n = CheckMethodAdapter.checkTypeArguments(string2, n);
        }
        return CheckMethodAdapter.checkChar(';', string2, n);
    }

    private static int checkTypeArguments(String string2, int n) {
        n = CheckMethodAdapter.checkChar('<', string2, n);
        n = CheckMethodAdapter.checkTypeArgument(string2, n);
        while (CheckMethodAdapter.getChar(string2, n) != '>') {
            n = CheckMethodAdapter.checkTypeArgument(string2, n);
        }
        return n + 1;
    }

    private static int checkTypeArgument(String string2, int n) {
        char c2 = CheckMethodAdapter.getChar(string2, n);
        if (c2 == '*') {
            return n + 1;
        }
        if (c2 == '+' || c2 == '-') {
            ++n;
        }
        return CheckMethodAdapter.checkFieldTypeSignature(string2, n);
    }

    private static int checkTypeVariableSignature(String string2, int n) {
        n = CheckMethodAdapter.checkChar('T', string2, n);
        n = CheckMethodAdapter.checkIdentifier(string2, n);
        return CheckMethodAdapter.checkChar(';', string2, n);
    }

    private static int checkTypeSignature(String string2, int n) {
        switch (CheckMethodAdapter.getChar(string2, n)) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                return n + 1;
            }
        }
        return CheckMethodAdapter.checkFieldTypeSignature(string2, n);
    }

    private static int checkIdentifier(String string2, int n) {
        if (!Character.isJavaIdentifierStart(CheckMethodAdapter.getChar(string2, n))) {
            throw new IllegalArgumentException(string2 + ": identifier expected at index " + n);
        }
        ++n;
        while (Character.isJavaIdentifierPart(CheckMethodAdapter.getChar(string2, n))) {
            ++n;
        }
        return n;
    }

    private static int checkChar(char c2, String string2, int n) {
        if (CheckMethodAdapter.getChar(string2, n) == c2) {
            return n + 1;
        }
        throw new IllegalArgumentException(string2 + ": '" + c2 + "' expected at index " + n);
    }

    private static char getChar(String string2, int n) {
        return n < string2.length() ? string2.charAt(n) : (char)'\u0000';
    }

    void checkLabel(Label label, boolean bl, String string2) {
        if (label == null) {
            throw new IllegalArgumentException("Invalid " + string2 + " (must not be null)");
        }
        if (bl && this.labels.get(label) == null) {
            throw new IllegalArgumentException("Invalid " + string2 + " (must be visited first)");
        }
    }

    private static void checkNonDebugLabel(Label label) {
        Field field2 = CheckMethodAdapter.getLabelStatusField();
        int n = 0;
        try {
            n = field2 == null ? 0 : (Integer)field2.get(label);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new Error("Internal error");
        }
        if ((n & 1) != 0) {
            throw new IllegalArgumentException("Labels used for debug info cannot be reused for control flow");
        }
    }

    private static Field getLabelStatusField() {
        if (labelStatusField == null && (labelStatusField = CheckMethodAdapter.getLabelField("a")) == null) {
            labelStatusField = CheckMethodAdapter.getLabelField("status");
        }
        return labelStatusField;
    }

    private static Field getLabelField(String string2) {
        try {
            Field field2 = Label.class.getDeclaredField(string2);
            field2.setAccessible(true);
            return field2;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
    }

    static {
        String string2 = "BBBBBBBBBBBBBBBBCCIAADDDDDAAAAAAAAAAAAAAAAAAAABBBBBBBBDDDDDAAAAAAAAAAAAAAAAAAAABBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBJBBBBBBBBBBBBBBBBBBBBHHHHHHHHHHHHHHHHDKLBBBBBBFFFFGGGGAECEBBEEBBAMHHAA";
        TYPE = new int[string2.length()];
        for (int i = 0; i < TYPE.length; ++i) {
            CheckMethodAdapter.TYPE[i] = string2.charAt(i) - 65 - 1;
        }
    }
}

