/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler;

import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import sf.util.CommandLineParser;
import sf.util.Utility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LauncherMain {
    private static final Logger LOGGER = Logger.getLogger(LauncherMain.class.getName());
    private static final String LIB_DIR = "./lib";

    public static void main(String[] args2) {
        LauncherMain.setLogLevel(args2);
        if (args2.length == 0) {
            LauncherMain.fail("No class to launch was specified.");
        }
        String launchClass = args2[0];
        List<URL> classpath = LauncherMain.search(LIB_DIR);
        List<String> launchOptions = Arrays.asList(args2).subList(1, args2.length);
        String[] launchArgs = launchOptions.toArray(new String[launchOptions.size()]);
        LauncherMain.launch(classpath, launchClass, launchArgs);
    }

    private static void addJarFileToClasspath(File jarFile, Collection<URL> classpath) {
        URL url = LauncherMain.toURL(jarFile);
        if (url != null) {
            LOGGER.log(Level.INFO, "Adding " + jarFile);
            classpath.add(url);
        }
    }

    private static void fail(String message) {
        LauncherMain.fail(message, null);
    }

    private static void fail(String message, Exception e2) {
        if (e2 != null) {
            LOGGER.log(Level.SEVERE, message, e2);
        } else {
            LOGGER.log(Level.SEVERE, message);
        }
        System.exit(-1);
    }

    private static void launch(List<URL> classpath, String launchClassName, String[] args2) {
        try {
            URL[] classpathURLs = classpath.toArray(new URL[classpath.size()]);
            URLClassLoader newLoader = new URLClassLoader(classpathURLs, null);
            Thread.currentThread().setContextClassLoader(newLoader);
            LOGGER.log(Level.INFO, "Lauching " + launchClassName + " -" + Arrays.toString(args2));
            Class<?> launchClass = newLoader.loadClass(launchClassName);
            Method main2 = launchClass.getMethod("main", String[].class);
            main2.invoke(null, new Object[]{args2});
        }
        catch (ClassNotFoundException ex2) {
            LauncherMain.fail(String.format("Class '%s' not found", launchClassName));
        }
        catch (NoSuchMethodException ex3) {
            LauncherMain.fail(String.format("Class '%s' does not contain a main() method", launchClassName));
        }
        catch (Exception e2) {
            LauncherMain.fail(String.format("Error invoking method main() of %s", launchClassName), e2);
        }
    }

    private static List<URL> search(String directoryName) {
        ArrayList<URL> classpath = new ArrayList<URL>();
        File dir = LauncherMain.toDir(directoryName);
        if (dir != null) {
            File[] jarFiles;
            for (File jarFile : jarFiles = dir.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.endsWith(".jar");
                }
            })) {
                LauncherMain.addJarFileToClasspath(jarFile, classpath);
            }
        }
        return classpath;
    }

    private static void setLogLevel(String[] args2) {
        String OPTION_loglevel = "loglevel";
        CommandLineParser parser = new CommandLineParser();
        parser.addOption(new CommandLineParser.StringOption('\u0000', "loglevel", "OFF"));
        parser.parse(args2);
        String logLevelString = parser.getStringOptionValue("loglevel");
        Level logLevel = Level.parse(logLevelString.toUpperCase(Locale.ENGLISH));
        Utility.setApplicationLogLevel(logLevel);
    }

    private static File toDir(String directoryName) {
        File dir = new File(directoryName);
        if (!dir.exists()) {
            LOGGER.log(Level.WARNING, String.format("Directory %s does not exist", directoryName));
            return null;
        }
        if (!dir.isDirectory()) {
            LOGGER.log(Level.WARNING, String.format("%s is not a directory", directoryName));
            return null;
        }
        return dir;
    }

    private static URL toURL(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException ex2) {
            LOGGER.log(Level.WARNING, String.format("Cannot convert %s to a URL", file), ex2);
            return null;
        }
    }

    private LauncherMain() {
    }
}

