/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import schemacrawler.crawl.DatabaseSystemParameters;
import schemacrawler.crawl.MutableColumnDataType;
import schemacrawler.crawl.MutableDatabase;
import schemacrawler.crawl.MutableProcedure;
import schemacrawler.crawl.MutableSchema;
import schemacrawler.crawl.MutableTable;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.crawl.SchemaReference;
import schemacrawler.schema.DatabaseObject;
import sf.util.Utility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractRetriever {
    static final String UNKNOWN = "<unknown>";
    private final RetrieverConnection retrieverConnection;
    final MutableDatabase database;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<String> readResultsVector(ResultSet results2) throws SQLException {
        ArrayList<String> values2 = new ArrayList<String>();
        try {
            while (results2.next()) {
                String value2 = results2.getString(1);
                values2.add(value2);
            }
        }
        finally {
            results2.close();
        }
        return values2;
    }

    AbstractRetriever() throws SQLException {
        this(null, null);
    }

    AbstractRetriever(RetrieverConnection retrieverConnection, MutableDatabase database) throws SQLException {
        this.retrieverConnection = retrieverConnection;
        this.database = database;
    }

    boolean belongsToSchema(DatabaseObject dbObject, String catalogName, String schemaName) {
        if (dbObject == null) {
            return false;
        }
        boolean belongsToCatalog = true;
        boolean belongsToSchema = true;
        String dbObjectCatalogName = dbObject.getSchema().getCatalogName();
        if (catalogName != null && !this.unquotedName(catalogName).equals(this.unquotedName(dbObjectCatalogName))) {
            belongsToCatalog = false;
        }
        String dbObjectSchemaName = dbObject.getSchema().getSchemaName();
        if (schemaName != null && !this.unquotedName(schemaName).equals(this.unquotedName(dbObjectSchemaName))) {
            belongsToSchema = false;
        }
        return belongsToCatalog && belongsToSchema;
    }

    Connection getDatabaseConnection() {
        return this.retrieverConnection.getConnection();
    }

    DatabaseMetaData getMetaData() {
        return this.retrieverConnection.getMetaData();
    }

    RetrieverConnection getRetrieverConnection() {
        return this.retrieverConnection;
    }

    Collection<SchemaReference> getSchemaNames() {
        return this.database.getSchemaNames();
    }

    MutableColumnDataType lookupColumnDataTypeByType(MutableSchema schema, int type) {
        MutableColumnDataType columnDataType = schema.lookupColumnDataTypeByType(type);
        if (columnDataType == null) {
            columnDataType = this.database.getSystemColumnDataTypesList().lookupColumnDataTypeByType(type);
        }
        return columnDataType;
    }

    MutableColumnDataType lookupOrCreateColumnDataType(MutableSchema schema, int javaSqlType, String databaseSpecificTypeName) {
        MutableColumnDataType columnDataType = schema.getColumnDataType(databaseSpecificTypeName);
        if (columnDataType == null) {
            columnDataType = this.database.getSystemColumnDataType(databaseSpecificTypeName);
        }
        if (columnDataType == null) {
            columnDataType = new MutableColumnDataType(schema, databaseSpecificTypeName);
            columnDataType.setType(javaSqlType, null);
            schema.addColumnDataType(columnDataType);
        }
        return columnDataType;
    }

    MutableProcedure lookupProcedure(String catalogName, String schemaName, String procedureName) {
        MutableProcedure procedure = null;
        MutableSchema schema = this.lookupSchema(catalogName, schemaName);
        if (schema != null) {
            procedure = schema.getProcedure(procedureName);
        }
        return procedure;
    }

    MutableSchema lookupSchema(String catalogName, String schemaName) {
        SchemaReference schemaRef = new SchemaReference(catalogName, schemaName);
        return this.database.getSchema(schemaRef);
    }

    MutableTable lookupTable(String catalogName, String schemaName, String tableName) {
        MutableTable table2 = null;
        MutableSchema schema = this.lookupSchema(catalogName, schemaName);
        if (schema != null) {
            table2 = schema.getTable(tableName);
        }
        return table2;
    }

    String quotedName(String name) {
        String quotedName;
        DatabaseSystemParameters dbSystemParameters = this.getRetrieverConnection().getDatabaseSystemParameters();
        if (dbSystemParameters != null && !Utility.isBlank(name)) {
            String identifierQuoteString = dbSystemParameters.getIdentifierQuoteString();
            quotedName = dbSystemParameters.needsToBeQuoted(name) ? identifierQuoteString + name + identifierQuoteString : name;
        } else {
            quotedName = name;
        }
        return quotedName;
    }

    String unquotedName(String name) {
        String unquotedName;
        DatabaseSystemParameters dbSystemParameters = this.getRetrieverConnection().getDatabaseSystemParameters();
        if (dbSystemParameters != null && !Utility.isBlank(name)) {
            String identifierQuoteString = dbSystemParameters.getIdentifierQuoteString();
            if (name.startsWith(identifierQuoteString) && name.endsWith(identifierQuoteString)) {
                int quoteLength = identifierQuoteString.length();
                unquotedName = name.substring(quoteLength, name.length() - quoteLength);
            } else {
                unquotedName = name;
            }
        } else {
            unquotedName = name;
        }
        return unquotedName;
    }
}

