/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import sf.util.Utility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MetadataResultSet {
    private static final Logger LOGGER = Logger.getLogger(MetadataResultSet.class.getName());
    private static final int FETCHSIZE = 20;
    private final ResultSet results;
    private final List<String> resultSetColumns;
    private Set<String> readColumns;

    MetadataResultSet(ResultSet resultSet) throws SQLException {
        if (resultSet == null) {
            throw new IllegalArgumentException("Cannot use null results");
        }
        this.results = resultSet;
        try {
            this.results.setFetchSize(20);
        }
        catch (NullPointerException e2) {
            LOGGER.log(Level.WARNING, "Could not set fetch size", e2);
        }
        catch (SQLException e3) {
            LOGGER.log(Level.WARNING, "Could not set fetch size", e3);
        }
        ArrayList<String> resultSetColumns = new ArrayList<String>();
        try {
            ResultSetMetaData rsMetaData = resultSet.getMetaData();
            for (int i = 0; i < rsMetaData.getColumnCount(); ++i) {
                String columnName2 = rsMetaData.getColumnLabel(i + 1);
                if (Utility.isBlank(columnName2)) {
                    columnName2 = rsMetaData.getColumnName(i + 1);
                }
                resultSetColumns.add(columnName2);
            }
        }
        catch (SQLException e4) {
            LOGGER.log(Level.WARNING, "Could not get columns list");
        }
        this.resultSetColumns = Collections.unmodifiableList(resultSetColumns);
        this.readColumns = new HashSet<String>();
    }

    private boolean useColumn(String columnName2) {
        boolean useColumn;
        boolean bl = useColumn = columnName2 != null && this.resultSetColumns.contains(columnName2);
        if (useColumn) {
            this.readColumns.add(columnName2);
        }
        return useColumn;
    }

    void close() throws SQLException {
        this.results.close();
    }

    Map<String, Object> getAttributes() {
        HashMap<String, Object> attributes2 = new HashMap<String, Object>();
        for (String columnName2 : this.resultSetColumns) {
            if (this.readColumns.contains(columnName2)) continue;
            try {
                Object value2 = this.results.getObject(columnName2);
                attributes2.put(columnName2, value2);
            }
            catch (SQLException e2) {
                LOGGER.log(Level.WARNING, "Could not read value for column " + columnName2, e2);
            }
        }
        return attributes2;
    }

    boolean getBoolean(String columnName2) {
        boolean value2 = false;
        if (this.useColumn(columnName2)) {
            try {
                Object booleanValue = this.results.getObject(columnName2);
                String stringBooleanValue = this.results.wasNull() || booleanValue == null ? null : String.valueOf(booleanValue);
                if (!Utility.isBlank(stringBooleanValue)) {
                    try {
                        int booleanInt = Integer.parseInt(stringBooleanValue);
                        value2 = booleanInt != 0;
                    }
                    catch (NumberFormatException e2) {
                        value2 = stringBooleanValue.equalsIgnoreCase("YES") || Boolean.valueOf(stringBooleanValue) != false;
                    }
                }
            }
            catch (SQLException e3) {
                LOGGER.log(Level.WARNING, "Could not read boolean value for column " + columnName2, e3);
            }
        }
        return value2;
    }

    <E extends Enum<E>> E getEnum(String columnName2, E defaultValue) {
        Object enumValue;
        String value2 = this.getString(columnName2);
        if (value2 == null || defaultValue == null) {
            enumValue = defaultValue;
        } else {
            try {
                enumValue = Enum.valueOf(defaultValue.getClass(), value2.toLowerCase(Locale.ENGLISH));
            }
            catch (Exception e2) {
                enumValue = defaultValue;
            }
        }
        return enumValue;
    }

    int getInt(String columnName2, int defaultValue) {
        int value2 = defaultValue;
        if (this.useColumn(columnName2)) {
            try {
                value2 = this.results.getInt(columnName2);
                if (this.results.wasNull()) {
                    value2 = defaultValue;
                }
                return value2;
            }
            catch (SQLException e2) {
                LOGGER.log(Level.WARNING, "Could not read integer value for column " + columnName2, e2);
            }
        }
        return value2;
    }

    long getLong(String columnName2, long defaultValue) {
        long value2 = defaultValue;
        if (this.useColumn(columnName2)) {
            try {
                value2 = this.results.getLong(columnName2);
                if (this.results.wasNull()) {
                    value2 = defaultValue;
                }
                return value2;
            }
            catch (SQLException e2) {
                LOGGER.log(Level.WARNING, "Could not read long value for column " + columnName2, e2);
            }
        }
        return value2;
    }

    short getShort(String columnName2, short defaultValue) {
        short value2 = defaultValue;
        if (this.useColumn(columnName2)) {
            try {
                value2 = this.results.getShort(columnName2);
                if (this.results.wasNull()) {
                    value2 = defaultValue;
                }
                return value2;
            }
            catch (SQLException e2) {
                LOGGER.log(Level.WARNING, "Could not read short value for column " + columnName2, e2);
            }
        }
        return value2;
    }

    String getString(String columnName2) {
        String value2 = null;
        if (this.useColumn(columnName2)) {
            try {
                value2 = this.results.getString(columnName2);
                if (this.results.wasNull()) {
                    value2 = null;
                }
            }
            catch (SQLException e2) {
                LOGGER.log(Level.WARNING, "Could not read string value for column " + columnName2, e2);
            }
        }
        return value2;
    }

    boolean next() throws SQLException {
        this.readColumns = new HashSet<String>();
        return this.results.next();
    }
}

