/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import schemacrawler.crawl.AbstractDependantObject;
import schemacrawler.crawl.MutableIndexColumn;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.schema.Index;
import schemacrawler.schema.IndexColumn;
import schemacrawler.schema.IndexType;
import schemacrawler.schema.NamedObject;
import schemacrawler.schema.Table;

class MutableIndex
extends AbstractDependantObject
implements Index {
    private static final long serialVersionUID = 4051326747138079028L;
    private final NamedObjectList<MutableIndexColumn> columns = new NamedObjectList();
    private boolean isUnique;
    private IndexType type = IndexType.unknown;
    private int cardinality;
    private int pages;

    MutableIndex(Table parent2, String name) {
        super(parent2, name);
    }

    public int compareTo(NamedObject obj) {
        if (obj == null) {
            return -1;
        }
        Index other = (Index)obj;
        int comparison = 0;
        IndexColumn[] thisColumns = this.getColumns();
        IndexColumn[] otherColumns = other.getColumns();
        if (comparison == 0) {
            comparison = thisColumns.length - otherColumns.length;
        }
        if (comparison == 0) {
            for (int i = 0; i < thisColumns.length; ++i) {
                IndexColumn thisColumn = thisColumns[i];
                IndexColumn otherColumn = otherColumns[i];
                if (comparison != 0) break;
                comparison = thisColumn.compareTo(otherColumn);
            }
        }
        if (comparison == 0) {
            comparison = super.compareTo(other);
        }
        return comparison;
    }

    public final int getCardinality() {
        return this.cardinality;
    }

    public IndexColumn[] getColumns() {
        return this.columns.values().toArray(new IndexColumn[this.columns.size()]);
    }

    public final int getPages() {
        return this.pages;
    }

    public final IndexType getType() {
        return this.type;
    }

    public boolean isUnique() {
        return this.isUnique;
    }

    void addColumn(MutableIndexColumn column) {
        this.columns.add(column);
    }

    final void setCardinality(int cardinality) {
        this.cardinality = cardinality;
    }

    final void setPages(int pages) {
        this.pages = pages;
    }

    final void setType(IndexType type) {
        this.type = type;
    }

    final void setUnique(boolean unique2) {
        this.isUnique = unique2;
    }
}

