/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import schemacrawler.crawl.AbstractDependantObject;
import schemacrawler.crawl.MutableColumn;
import schemacrawler.schema.Column;
import schemacrawler.schema.ColumnDataType;
import schemacrawler.schema.Index;
import schemacrawler.schema.IndexColumn;
import schemacrawler.schema.IndexColumnSortSequence;
import schemacrawler.schema.NamedObject;
import schemacrawler.schema.Privilege;

final class MutableIndexColumn
extends AbstractDependantObject
implements IndexColumn {
    private static final long serialVersionUID = -6923211341742623556L;
    private final Column column;
    private final Index index;
    private int indexOrdinalPosition;
    private IndexColumnSortSequence sortSequence;

    MutableIndexColumn(Index index2, MutableColumn column) {
        super(column.getParent(), column.getName());
        this.index = index2;
        this.column = column;
    }

    public int compareTo(NamedObject obj) {
        if (obj == null) {
            return -1;
        }
        MutableIndexColumn other = (MutableIndexColumn)obj;
        int comparison = 0;
        if (comparison == 0) {
            comparison = this.indexOrdinalPosition - other.indexOrdinalPosition;
        }
        if (comparison == 0) {
            comparison = super.compareTo(other);
        }
        return comparison;
    }

    public int getDecimalDigits() {
        return this.column.getDecimalDigits();
    }

    public String getDefaultValue() {
        return this.column.getDefaultValue();
    }

    public Index getIndex() {
        return this.index;
    }

    public int getIndexOrdinalPosition() {
        return this.indexOrdinalPosition;
    }

    public int getOrdinalPosition() {
        return this.column.getOrdinalPosition();
    }

    public Privilege getPrivilege(String name) {
        return this.column.getPrivilege(name);
    }

    public Privilege[] getPrivileges() {
        return this.column.getPrivileges();
    }

    public Column getReferencedColumn() {
        return this.column.getReferencedColumn();
    }

    public int getSize() {
        return this.column.getSize();
    }

    public IndexColumnSortSequence getSortSequence() {
        return this.sortSequence;
    }

    public ColumnDataType getType() {
        return this.column.getType();
    }

    public String getWidth() {
        return this.column.getWidth();
    }

    public boolean isNullable() {
        return this.column.isNullable();
    }

    public boolean isPartOfForeignKey() {
        return this.column.isPartOfForeignKey();
    }

    public boolean isPartOfPrimaryKey() {
        return this.column.isPartOfPrimaryKey();
    }

    public boolean isPartOfUniqueIndex() {
        return this.column.isPartOfUniqueIndex();
    }

    void setIndexOrdinalPosition(int indexOrdinalPosition) {
        this.indexOrdinalPosition = indexOrdinalPosition;
    }

    void setSortSequence(IndexColumnSortSequence sortSequence) {
        this.sortSequence = sortSequence;
    }
}

