/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import schemacrawler.crawl.MutableJdbcDriverProperty;
import schemacrawler.schema.JdbcDriverInfo;
import schemacrawler.schema.JdbcDriverProperty;

final class MutableJdbcDriverInfo
implements JdbcDriverInfo {
    private static final long serialVersionUID = 8030156654422512161L;
    private static final String NEWLINE = System.getProperty("line.separator");
    private String driverName;
    private String driverClassName;
    private String driverVersion;
    private String connectionUrl;
    private boolean jdbcCompliant;
    private final Set<MutableJdbcDriverProperty> jdbcDriverProperties = new HashSet<MutableJdbcDriverProperty>();

    MutableJdbcDriverInfo() {
    }

    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public JdbcDriverProperty[] getDriverProperties() {
        Object[] properties2 = this.jdbcDriverProperties.toArray(new JdbcDriverProperty[this.jdbcDriverProperties.size()]);
        Arrays.sort(properties2);
        return properties2;
    }

    public String getDriverVersion() {
        return this.driverVersion;
    }

    public boolean isJdbcCompliant() {
        return this.jdbcCompliant;
    }

    public String toString() {
        StringBuilder info2 = new StringBuilder();
        info2.append("-- driver: ").append(this.getDriverName()).append(" ").append(this.getDriverVersion()).append(NEWLINE);
        info2.append("-- driver class: ").append(this.getDriverClassName()).append(NEWLINE);
        info2.append("-- url: ").append(this.getConnectionUrl()).append(NEWLINE);
        info2.append("-- jdbc compliant: ").append(this.isJdbcCompliant());
        return info2.toString();
    }

    void addJdbcDriverProperty(MutableJdbcDriverProperty jdbcDriverProperty) {
        this.jdbcDriverProperties.add(jdbcDriverProperty);
    }

    void setConnectionUrl(String connectionUrl) {
        this.connectionUrl = connectionUrl;
    }

    void setDriverName(String driverName) {
        this.driverName = driverName;
    }

    void setDriverVersion(String driverVersion) {
        this.driverVersion = driverVersion;
    }

    void setJdbcCompliant(boolean jdbcCompliant) {
        this.jdbcCompliant = jdbcCompliant;
    }

    void setJdbcDriverClassName(String jdbcDriverClassName) {
        this.driverClassName = jdbcDriverClassName;
    }
}

