/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import schemacrawler.crawl.AbstractDependantObject;
import schemacrawler.schema.DatabaseObject;
import schemacrawler.schema.Privilege;
import sf.util.Utility;

final class MutablePrivilege
extends AbstractDependantObject
implements Privilege {
    private final Set<Privilege.Grant> grants = new HashSet<Privilege.Grant>();
    private static final long serialVersionUID = -1117664231494271886L;

    MutablePrivilege(DatabaseObject parent2, String name) {
        super(parent2, name);
    }

    public Privilege.Grant[] getGrants() {
        Object[] grantsArray = this.grants.toArray(new Privilege.Grant[this.grants.size()]);
        Arrays.sort(grantsArray);
        return grantsArray;
    }

    void addGrant(String grantor, String grantee, boolean isGrantable) {
        if (!Utility.isBlank(grantor) && !Utility.isBlank(grantee)) {
            this.grants.add(new PrivilegeGrant(grantor, grantee, isGrantable));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class PrivilegeGrant
    implements Privilege.Grant,
    Comparable<Privilege.Grant> {
        private static final long serialVersionUID = 356151825191631484L;
        private final String grantor;
        private final String grantee;
        private final boolean isGrantable;

        PrivilegeGrant(String grantor, String grantee, boolean isGrantable) {
            this.grantor = grantor;
            this.grantee = grantee;
            this.isGrantable = isGrantable;
        }

        @Override
        public int compareTo(Privilege.Grant otherGrant) {
            int compare2 = 0;
            if (compare2 == 0) {
                compare2 = this.grantor.compareTo(otherGrant.getGrantor());
            }
            if (compare2 == 0) {
                compare2 = this.grantee.compareTo(otherGrant.getGrantee());
            }
            return compare2;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PrivilegeGrant other = (PrivilegeGrant)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.grantee == null ? other.grantee != null : !this.grantee.equals(other.grantee)) {
                return false;
            }
            if (this.grantor == null ? other.grantor != null : !this.grantor.equals(other.grantor)) {
                return false;
            }
            return this.isGrantable == other.isGrantable;
        }

        @Override
        public String getGrantee() {
            return this.grantee;
        }

        @Override
        public String getGrantor() {
            return this.grantor;
        }

        public int hashCode() {
            int prime = 31;
            int result2 = 1;
            result2 = 31 * result2 + this.getOuterType().hashCode();
            result2 = 31 * result2 + (this.grantee == null ? 0 : this.grantee.hashCode());
            result2 = 31 * result2 + (this.grantor == null ? 0 : this.grantor.hashCode());
            result2 = 31 * result2 + (this.isGrantable ? 1231 : 1237);
            return result2;
        }

        @Override
        public boolean isGrantable() {
            return this.isGrantable;
        }

        private MutablePrivilege getOuterType() {
            return MutablePrivilege.this;
        }
    }
}

