/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.Arrays;
import java.util.Iterator;
import schemacrawler.crawl.AbstractNamedObject;
import schemacrawler.crawl.MutableResultsColumn;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.schema.ResultsColumn;
import schemacrawler.schema.ResultsColumns;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MutableResultsColumns
extends AbstractNamedObject
implements ResultsColumns {
    private static final long serialVersionUID = 5204766782914559188L;
    private final NamedObjectList<MutableResultsColumn> columns = new NamedObjectList();

    MutableResultsColumns(String name) {
        super(name);
    }

    @Override
    public ResultsColumn getColumn(String name) {
        return this.columns.lookup(name);
    }

    @Override
    public ResultsColumn[] getColumns() {
        return this.columns.values().toArray(new ResultsColumn[this.columns.size()]);
    }

    @Override
    public String getColumnsListAsString() {
        String columnsList = "";
        ResultsColumn[] columnsArray = this.getColumns();
        if (columnsArray != null && columnsArray.length > 0) {
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < columnsArray.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                ResultsColumn column = columnsArray[i];
                buffer.append(column.getFullName());
            }
            columnsList = buffer.toString();
        }
        return columnsList;
    }

    @Override
    public Iterator<ResultsColumn> iterator() {
        return Arrays.asList(this.getColumns()).iterator();
    }

    void addColumn(MutableResultsColumn column) {
        this.columns.add(column);
    }
}

