/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import schemacrawler.crawl.NamedObjectSort;
import schemacrawler.schema.NamedObject;
import sf.util.Utility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NamedObjectList<N extends NamedObject>
implements Serializable,
Iterable<N> {
    private static final long serialVersionUID = 3257847666804142128L;
    private NamedObjectSort sort = NamedObjectSort.natural;
    private final Map<String, N> objects = new HashMap<String, N>();

    NamedObjectList() {
    }

    private static String makeLookupKey(NamedObject namedObject) {
        String key = namedObject == null ? null : namedObject.getFullName();
        return key;
    }

    private static String makeLookupKey(NamedObject namedObject, String name) {
        StringBuilder buffer = new StringBuilder(256);
        String namedObjectLookupKey = NamedObjectList.makeLookupKey(namedObject);
        if (namedObjectLookupKey != null) {
            buffer.append(namedObjectLookupKey);
        }
        if (buffer.length() > 0) {
            buffer.append(".");
        }
        buffer.append(name);
        String key = buffer.toString();
        return key;
    }

    private static String makeLookupKey(String fullName) {
        String key = Utility.isBlank(fullName) ? null : fullName;
        return key;
    }

    @Override
    public Iterator<N> iterator() {
        return this.values().iterator();
    }

    public String toString() {
        return this.values().toString();
    }

    void add(N namedObject) {
        if (namedObject == null) {
            throw new IllegalArgumentException("Cannot add a null object to the list");
        }
        String key = NamedObjectList.makeLookupKey(namedObject);
        this.objects.put(key, namedObject);
    }

    boolean isEmpty() {
        return this.objects.isEmpty();
    }

    N lookup(NamedObject namedObject, String name) {
        String key = NamedObjectList.makeLookupKey(namedObject, name);
        return (N)((NamedObject)this.objects.get(key));
    }

    N lookup(String fullName) {
        String key = NamedObjectList.makeLookupKey(fullName);
        return (N)((NamedObject)this.objects.get(key));
    }

    void remove(NamedObject namedObject) {
        if (namedObject != null) {
            this.objects.remove(NamedObjectList.makeLookupKey(namedObject));
        }
    }

    void setSortOrder(NamedObjectSort sort2) {
        this.sort = sort2;
    }

    int size() {
        return this.objects.size();
    }

    List<N> values() {
        ArrayList<N> all2 = new ArrayList<N>(this.objects.values());
        Collections.sort(all2, this.sort);
        return all2;
    }
}

