/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.AbstractRetriever;
import schemacrawler.crawl.MetadataResultSet;
import schemacrawler.crawl.MutableDatabase;
import schemacrawler.crawl.MutableProcedure;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.schema.RoutineBodyType;
import schemacrawler.schemacrawler.InformationSchemaViews;

final class ProcedureExRetriever
extends AbstractRetriever {
    private static final Logger LOGGER = Logger.getLogger(ProcedureExRetriever.class.getName());

    ProcedureExRetriever(RetrieverConnection retrieverConnection, MutableDatabase database) throws SQLException {
        super(retrieverConnection, database);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void retrieveProcedureInformation() throws SQLException {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasRoutinesSql()) {
            LOGGER.log(Level.FINE, "Procedure definition SQL statement was not provided");
            return;
        }
        String procedureDefinitionsSql = informationSchemaViews.getRoutines();
        Connection connection = this.getDatabaseConnection();
        Statement statement = connection.createStatement();
        MetadataResultSet results2 = null;
        try {
            results2 = new MetadataResultSet(statement.executeQuery(procedureDefinitionsSql));
        }
        catch (SQLException e2) {
            LOGGER.log(Level.WARNING, "Could not retrieve procedure information", e2);
            return;
        }
        try {
            while (results2.next()) {
                String procedureName;
                String schemaName;
                String catalogName = this.quotedName(results2.getString("ROUTINE_CATALOG"));
                MutableProcedure procedure = this.lookupProcedure(catalogName, schemaName = this.quotedName(results2.getString("ROUTINE_SCHEMA")), procedureName = this.quotedName(results2.getString("ROUTINE_NAME")));
                if (procedure == null) continue;
                LOGGER.log(Level.FINER, "Retrieving procedure information: " + procedureName);
                RoutineBodyType routineBodyType = results2.getEnum("ROUTINE_BODY", RoutineBodyType.unknown);
                String definition = results2.getString("ROUTINE_DEFINITION");
                procedure.setRoutineBodyType(routineBodyType);
                procedure.appendDefinition(definition);
                procedure.addAttributes(results2.getAttributes());
            }
        }
        finally {
            if (results2 != null) {
                results2.close();
            }
            statement.close();
        }
    }
}

