/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.AbstractRetriever;
import schemacrawler.crawl.MetadataResultSet;
import schemacrawler.crawl.MutableDatabase;
import schemacrawler.crawl.MutableProcedure;
import schemacrawler.crawl.MutableProcedureColumn;
import schemacrawler.crawl.MutableSchema;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.schema.ProcedureColumnType;
import schemacrawler.schema.ProcedureType;
import schemacrawler.schemacrawler.InclusionRule;

final class ProcedureRetriever
extends AbstractRetriever {
    private static final Logger LOGGER = Logger.getLogger(ProcedureRetriever.class.getName());

    ProcedureRetriever(RetrieverConnection retrieverConnection, MutableDatabase database) throws SQLException {
        super(retrieverConnection, database);
    }

    void retrieveProcedureColumns(MutableProcedure procedure, InclusionRule columnInclusionRule) throws SQLException {
        MetadataResultSet results2 = null;
        int ordinalNumber = 0;
        try {
            results2 = new MetadataResultSet(this.getMetaData().getProcedureColumns(this.unquotedName(procedure.getSchema().getCatalogName()), this.unquotedName(procedure.getSchema().getSchemaName()), this.unquotedName(procedure.getName()), null));
            while (results2.next()) {
                String columnCatalogName = this.quotedName(results2.getString("PROCEDURE_CAT"));
                String schemaName = this.quotedName(results2.getString("PROCEDURE_SCHEM"));
                String procedureName = this.quotedName(results2.getString("PROCEDURE_NAME"));
                String columnName2 = this.quotedName(results2.getString("COLUMN_NAME"));
                MutableProcedureColumn column = new MutableProcedureColumn(procedure, columnName2);
                String columnFullName = column.getFullName();
                if (!columnInclusionRule.include(columnFullName) || !procedure.getName().equals(procedureName) || !this.belongsToSchema(procedure, columnCatalogName, schemaName)) continue;
                LOGGER.log(Level.FINER, "Retrieving procedure column: " + columnName2);
                short columnType = results2.getShort("COLUMN_TYPE", (short)0);
                int dataType = results2.getInt("DATA_TYPE", 0);
                String typeName = results2.getString("TYPE_NAME");
                int length2 = results2.getInt("LENGTH", 0);
                int precision = results2.getInt("PRECISION", 0);
                boolean isNullable = results2.getShort("NULLABLE", (short)2) == 1;
                String remarks = results2.getString("REMARKS");
                column.setOrdinalPosition(ordinalNumber++);
                column.setProcedureColumnType(ProcedureColumnType.valueOf(columnType));
                column.setType(this.lookupOrCreateColumnDataType((MutableSchema)procedure.getSchema(), dataType, typeName));
                column.setSize(length2);
                column.setPrecision(precision);
                column.setNullable(isNullable);
                column.setRemarks(remarks);
                column.addAttributes(results2.getAttributes());
                procedure.addColumn(column);
            }
        }
        catch (SQLException e2) {
            SQLException sqlEx = new SQLException("Could not retrieve columns for procedure " + procedure + ": " + e2.getMessage());
            sqlEx.setNextException(e2);
            throw sqlEx;
        }
        finally {
            if (results2 != null) {
                results2.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void retrieveProcedures(String catalogName, String schemaName, InclusionRule procedureInclusionRule) throws SQLException {
        MetadataResultSet results2 = null;
        try {
            results2 = new MetadataResultSet(this.getMetaData().getProcedures(catalogName, schemaName, "%"));
            while (results2.next()) {
                String procedureName = this.quotedName(results2.getString("PROCEDURE_NAME"));
                LOGGER.log(Level.FINER, "Retrieving procedure: " + procedureName);
                short procedureType = results2.getShort("PROCEDURE_TYPE", (short)ProcedureType.unknown.getId());
                String remarks = results2.getString("REMARKS");
                MutableSchema schema = this.lookupSchema(catalogName, schemaName);
                if (schema == null) {
                    LOGGER.log(Level.FINE, String.format("Cannot find schema, %s.%s", catalogName, schemaName));
                    continue;
                }
                MutableProcedure procedure = new MutableProcedure(schema, procedureName);
                if (!procedureInclusionRule.include(procedure.getFullName())) continue;
                procedure.setType(ProcedureType.valueOf(procedureType));
                procedure.setRemarks(remarks);
                procedure.addAttributes(results2.getAttributes());
                schema.addProcedure(procedure);
            }
        }
        finally {
            if (results2 != null) {
                results2.close();
            }
        }
    }
}

